@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property architectureType The type of the architecture. Valid values: `cluster`, `standard` and `SplitRW`.
 * @property editionType Used to retrieve instances belong to specified `vswitch` resources.  Valid values: `Enterprise`, `Community`.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property engineVersion The engine version. Valid values: `2.8`, `4.0`, `5.0`, `6.0`, `7.0`.
 * @property expired The expiration status of the instance.
 * @property globalInstance Whether to create a distributed cache.
 * @property ids A list of KVStore DBInstance IDs.
 * @property instanceClass Type of the applied ApsaraDB for Redis instance. For more information, see [Instance type table](https://help.aliyun.com/zh/redis/developer-reference/instance-types).
 * @property instanceType The engine type of the KVStore DBInstance. Options are `Memcache`, and `Redis`. If no value is specified, all types are returned.
 * @property nameRegex A regex string to apply to the instance name.
 * @property networkType The type of the network. Valid values: `CLASSIC`, `VPC`.
 * @property outputFile The name of file that can save the collection of instances after running `pulumi preview`.
 * @property paymentType The payment type. Valid values: `PostPaid`, `PrePaid`.
 * @property resourceGroupId The ID of the resource group.
 * @property searchKey The name of the instance.
 * @property status The status of the KVStore DBInstance. Valid values: `Changing`, `CleaningUpExpiredData`, `Creating`, `Flushing`, `HASwitching`, `Inactive`, `MajorVersionUpgrading`, `Migrating`, `NetworkModifying`, `Normal`, `Rebooting`, `SSLModifying`, `Transforming`, `ZoneMigrating`.
 * @property tags Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
 * @property vpcId Used to retrieve instances belong to specified VPC.
 * @property vswitchId Used to retrieve instances belong to specified `vswitch` resources.
 * @property zoneId The ID of the zone.
 */
public data class GetInstancesPlainArgs(
    public val architectureType: String? = null,
    public val editionType: String? = null,
    public val enableDetails: Boolean? = null,
    public val engineVersion: String? = null,
    public val expired: String? = null,
    public val globalInstance: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceClass: String? = null,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetInstancesPlainArgs.builder()
            .architectureType(architectureType?.let({ args0 -> args0 }))
            .editionType(editionType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .expired(expired?.let({ args0 -> args0 }))
            .globalInstance(globalInstance?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .networkType(networkType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .searchKey(searchKey?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var architectureType: String? = null

    private var editionType: String? = null

    private var enableDetails: Boolean? = null

    private var engineVersion: String? = null

    private var expired: String? = null

    private var globalInstance: Boolean? = null

    private var ids: List<String>? = null

    private var instanceClass: String? = null

    private var instanceType: String? = null

    private var nameRegex: String? = null

    private var networkType: String? = null

    private var outputFile: String? = null

    private var paymentType: String? = null

    private var resourceGroupId: String? = null

    private var searchKey: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    private var zoneId: String? = null

    /**
     * @param value The type of the architecture. Valid values: `cluster`, `standard` and `SplitRW`.
     */
    @JvmName("xcuttqqubybghatb")
    public suspend fun architectureType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.architectureType = mapped
    }

    /**
     * @param value Used to retrieve instances belong to specified `vswitch` resources.  Valid values: `Enterprise`, `Community`.
     */
    @JvmName("vheepjienydmkfff")
    public suspend fun editionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.editionType = mapped
    }

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("tvyrysfrgayhbvls")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The engine version. Valid values: `2.8`, `4.0`, `5.0`, `6.0`, `7.0`.
     */
    @JvmName("dwykqdaofcpshfmj")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value The expiration status of the instance.
     */
    @JvmName("umlqsixhnppfeebi")
    public suspend fun expired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expired = mapped
    }

    /**
     * @param value Whether to create a distributed cache.
     */
    @JvmName("npuijldkrlopmbue")
    public suspend fun globalInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.globalInstance = mapped
    }

    /**
     * @param value A list of KVStore DBInstance IDs.
     */
    @JvmName("akdepxthctlpnysi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of KVStore DBInstance IDs.
     */
    @JvmName("truqjxqrlrkptebu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Type of the applied ApsaraDB for Redis instance. For more information, see [Instance type table](https://help.aliyun.com/zh/redis/developer-reference/instance-types).
     */
    @JvmName("mivfkerjydektsua")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value The engine type of the KVStore DBInstance. Options are `Memcache`, and `Redis`. If no value is specified, all types are returned.
     */
    @JvmName("nukludfpopkxdypt")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value A regex string to apply to the instance name.
     */
    @JvmName("csjvhrtfgosogpws")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The type of the network. Valid values: `CLASSIC`, `VPC`.
     */
    @JvmName("bhijndaiehtbeemy")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkType = mapped
    }

    /**
     * @param value The name of file that can save the collection of instances after running `pulumi preview`.
     */
    @JvmName("dqaceigrowyomule")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The payment type. Valid values: `PostPaid`, `PrePaid`.
     */
    @JvmName("hbphcjwmwvmnubcf")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("fwpouvielojeeful")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("kyogrvsqywcgtpgn")
    public suspend fun searchKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchKey = mapped
    }

    /**
     * @param value The status of the KVStore DBInstance. Valid values: `Changing`, `CleaningUpExpiredData`, `Creating`, `Flushing`, `HASwitching`, `Inactive`, `MajorVersionUpgrading`, `Migrating`, `NetworkModifying`, `Normal`, `Rebooting`, `SSLModifying`, `Transforming`, `ZoneMigrating`.
     */
    @JvmName("vwesmuugkqshmhxq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
     */
    @JvmName("ketarxhakdtubast")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
     */
    @JvmName("dtrjtlxxjlkagygq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Used to retrieve instances belong to specified VPC.
     */
    @JvmName("behjbxgkdutxnqan")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value Used to retrieve instances belong to specified `vswitch` resources.
     */
    @JvmName("xduejttohoonovih")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("urxnhkqpqlpvqgmh")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        architectureType = architectureType,
        editionType = editionType,
        enableDetails = enableDetails,
        engineVersion = engineVersion,
        expired = expired,
        globalInstance = globalInstance,
        ids = ids,
        instanceClass = instanceClass,
        instanceType = instanceType,
        nameRegex = nameRegex,
        networkType = networkType,
        outputFile = outputFile,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        searchKey = searchKey,
        status = status,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
