@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetPermissionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPermission.
 * @property enable Setting the value to `On` to assigns a RAM role to ApsaraDB for Redis. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
 */
public data class GetPermissionPlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetPermissionPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetPermissionPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetPermissionPlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionPlainArgs].
 */
@PulumiTagMarker
public class GetPermissionPlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to assigns a RAM role to ApsaraDB for Redis. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     */
    @JvmName("saxygqwmitemyyck")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetPermissionPlainArgs = GetPermissionPlainArgs(
        enable = enable,
    )
}
