@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
 * * product_type - (Optional, Available since v1.130.0+) The type of the service. Valid values: `Local`, `Tair_rdb`, `Tair_scm`, `Tair_essd`, `OnECS`.
 * @property instanceChargeType Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch KVStore instances.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productType
 */
public data class GetZonesPlainArgs(
    public val engine: String? = null,
    public val instanceChargeType: String? = null,
    public val multi: Boolean? = null,
    public val outputFile: String? = null,
    public val productType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetZonesPlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .multi(multi?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productType(productType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var instanceChargeType: String? = null

    private var multi: Boolean? = null

    private var outputFile: String? = null

    private var productType: String? = null

    /**
     * @param value Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     * * product_type - (Optional, Available since v1.130.0+) The type of the service. Valid values: `Local`, `Tair_rdb`, `Tair_scm`, `Tair_essd`, `OnECS`.
     */
    @JvmName("pgvmfebymoscpaoj")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("lrcpltyoffpqjhnt")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch KVStore instances.
     */
    @JvmName("jmdpicubrrgxpflt")
    public suspend fun multi(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multi = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kcshytkscqbgqrdk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("dntharcvwdwxnarv")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productType = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        engine = engine,
        instanceChargeType = instanceChargeType,
        multi = multi,
        outputFile = outputFile,
        productType = productType,
    )
}
