@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountName The name of the account.
 * @property accountPrivilege The privilege of account access database.
 * @property accountType Privilege type of account.
 * @property description The description of account.
 * @property id The ID of the Account.
 * @property instanceId The Id of instance in which account belongs.
 * @property status The status of account.
 */
public data class GetAccountsAccount(
    public val accountName: String,
    public val accountPrivilege: String,
    public val accountType: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountName = javaType.accountName(),
            accountPrivilege = javaType.accountPrivilege(),
            accountType = javaType.accountType(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            status = javaType.status(),
        )
    }
}
