@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionString The connection string of the instance.
 * @property dbInstanceNetType The network type of the instance.
 * @property expiredTime The expiration time of the classic network address.
 * @property id
 * @property instanceId
 * @property ipAddress The IP address of the instance.
 * @property port The port number of the instance.
 * @property upgradeable The remaining validity period of the endpoint of the classic network.
 * @property vpcId The ID of the VPC where the instance is deployed.
 * @property vpcInstanceId The ID of the instance. It is returned only when the value of the DBInstanceNetType parameter is 2 (indicating VPC).
 * @property vswitchId The ID of the vSwitch.
 */
public data class GetConnectionsConnection(
    public val connectionString: String,
    public val dbInstanceNetType: String,
    public val expiredTime: String,
    public val id: String,
    public val instanceId: String,
    public val ipAddress: String,
    public val port: String,
    public val upgradeable: String,
    public val vpcId: String,
    public val vpcInstanceId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetConnectionsConnection): GetConnectionsConnection = GetConnectionsConnection(
            connectionString = javaType.connectionString(),
            dbInstanceNetType = javaType.dbInstanceNetType(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ipAddress = javaType.ipAddress(),
            port = javaType.port(),
            upgradeable = javaType.upgradeable(),
            vpcId = javaType.vpcId(),
            vpcInstanceId = javaType.vpcInstanceId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
