@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConnections.
 * @property connections Public network details of the specified resource. contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of KVStore DBInstance ids.
 * @property outputFile
 */
public data class GetConnectionsResult(
    public val connections: List<GetConnectionsConnection>,
    public val id: String,
    public val ids: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetConnectionsResult): GetConnectionsResult = GetConnectionsResult(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kvstore.kotlin.outputs.GetConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
