@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceClasses.
 * @property architecture
 * @property classes A list of KVStore available instance classes when the `sorted_by` is "Price". include:
 * @property editionType
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceChargeType
 * @property instanceClasses A list of KVStore available instance classes.
 * @property nodeType
 * @property outputFile
 * @property packageType
 * @property performanceType
 * @property productType
 * @property seriesType
 * @property shardNumber
 * @property sortedBy
 * @property storageType
 * @property zoneId
 */
public data class GetInstanceClassesResult(
    public val architecture: String? = null,
    public val classes: List<GetInstanceClassesClass>,
    public val editionType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val id: String,
    public val instanceChargeType: String? = null,
    public val instanceClasses: List<String>,
    public val nodeType: String? = null,
    public val outputFile: String? = null,
    @Deprecated(
        message = """
  The parameter 'package_type' has been deprecated from 1.68.0.
  """,
    )
    public val packageType: String? = null,
    @Deprecated(
        message = """
  The parameter 'performance_type' has been deprecated from 1.68.0.
  """,
    )
    public val performanceType: String? = null,
    public val productType: String? = null,
    public val seriesType: String? = null,
    public val shardNumber: Int? = null,
    public val sortedBy: String? = null,
    @Deprecated(
        message = """
  The parameter 'storage_type' has been deprecated from 1.68.0.
  """,
    )
    public val storageType: String? = null,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetInstanceClassesResult): GetInstanceClassesResult = GetInstanceClassesResult(
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            classes = javaType.classes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceClassesClass.Companion.toKotlin(args0)
                })
            }),
            editionType = javaType.editionType().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            instanceClasses = javaType.instanceClasses().map({ args0 -> args0 }),
            nodeType = javaType.nodeType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            packageType = javaType.packageType().map({ args0 -> args0 }).orElse(null),
            performanceType = javaType.performanceType().map({ args0 -> args0 }).orElse(null),
            productType = javaType.productType().map({ args0 -> args0 }).orElse(null),
            seriesType = javaType.seriesType().map({ args0 -> args0 }).orElse(null),
            shardNumber = javaType.shardNumber().map({ args0 -> args0 }).orElse(null),
            sortedBy = javaType.sortedBy().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId(),
        )
    }
}
