@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
 * @property engineVersion Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
 * @property zoneId The Zone to launch the KVStore instance.
 */
public data class GetInstanceEnginesInstanceEngine(
    public val engine: String,
    public val engineVersion: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetInstanceEnginesInstanceEngine): GetInstanceEnginesInstanceEngine = GetInstanceEnginesInstanceEngine(
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            zoneId = javaType.zoneId(),
        )
    }
}
