@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceEngines.
 * @property engine Database type.
 * @property engineVersion KVStore Instance version.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceChargeType
 * @property instanceEngines A list of KVStore available instance engines. Each element contains the following attributes:
 * @property outputFile
 * @property zoneId The Zone to launch the KVStore instance.
 */
public data class GetInstanceEnginesResult(
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val id: String,
    public val instanceChargeType: String? = null,
    public val instanceEngines: List<GetInstanceEnginesInstanceEngine>,
    public val outputFile: String? = null,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetInstanceEnginesResult): GetInstanceEnginesResult = GetInstanceEnginesResult(
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            instanceEngines = javaType.instanceEngines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceEnginesInstanceEngine.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId(),
        )
    }
}
