@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property architectureType The type of the architecture. Valid values: `cluster`, `standard` and `SplitRW`.
 * @property autoRenew
 * @property autoRenewPeriod
 * @property availabilityZone It has been deprecated from provider version 1.101.0 and `zone_id` instead.
 * @property bandwidth Instance bandwidth limit. Unit: Mbit/s.
 * @property capacity Capacity of the applied ApsaraDB for the instance. Unit: MB.
 * @property chargeType It has been deprecated from provider version 1.101.0 and `payment_type` instead.
 * @property config The parameter configuration of the instance.
 * @property connectionDomain Instance connection domain (only Intranet access supported).
 * @property connectionMode The connection mode of the instance.
 * @property connections IIt has been deprecated from provider version 1.101.0 and `max_connections` instead.
 * @property createTime Creation time of the instance.
 * @property dbInstanceId The ID of the instance.
 * @property dbInstanceName The name of the instance.
 * @property destroyTime The time when the instance was destroyed.
 * @property endTime Expiration time. Pay-As-You-Go instances are never expire.
 * @property engineVersion The engine version. Valid values: `2.8`, `4.0`, `5.0`, `6.0`, `7.0`.
 * @property expireTime It has been deprecated from provider version 1.101.0 and `end_time` instead.
 * @property hasRenewChangeOrder Indicates whether there was an order of renewal with configuration change that had not taken effect.
 * @property id The ID of the instance.
 * @property instanceClass Type of the applied ApsaraDB for Redis instance. For more information, see [Instance type table](https://help.aliyun.com/zh/redis/developer-reference/instance-types).
 * @property instanceReleaseProtection
 * @property instanceType The engine type of the KVStore DBInstance. Options are `Memcache`, and `Redis`. If no value is specified, all types are returned.
 * @property isRds Indicates whether the instance is managed by Relational Database Service (RDS).
 * @property maintainEndTime
 * @property maintainStartTime
 * @property maxConnections Instance connection quantity limit. Unit: count.
 * @property name It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
 * @property networkType The type of the network. Valid values: `CLASSIC`, `VPC`.
 * @property nodeType The node type of the instance.
 * @property packageType The type of the package.
 * @property paymentType The payment type. Valid values: `PostPaid`, `PrePaid`.
 * @property port The service port of the instance.
 * @property privateIp Private IP address of the instance.
 * @property qps The queries per second (QPS) supported by the instance.
 * @property regionId Region ID the instance belongs to.
 * @property replacateId The logical ID of the replica instance.
 * @property resourceGroupId The ID of the resource group.
 * @property searchKey The name of the instance.
 * @property secondaryZoneId (Optional, Available in 1.128.0+) The ID of the secondary zone to which you want to migrate the ApsaraDB for Redis instance.
 * @property securityGroupId
 * @property securityIpGroupAttribute
 * @property securityIpGroupName
 * @property securityIps
 * @property sslEnable
 * @property status The status of the KVStore DBInstance. Valid values: `Changing`, `CleaningUpExpiredData`, `Creating`, `Flushing`, `HASwitching`, `Inactive`, `MajorVersionUpgrading`, `Migrating`, `NetworkModifying`, `Normal`, `Rebooting`, `SSLModifying`, `Transforming`, `ZoneMigrating`.
 * @property tags Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
 * @property userName The username of the instance.
 * @property vpcAuthMode
 * @property vpcCloudInstanceId Connection port of the instance.
 * @property vpcId Used to retrieve instances belong to specified VPC.
 * @property vswitchId Used to retrieve instances belong to specified `vswitch` resources.
 * @property zoneId The ID of the zone.
 */
public data class GetInstancesInstance(
    public val architectureType: String,
    public val autoRenew: Boolean,
    public val autoRenewPeriod: Int,
    public val availabilityZone: String,
    public val bandwidth: Int,
    public val capacity: Int,
    public val chargeType: String,
    public val config: Map<String, String>,
    public val connectionDomain: String,
    public val connectionMode: String,
    public val connections: Int,
    public val createTime: String,
    public val dbInstanceId: String,
    public val dbInstanceName: String,
    public val destroyTime: String,
    public val endTime: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val hasRenewChangeOrder: Boolean,
    public val id: String,
    public val instanceClass: String,
    public val instanceReleaseProtection: Boolean,
    public val instanceType: String,
    public val isRds: Boolean,
    public val maintainEndTime: String,
    public val maintainStartTime: String,
    public val maxConnections: Int,
    public val name: String,
    public val networkType: String,
    public val nodeType: String,
    public val packageType: String,
    public val paymentType: String,
    public val port: Int,
    public val privateIp: String,
    public val qps: Int,
    public val regionId: String,
    public val replacateId: String,
    public val resourceGroupId: String,
    public val searchKey: String,
    public val secondaryZoneId: String,
    public val securityGroupId: String,
    public val securityIpGroupAttribute: String,
    public val securityIpGroupName: String,
    public val securityIps: List<String>,
    public val sslEnable: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val userName: String,
    public val vpcAuthMode: String,
    public val vpcCloudInstanceId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            architectureType = javaType.architectureType(),
            autoRenew = javaType.autoRenew(),
            autoRenewPeriod = javaType.autoRenewPeriod(),
            availabilityZone = javaType.availabilityZone(),
            bandwidth = javaType.bandwidth(),
            capacity = javaType.capacity(),
            chargeType = javaType.chargeType(),
            config = javaType.config().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            connectionDomain = javaType.connectionDomain(),
            connectionMode = javaType.connectionMode(),
            connections = javaType.connections(),
            createTime = javaType.createTime(),
            dbInstanceId = javaType.dbInstanceId(),
            dbInstanceName = javaType.dbInstanceName(),
            destroyTime = javaType.destroyTime(),
            endTime = javaType.endTime(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            hasRenewChangeOrder = javaType.hasRenewChangeOrder(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            instanceReleaseProtection = javaType.instanceReleaseProtection(),
            instanceType = javaType.instanceType(),
            isRds = javaType.isRds(),
            maintainEndTime = javaType.maintainEndTime(),
            maintainStartTime = javaType.maintainStartTime(),
            maxConnections = javaType.maxConnections(),
            name = javaType.name(),
            networkType = javaType.networkType(),
            nodeType = javaType.nodeType(),
            packageType = javaType.packageType(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            privateIp = javaType.privateIp(),
            qps = javaType.qps(),
            regionId = javaType.regionId(),
            replacateId = javaType.replacateId(),
            resourceGroupId = javaType.resourceGroupId(),
            searchKey = javaType.searchKey(),
            secondaryZoneId = javaType.secondaryZoneId(),
            securityGroupId = javaType.securityGroupId(),
            securityIpGroupAttribute = javaType.securityIpGroupAttribute(),
            securityIpGroupName = javaType.securityIpGroupName(),
            securityIps = javaType.securityIps().map({ args0 -> args0 }),
            sslEnable = javaType.sslEnable(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userName = javaType.userName(),
            vpcAuthMode = javaType.vpcAuthMode(),
            vpcCloudInstanceId = javaType.vpcCloudInstanceId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
