@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property architectureType
 * @property editionType
 * @property enableDetails
 * @property engineVersion The engine version of the instance.
 * @property expired
 * @property globalInstance
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of KVStore Instance IDs.
 * @property instanceClass (Optional) Type of the applied ApsaraDB for instance.
 * For more information, see [Instance type table](https://www.alibabacloud.com/help/en/redis/product-overview/overview-4).
 * @property instanceType (Optional) Database type. Valid Values: `Memcache`, `Redis`. If no value is specified, all types are returned.
 * @property instances A list of KVStore Instances. Its every element contains the following attributes:
 * @property nameRegex
 * @property names A list of KVStore Instance names.
 * @property networkType The network type of the instance.
 * @property outputFile
 * @property paymentType Billing method. Valid Values: `PostPaid` for  Pay-As-You-Go and `PrePaid` for subscription.
 * @property resourceGroupId
 * @property searchKey
 * @property status Status of the instance.
 * @property tags
 * @property vpcId VPC ID the instance belongs to.
 * @property vswitchId VSwitch ID the instance belongs to.
 * @property zoneId The ID of zone.
 */
public data class GetInstancesResult(
    public val architectureType: String? = null,
    public val editionType: String? = null,
    public val enableDetails: Boolean? = null,
    public val engineVersion: String? = null,
    public val expired: String? = null,
    public val globalInstance: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceClass: String? = null,
    public val instanceType: String? = null,
    public val instances: List<GetInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            architectureType = javaType.architectureType().map({ args0 -> args0 }).orElse(null),
            editionType = javaType.editionType().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            expired = javaType.expired().map({ args0 -> args0 }).orElse(null),
            globalInstance = javaType.globalInstance().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceClass = javaType.instanceClass().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            searchKey = javaType.searchKey().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
