@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPermission.
 * @property enable
 * @property id The provider-assigned unique ID for this managed resource.
 * @property status The current service enable status.
 */
public data class GetPermissionResult(
    public val enable: String? = null,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kvstore.outputs.GetPermissionResult): GetPermissionResult = GetPermissionResult(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
