@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.lindorm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.lindorm.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Lindorm Instance resource.
 * For information about Lindorm Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/lindorm/latest/product-introduction-overview).
 * > **NOTE:** Available since v1.132.0.
 * > **NOTE:**  The Lindorm Instance does not support updating the specifications of multiple different engines, or the number of nodes at the same time.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const region = "cn-hangzhou";
 * const zoneId = "cn-hangzhou-h";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = defaultGetNetworks.then(defaultGetNetworks => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: zoneId,
 * }));
 * const defaultInstance = new alicloud.lindorm.Instance("default", {
 *     diskCategory: "cloud_efficiency",
 *     paymentType: "PayAsYouGo",
 *     zoneId: zoneId,
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     instanceName: name,
 *     tableEngineSpecification: "lindorm.g.4xlarge",
 *     tableEngineNodeCount: 2,
 *     instanceStorage: "1920",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * region = "cn-hangzhou"
 * zone_id = "cn-hangzhou-h"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=zone_id)
 * default_instance = alicloud.lindorm.Instance("default",
 *     disk_category="cloud_efficiency",
 *     payment_type="PayAsYouGo",
 *     zone_id=zone_id,
 *     vswitch_id=default_get_switches.ids[0],
 *     vpc_id=default_get_networks.ids[0],
 *     instance_name=name,
 *     table_engine_specification="lindorm.g.4xlarge",
 *     table_engine_node_count=2,
 *     instance_storage="1920")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var region = "cn-hangzhou";
 *     var zoneId = "cn-hangzhou-h";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.Lindorm.Instance("default", new()
 *     {
 *         DiskCategory = "cloud_efficiency",
 *         PaymentType = "PayAsYouGo",
 *         ZoneId = zoneId,
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         InstanceName = name,
 *         TableEngineSpecification = "lindorm.g.4xlarge",
 *         TableEngineNodeCount = 2,
 *         InstanceStorage = "1920",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/lindorm"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_ := "cn-hangzhou"
 * 		zoneId := "cn-hangzhou-h"
 * 		_, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(zoneId),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lindorm.NewInstance(ctx, "default", &lindorm.InstanceArgs{
 * 			DiskCategory:             pulumi.String("cloud_efficiency"),
 * 			PaymentType:              pulumi.String("PayAsYouGo"),
 * 			ZoneId:                   pulumi.String(zoneId),
 * 			VswitchId:                pulumi.String(defaultGetSwitches.Ids[0]),
 * 			VpcId:                    pulumi.String(defaultGetNetworks.Ids[0]),
 * 			InstanceName:             pulumi.String(name),
 * 			TableEngineSpecification: pulumi.String("lindorm.g.4xlarge"),
 * 			TableEngineNodeCount:     pulumi.Int(2),
 * 			InstanceStorage:          pulumi.String("1920"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.lindorm.Instance;
 * import com.pulumi.alicloud.lindorm.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var region = "cn-hangzhou";
 *         final var zoneId = "cn-hangzhou-h";
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .diskCategory("cloud_efficiency")
 *             .paymentType("PayAsYouGo")
 *             .zoneId(zoneId)
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .instanceName(name)
 *             .tableEngineSpecification("lindorm.g.4xlarge")
 *             .tableEngineNodeCount("2")
 *             .instanceStorage("1920")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:lindorm:Instance
 *     name: default
 *     properties:
 *       diskCategory: cloud_efficiency
 *       paymentType: PayAsYouGo
 *       zoneId: ${zoneId}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       instanceName: ${name}
 *       tableEngineSpecification: lindorm.g.4xlarge
 *       tableEngineNodeCount: '2'
 *       instanceStorage: '1920'
 * variables:
 *   region: cn-hangzhou
 *   zoneId: cn-hangzhou-h
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${zoneId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Lindorm Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:lindorm/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.lindorm.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
     */
    public val arbiterVswitchId: Output<String>?
        get() = javaResource.arbiterVswitchId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
     */
    public val arbiterZoneId: Output<String>?
        get() = javaResource.arbiterZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
     */
    public val archVersion: Output<String>
        get() = javaResource.archVersion().applyValue({ args0 -> args0 })

    /**
     * The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
     */
    public val coldStorage: Output<Int>
        get() = javaResource.coldStorage().applyValue({ args0 -> args0 })

    /**
     * The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    public val coreSingleStorage: Output<Int>?
        get() = javaResource.coreSingleStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
     * - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
     * - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
     */
    public val coreSpec: Output<String>
        get() = javaResource.coreSpec().applyValue({ args0 -> args0 })

    /**
     * The deletion protection of instance.
     */
    public val deletionProection: Output<Boolean>
        get() = javaResource.deletionProection().applyValue({ args0 -> args0 })

    /**
     * The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
     */
    public val diskCategory: Output<String>
        get() = javaResource.diskCategory().applyValue({ args0 -> args0 })

    /**
     * The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
     */
    public val duration: Output<String>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.163.0) Whether to enable file engine.
     */
    public val enabledFileEngine: Output<Boolean>
        get() = javaResource.enabledFileEngine().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.163.0) Whether to enable lts engine.
     */
    public val enabledLtsEngine: Output<Boolean>
        get() = javaResource.enabledLtsEngine().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.163.0) Whether to enable search engine.
     */
    public val enabledSearchEngine: Output<Boolean>
        get() = javaResource.enabledSearchEngine().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.211.0) Whether to enable streaming engine.
     */
    public val enabledStreamEngine: Output<Boolean>
        get() = javaResource.enabledStreamEngine().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.163.0) Whether to enable table engine.
     */
    public val enabledTableEngine: Output<Boolean>
        get() = javaResource.enabledTableEngine().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.163.0) Whether to enable time serires engine.
     */
    public val enabledTimeSeriresEngine: Output<Boolean>
        get() = javaResource.enabledTimeSeriresEngine().applyValue({ args0 -> args0 })

    /**
     * The count of file engine.
     */
    public val fileEngineNodeCount: Output<Int>
        get() = javaResource.fileEngineNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of file engine. Valid values: `lindorm.c.xlarge`.
     */
    public val fileEngineSpecification: Output<String>
        get() = javaResource.fileEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * The name of the instance.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
     */
    public val instanceStorage: Output<String>
        get() = javaResource.instanceStorage().applyValue({ args0 -> args0 })

    /**
     * The ip white list of instance.
     */
    public val ipWhiteLists: Output<List<String>>?
        get() = javaResource.ipWhiteLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
     */
    public val logDiskCategory: Output<String>?
        get() = javaResource.logDiskCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
     */
    public val logNum: Output<Int>?
        get() = javaResource.logNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    public val logSingleStorage: Output<Int>?
        get() = javaResource.logSingleStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
     */
    public val logSpec: Output<String>?
        get() = javaResource.logSpec().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The count of lindorm tunnel service.
     */
    public val ltsNodeCount: Output<Int>
        get() = javaResource.ltsNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
     */
    public val ltsNodeSpecification: Output<String>
        get() = javaResource.ltsNodeSpecification().applyValue({ args0 -> args0 })

    /**
     * The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
     */
    public val multiZoneCombination: Output<String>?
        get() = javaResource.multiZoneCombination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method. Valid values: `PayAsYouGo` and `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
     */
    public val primaryVswitchId: Output<String>?
        get() = javaResource.primaryVswitchId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
     */
    public val primaryZoneId: Output<String>?
        get() = javaResource.primaryZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The count of search engine.
     */
    public val searchEngineNodeCount: Output<Int>
        get() = javaResource.searchEngineNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
     */
    public val searchEngineSpecification: Output<String>
        get() = javaResource.searchEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.196.0) The instance type.
     */
    public val serviceType: Output<String>
        get() = javaResource.serviceType().applyValue({ args0 -> args0 })

    /**
     * The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
     */
    public val standbyVswitchId: Output<String>?
        get() = javaResource.standbyVswitchId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
     */
    public val standbyZoneId: Output<String>?
        get() = javaResource.standbyZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of Instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The number of LindormStream nodes in the instance.
     */
    public val streamEngineNodeCount: Output<Int>
        get() = javaResource.streamEngineNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    public val streamEngineSpecification: Output<String>
        get() = javaResource.streamEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * The count of table engine.
     */
    public val tableEngineNodeCount: Output<Int>
        get() = javaResource.tableEngineNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    public val tableEngineSpecification: Output<String>
        get() = javaResource.tableEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The count of time series engine.
     */
    public val timeSeriesEngineNodeCount: Output<Int>
        get() = javaResource.timeSeriesEngineNodeCount().applyValue({ args0 -> args0 })

    /**
     * The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
     */
    public val timeSeriesEngineSpecification: Output<String>
        get() = javaResource.timeSeriesEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
     */
    @Deprecated(
        message = """
  Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New
      field `time_series_engine_specification` instead.
  """,
    )
    public val timeSeriresEngineSpecification: Output<String>
        get() = javaResource.timeSeriresEngineSpecification().applyValue({ args0 -> args0 })

    /**
     * The VPC ID of the instance.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch id.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.lindorm.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.lindorm.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
