@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.lindorm.kotlin

import com.pulumi.alicloud.lindorm.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lindorm Instance resource.
 * For information about Lindorm Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/lindorm/latest/product-introduction-overview).
 * > **NOTE:** Available since v1.132.0.
 * > **NOTE:**  The Lindorm Instance does not support updating the specifications of multiple different engines, or the number of nodes at the same time.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const region = "cn-hangzhou";
 * const zoneId = "cn-hangzhou-h";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = defaultGetNetworks.then(defaultGetNetworks => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: zoneId,
 * }));
 * const defaultInstance = new alicloud.lindorm.Instance("default", {
 *     diskCategory: "cloud_efficiency",
 *     paymentType: "PayAsYouGo",
 *     zoneId: zoneId,
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     instanceName: name,
 *     tableEngineSpecification: "lindorm.g.4xlarge",
 *     tableEngineNodeCount: 2,
 *     instanceStorage: "1920",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * region = "cn-hangzhou"
 * zone_id = "cn-hangzhou-h"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=zone_id)
 * default_instance = alicloud.lindorm.Instance("default",
 *     disk_category="cloud_efficiency",
 *     payment_type="PayAsYouGo",
 *     zone_id=zone_id,
 *     vswitch_id=default_get_switches.ids[0],
 *     vpc_id=default_get_networks.ids[0],
 *     instance_name=name,
 *     table_engine_specification="lindorm.g.4xlarge",
 *     table_engine_node_count=2,
 *     instance_storage="1920")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var region = "cn-hangzhou";
 *     var zoneId = "cn-hangzhou-h";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.Lindorm.Instance("default", new()
 *     {
 *         DiskCategory = "cloud_efficiency",
 *         PaymentType = "PayAsYouGo",
 *         ZoneId = zoneId,
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         InstanceName = name,
 *         TableEngineSpecification = "lindorm.g.4xlarge",
 *         TableEngineNodeCount = 2,
 *         InstanceStorage = "1920",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/lindorm"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_ := "cn-hangzhou"
 * 		zoneId := "cn-hangzhou-h"
 * 		_, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(zoneId),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lindorm.NewInstance(ctx, "default", &lindorm.InstanceArgs{
 * 			DiskCategory:             pulumi.String("cloud_efficiency"),
 * 			PaymentType:              pulumi.String("PayAsYouGo"),
 * 			ZoneId:                   pulumi.String(zoneId),
 * 			VswitchId:                pulumi.String(defaultGetSwitches.Ids[0]),
 * 			VpcId:                    pulumi.String(defaultGetNetworks.Ids[0]),
 * 			InstanceName:             pulumi.String(name),
 * 			TableEngineSpecification: pulumi.String("lindorm.g.4xlarge"),
 * 			TableEngineNodeCount:     pulumi.Int(2),
 * 			InstanceStorage:          pulumi.String("1920"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.lindorm.Instance;
 * import com.pulumi.alicloud.lindorm.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var region = "cn-hangzhou";
 *         final var zoneId = "cn-hangzhou-h";
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .diskCategory("cloud_efficiency")
 *             .paymentType("PayAsYouGo")
 *             .zoneId(zoneId)
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .instanceName(name)
 *             .tableEngineSpecification("lindorm.g.4xlarge")
 *             .tableEngineNodeCount("2")
 *             .instanceStorage("1920")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:lindorm:Instance
 *     name: default
 *     properties:
 *       diskCategory: cloud_efficiency
 *       paymentType: PayAsYouGo
 *       zoneId: ${zoneId}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       instanceName: ${name}
 *       tableEngineSpecification: lindorm.g.4xlarge
 *       tableEngineNodeCount: '2'
 *       instanceStorage: '1920'
 * variables:
 *   region: cn-hangzhou
 *   zoneId: cn-hangzhou-h
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${zoneId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Lindorm Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:lindorm/instance:Instance example <id>
 * ```
 * @property arbiterVswitchId The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
 * @property arbiterZoneId The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
 * @property archVersion The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
 * @property coldStorage The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
 * @property coreSingleStorage The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
 * @property coreSpec The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
 * - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
 * - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
 * @property deletionProection The deletion protection of instance.
 * @property diskCategory The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
 * @property duration The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
 * @property fileEngineNodeCount The count of file engine.
 * @property fileEngineSpecification The specification of file engine. Valid values: `lindorm.c.xlarge`.
 * @property instanceName The name of the instance.
 * @property instanceStorage The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
 * @property ipWhiteLists The ip white list of instance.
 * @property logDiskCategory The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
 * @property logNum The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
 * @property logSingleStorage The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
 * @property logSpec The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
 * @property ltsNodeCount The count of lindorm tunnel service.
 * @property ltsNodeSpecification The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
 * @property multiZoneCombination The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
 * @property paymentType The billing method. Valid values: `PayAsYouGo` and `Subscription`.
 * @property pricingCycle The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
 * @property primaryVswitchId Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
 * @property primaryZoneId Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
 * @property resourceGroupId The ID of the resource group.
 * @property searchEngineNodeCount The count of search engine.
 * @property searchEngineSpecification The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
 * @property standbyVswitchId The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
 * @property standbyZoneId The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
 * @property streamEngineNodeCount The number of LindormStream nodes in the instance.
 * @property streamEngineSpecification The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
 * @property tableEngineNodeCount The count of table engine.
 * @property tableEngineSpecification The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
 * @property tags A mapping of tags to assign to the resource.
 * @property timeSeriesEngineNodeCount The count of time series engine.
 * @property timeSeriesEngineSpecification The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
 * @property timeSeriresEngineSpecification Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
 * @property vpcId The VPC ID of the instance.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class InstanceArgs(
    public val arbiterVswitchId: Output<String>? = null,
    public val arbiterZoneId: Output<String>? = null,
    public val archVersion: Output<String>? = null,
    public val coldStorage: Output<Int>? = null,
    public val coreSingleStorage: Output<Int>? = null,
    public val coreSpec: Output<String>? = null,
    public val deletionProection: Output<Boolean>? = null,
    public val diskCategory: Output<String>? = null,
    public val duration: Output<String>? = null,
    public val fileEngineNodeCount: Output<Int>? = null,
    public val fileEngineSpecification: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceStorage: Output<String>? = null,
    public val ipWhiteLists: Output<List<String>>? = null,
    public val logDiskCategory: Output<String>? = null,
    public val logNum: Output<Int>? = null,
    public val logSingleStorage: Output<Int>? = null,
    public val logSpec: Output<String>? = null,
    public val ltsNodeCount: Output<Int>? = null,
    public val ltsNodeSpecification: Output<String>? = null,
    public val multiZoneCombination: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val primaryVswitchId: Output<String>? = null,
    public val primaryZoneId: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val searchEngineNodeCount: Output<Int>? = null,
    public val searchEngineSpecification: Output<String>? = null,
    public val standbyVswitchId: Output<String>? = null,
    public val standbyZoneId: Output<String>? = null,
    public val streamEngineNodeCount: Output<Int>? = null,
    public val streamEngineSpecification: Output<String>? = null,
    public val tableEngineNodeCount: Output<Int>? = null,
    public val tableEngineSpecification: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeSeriesEngineNodeCount: Output<Int>? = null,
    public val timeSeriesEngineSpecification: Output<String>? = null,
    @Deprecated(
        message = """
  Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New
      field `time_series_engine_specification` instead.
  """,
    )
    public val timeSeriresEngineSpecification: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.lindorm.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.lindorm.InstanceArgs =
        com.pulumi.alicloud.lindorm.InstanceArgs.builder()
            .arbiterVswitchId(arbiterVswitchId?.applyValue({ args0 -> args0 }))
            .arbiterZoneId(arbiterZoneId?.applyValue({ args0 -> args0 }))
            .archVersion(archVersion?.applyValue({ args0 -> args0 }))
            .coldStorage(coldStorage?.applyValue({ args0 -> args0 }))
            .coreSingleStorage(coreSingleStorage?.applyValue({ args0 -> args0 }))
            .coreSpec(coreSpec?.applyValue({ args0 -> args0 }))
            .deletionProection(deletionProection?.applyValue({ args0 -> args0 }))
            .diskCategory(diskCategory?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .fileEngineNodeCount(fileEngineNodeCount?.applyValue({ args0 -> args0 }))
            .fileEngineSpecification(fileEngineSpecification?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceStorage(instanceStorage?.applyValue({ args0 -> args0 }))
            .ipWhiteLists(ipWhiteLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .logDiskCategory(logDiskCategory?.applyValue({ args0 -> args0 }))
            .logNum(logNum?.applyValue({ args0 -> args0 }))
            .logSingleStorage(logSingleStorage?.applyValue({ args0 -> args0 }))
            .logSpec(logSpec?.applyValue({ args0 -> args0 }))
            .ltsNodeCount(ltsNodeCount?.applyValue({ args0 -> args0 }))
            .ltsNodeSpecification(ltsNodeSpecification?.applyValue({ args0 -> args0 }))
            .multiZoneCombination(multiZoneCombination?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .primaryVswitchId(primaryVswitchId?.applyValue({ args0 -> args0 }))
            .primaryZoneId(primaryZoneId?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .searchEngineNodeCount(searchEngineNodeCount?.applyValue({ args0 -> args0 }))
            .searchEngineSpecification(searchEngineSpecification?.applyValue({ args0 -> args0 }))
            .standbyVswitchId(standbyVswitchId?.applyValue({ args0 -> args0 }))
            .standbyZoneId(standbyZoneId?.applyValue({ args0 -> args0 }))
            .streamEngineNodeCount(streamEngineNodeCount?.applyValue({ args0 -> args0 }))
            .streamEngineSpecification(streamEngineSpecification?.applyValue({ args0 -> args0 }))
            .tableEngineNodeCount(tableEngineNodeCount?.applyValue({ args0 -> args0 }))
            .tableEngineSpecification(tableEngineSpecification?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeSeriesEngineNodeCount(timeSeriesEngineNodeCount?.applyValue({ args0 -> args0 }))
            .timeSeriesEngineSpecification(timeSeriesEngineSpecification?.applyValue({ args0 -> args0 }))
            .timeSeriresEngineSpecification(timeSeriresEngineSpecification?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var arbiterVswitchId: Output<String>? = null

    private var arbiterZoneId: Output<String>? = null

    private var archVersion: Output<String>? = null

    private var coldStorage: Output<Int>? = null

    private var coreSingleStorage: Output<Int>? = null

    private var coreSpec: Output<String>? = null

    private var deletionProection: Output<Boolean>? = null

    private var diskCategory: Output<String>? = null

    private var duration: Output<String>? = null

    private var fileEngineNodeCount: Output<Int>? = null

    private var fileEngineSpecification: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceStorage: Output<String>? = null

    private var ipWhiteLists: Output<List<String>>? = null

    private var logDiskCategory: Output<String>? = null

    private var logNum: Output<Int>? = null

    private var logSingleStorage: Output<Int>? = null

    private var logSpec: Output<String>? = null

    private var ltsNodeCount: Output<Int>? = null

    private var ltsNodeSpecification: Output<String>? = null

    private var multiZoneCombination: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var primaryVswitchId: Output<String>? = null

    private var primaryZoneId: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var searchEngineNodeCount: Output<Int>? = null

    private var searchEngineSpecification: Output<String>? = null

    private var standbyVswitchId: Output<String>? = null

    private var standbyZoneId: Output<String>? = null

    private var streamEngineNodeCount: Output<Int>? = null

    private var streamEngineSpecification: Output<String>? = null

    private var tableEngineNodeCount: Output<Int>? = null

    private var tableEngineSpecification: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeSeriesEngineNodeCount: Output<Int>? = null

    private var timeSeriesEngineSpecification: Output<String>? = null

    private var timeSeriresEngineSpecification: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
     */
    @JvmName("flogtvxicnruqiir")
    public suspend fun arbiterVswitchId(`value`: Output<String>) {
        this.arbiterVswitchId = value
    }

    /**
     * @param value The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
     */
    @JvmName("wxabuftfcglwkvnt")
    public suspend fun arbiterZoneId(`value`: Output<String>) {
        this.arbiterZoneId = value
    }

    /**
     * @param value The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
     */
    @JvmName("ymtciivwhseycplm")
    public suspend fun archVersion(`value`: Output<String>) {
        this.archVersion = value
    }

    /**
     * @param value The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
     */
    @JvmName("eglsgkktceadwcvr")
    public suspend fun coldStorage(`value`: Output<Int>) {
        this.coldStorage = value
    }

    /**
     * @param value The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    @JvmName("gdlhgphpkjcmhfnp")
    public suspend fun coreSingleStorage(`value`: Output<Int>) {
        this.coreSingleStorage = value
    }

    /**
     * @param value The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
     * - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
     * - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
     */
    @JvmName("fxlfspkiqnruukoa")
    public suspend fun coreSpec(`value`: Output<String>) {
        this.coreSpec = value
    }

    /**
     * @param value The deletion protection of instance.
     */
    @JvmName("qjuufffpxpnigaem")
    public suspend fun deletionProection(`value`: Output<Boolean>) {
        this.deletionProection = value
    }

    /**
     * @param value The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
     */
    @JvmName("jsrpwliioxqqlvcb")
    public suspend fun diskCategory(`value`: Output<String>) {
        this.diskCategory = value
    }

    /**
     * @param value The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
     */
    @JvmName("qgkrhprbrmfbyqju")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The count of file engine.
     */
    @JvmName("fsvvlldqiybmrpud")
    public suspend fun fileEngineNodeCount(`value`: Output<Int>) {
        this.fileEngineNodeCount = value
    }

    /**
     * @param value The specification of file engine. Valid values: `lindorm.c.xlarge`.
     */
    @JvmName("mmifcqrgkoiwcecx")
    public suspend fun fileEngineSpecification(`value`: Output<String>) {
        this.fileEngineSpecification = value
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("tfveqddishdmmoot")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
     */
    @JvmName("tplurtmafceoybec")
    public suspend fun instanceStorage(`value`: Output<String>) {
        this.instanceStorage = value
    }

    /**
     * @param value The ip white list of instance.
     */
    @JvmName("mbeqlfpdcideasqd")
    public suspend fun ipWhiteLists(`value`: Output<List<String>>) {
        this.ipWhiteLists = value
    }

    @JvmName("ouhmqocrjxxwoxlg")
    public suspend fun ipWhiteLists(vararg values: Output<String>) {
        this.ipWhiteLists = Output.all(values.asList())
    }

    /**
     * @param values The ip white list of instance.
     */
    @JvmName("xsapnhqkedqvaceu")
    public suspend fun ipWhiteLists(values: List<Output<String>>) {
        this.ipWhiteLists = Output.all(values)
    }

    /**
     * @param value The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
     */
    @JvmName("gvwoypfejhboojrc")
    public suspend fun logDiskCategory(`value`: Output<String>) {
        this.logDiskCategory = value
    }

    /**
     * @param value The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
     */
    @JvmName("djjpgogivdjsfgfq")
    public suspend fun logNum(`value`: Output<Int>) {
        this.logNum = value
    }

    /**
     * @param value The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    @JvmName("xayxyaetvodkivfe")
    public suspend fun logSingleStorage(`value`: Output<Int>) {
        this.logSingleStorage = value
    }

    /**
     * @param value The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
     */
    @JvmName("rhrqqqcumxdcaqel")
    public suspend fun logSpec(`value`: Output<String>) {
        this.logSpec = value
    }

    /**
     * @param value The count of lindorm tunnel service.
     */
    @JvmName("fjhbrthafvhdqdor")
    public suspend fun ltsNodeCount(`value`: Output<Int>) {
        this.ltsNodeCount = value
    }

    /**
     * @param value The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
     */
    @JvmName("hjufygkutcgfqxtf")
    public suspend fun ltsNodeSpecification(`value`: Output<String>) {
        this.ltsNodeSpecification = value
    }

    /**
     * @param value The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
     */
    @JvmName("oxddxooirwkpqiwa")
    public suspend fun multiZoneCombination(`value`: Output<String>) {
        this.multiZoneCombination = value
    }

    /**
     * @param value The billing method. Valid values: `PayAsYouGo` and `Subscription`.
     */
    @JvmName("ylnkpcisndhkjuva")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
     */
    @JvmName("ukkypyvjkykhlexs")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
     */
    @JvmName("dmefcauydvjkmdex")
    public suspend fun primaryVswitchId(`value`: Output<String>) {
        this.primaryVswitchId = value
    }

    /**
     * @param value Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
     */
    @JvmName("mbyytgwilhaukrnv")
    public suspend fun primaryZoneId(`value`: Output<String>) {
        this.primaryZoneId = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("tagjbiloldmfqpsr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The count of search engine.
     */
    @JvmName("rdocjieloxxfppbe")
    public suspend fun searchEngineNodeCount(`value`: Output<Int>) {
        this.searchEngineNodeCount = value
    }

    /**
     * @param value The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
     */
    @JvmName("otehstlhkkjiniii")
    public suspend fun searchEngineSpecification(`value`: Output<String>) {
        this.searchEngineSpecification = value
    }

    /**
     * @param value The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
     */
    @JvmName("qvgpltvoxftpvjst")
    public suspend fun standbyVswitchId(`value`: Output<String>) {
        this.standbyVswitchId = value
    }

    /**
     * @param value The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
     */
    @JvmName("owgvqjasovdibocl")
    public suspend fun standbyZoneId(`value`: Output<String>) {
        this.standbyZoneId = value
    }

    /**
     * @param value The number of LindormStream nodes in the instance.
     */
    @JvmName("psmngprjhvokmwgi")
    public suspend fun streamEngineNodeCount(`value`: Output<Int>) {
        this.streamEngineNodeCount = value
    }

    /**
     * @param value The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    @JvmName("tsmsvctyiipbgvbu")
    public suspend fun streamEngineSpecification(`value`: Output<String>) {
        this.streamEngineSpecification = value
    }

    /**
     * @param value The count of table engine.
     */
    @JvmName("jeufaaxkngynowse")
    public suspend fun tableEngineNodeCount(`value`: Output<Int>) {
        this.tableEngineNodeCount = value
    }

    /**
     * @param value The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    @JvmName("kqrsccnnlmetobuu")
    public suspend fun tableEngineSpecification(`value`: Output<String>) {
        this.tableEngineSpecification = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("eepbhihxighkxrix")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The count of time series engine.
     */
    @JvmName("coenkfrtrfbsgdeu")
    public suspend fun timeSeriesEngineNodeCount(`value`: Output<Int>) {
        this.timeSeriesEngineNodeCount = value
    }

    /**
     * @param value The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
     */
    @JvmName("ffsdbhrvfmtjfams")
    public suspend fun timeSeriesEngineSpecification(`value`: Output<String>) {
        this.timeSeriesEngineSpecification = value
    }

    /**
     * @param value Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
     */
    @Deprecated(
        message = """
  Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New
      field `time_series_engine_specification` instead.
  """,
    )
    @JvmName("ihlbsyxodgygilpd")
    public suspend fun timeSeriresEngineSpecification(`value`: Output<String>) {
        this.timeSeriresEngineSpecification = value
    }

    /**
     * @param value The VPC ID of the instance.
     */
    @JvmName("nmkjkbnbyvtmokwl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("mpknycynqicypdhh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("jejgtqalgicquptp")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The multi-availability zone instance, coordinating the virtual switch ID of the availability zone, the switch must be located under the availability zone corresponding to the ArbiterZoneId. This parameter is required if you need to create multiple availability zone instances.
     */
    @JvmName("ucjxetldklolempe")
    public suspend fun arbiterVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arbiterVswitchId = mapped
    }

    /**
     * @param value The multiple Availability Zone Instance, the availability zone ID of the coordinating availability zone. required if you need to create multiple availability zone instances.
     */
    @JvmName("ojvjbdfbeqcojcxt")
    public suspend fun arbiterZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arbiterZoneId = mapped
    }

    /**
     * @param value The deployment architecture. If you do not fill in this parameter, the default is 1.0. to create multiple availability instances, fill in 2.0. if you need to create multiple availability instances, this parameter is required. Valid values: `1.0` to `2.0`.
     */
    @JvmName("lfjxcbhdlvdvqyni")
    public suspend fun archVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archVersion = mapped
    }

    /**
     * @param value The cold storage capacity of the instance. Unit: GB. Valid values: [800, 1000000].
     */
    @JvmName("uiqokfsvoetplucm")
    public suspend fun coldStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coldStorage = mapped
    }

    /**
     * @param value The multiple availability zone instances, CORE single node capacity. required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    @JvmName("wsbvxmarbpevoftd")
    public suspend fun coreSingleStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreSingleStorage = mapped
    }

    /**
     * @param value The core spec. When `disk_category` is `local_ssd_pro` or `local_hdd_pro`, this filed is valid.
     * - When `disk_category` is `local_ssd_pro`, the valid values is `lindorm.i2.xlarge`, `lindorm.i2.2xlarge`, `lindorm.i2.4xlarge`, `lindorm.i2.8xlarge`.
     * - When `disk_category` is `local_hdd_pro`, the valid values is `lindorm.d2c.6xlarge`, `lindorm.d2c.12xlarge`, `lindorm.d2c.24xlarge`, `lindorm.d2s.5xlarge`, `lindorm.d2s.10xlarge`, `lindorm.d1.2xlarge`, `lindorm.d1.4xlarge`, `lindorm.d1.6xlarge`.
     */
    @JvmName("bholjclxamgjsbbr")
    public suspend fun coreSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreSpec = mapped
    }

    /**
     * @param value The deletion protection of instance.
     */
    @JvmName("iobmbexltoiwlnpi")
    public suspend fun deletionProection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProection = mapped
    }

    /**
     * @param value The disk type of instance. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud_essd_pl0`, `capacity_cloud_storage`, `local_ssd_pro`, `local_hdd_pro`. **NOTE:** From version 1.207.0, `disk_category` can be set to `cloud_essd_pl0`.
     */
    @JvmName("fqphynnlcnqsdcpo")
    public suspend fun diskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCategory = mapped
    }

    /**
     * @param value The duration of paid. Valid when the `payment_type` is `Subscription`.  When `pricing_cycle` set to `Month`, the valid value id `1` to `9`.  When `pricing_cycle` set to `Year`, the valid value id `1` to `3`.
     */
    @JvmName("pudbvuaeqhfjpjqk")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The count of file engine.
     */
    @JvmName("cptlcwgvfxbjqaoe")
    public suspend fun fileEngineNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileEngineNodeCount = mapped
    }

    /**
     * @param value The specification of file engine. Valid values: `lindorm.c.xlarge`.
     */
    @JvmName("gfuustibcwghofdc")
    public suspend fun fileEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileEngineSpecification = mapped
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("scbwtbnpotfejvkk")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
     */
    @JvmName("qvjtnifwbdwndyga")
    public suspend fun instanceStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceStorage = mapped
    }

    /**
     * @param value The ip white list of instance.
     */
    @JvmName("abgvfjwprixcfjtp")
    public suspend fun ipWhiteLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhiteLists = mapped
    }

    /**
     * @param values The ip white list of instance.
     */
    @JvmName("qbafqxtwjbgkrhnb")
    public suspend fun ipWhiteLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipWhiteLists = mapped
    }

    /**
     * @param value The multi-available zone instance, log node disk type. required if you need to create multiple availability zone instances. Valid values: `cloud_efficiency`, `cloud_ssd`.
     */
    @JvmName("knsnxititauyvxuc")
    public suspend fun logDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDiskCategory = mapped
    }

    /**
     * @param value The multiple Availability Zone Instance, number of log nodes. this parameter is required if you want to create multiple availability zone instances. Valid values: `4` to `400`.
     */
    @JvmName("dcginjjekvgqkioo")
    public suspend fun logNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logNum = mapped
    }

    /**
     * @param value The multi-availability instance, log single-node disk capacity. This parameter is required if you want to create multiple availability zone instances. Valid values: `400` to `64000`.
     */
    @JvmName("ttwxnqlmcvdnfjhc")
    public suspend fun logSingleStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logSingleStorage = mapped
    }

    /**
     * @param value The multiple availability zone instances, log node specification. required if you need to create multiple availability zone instances. Valid values: `lindorm.sn1.large`, `lindorm.sn1.2xlarge`.
     */
    @JvmName("ruqsgdlaotfvndex")
    public suspend fun logSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logSpec = mapped
    }

    /**
     * @param value The count of lindorm tunnel service.
     */
    @JvmName("eusqctwgfambcqbk")
    public suspend fun ltsNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltsNodeCount = mapped
    }

    /**
     * @param value The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
     */
    @JvmName("jutmihftvpdnqidy")
    public suspend fun ltsNodeSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltsNodeSpecification = mapped
    }

    /**
     * @param value The multi-zone combinations. Availability zone combinations are supported on the sale page. required if you need to create multiple availability zone instances. Valid values: `ap-southeast-5abc-aliyun`, `cn-hangzhou-ehi-aliyun`, `cn-beijing-acd-aliyun`, `ap-southeast-1-abc-aliyun`, `cn-zhangjiakou-abc-aliyun`, `cn-shanghai-efg-aliyun`, `cn-shanghai-abd-aliyun`, `cn-hangzhou-bef-aliyun`, `cn-hangzhou-bce-aliyun`, `cn-beijing-fgh-aliyun`, `cn-shenzhen-abc-aliyun`.
     */
    @JvmName("rxousagydjcybagj")
    public suspend fun multiZoneCombination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiZoneCombination = mapped
    }

    /**
     * @param value The billing method. Valid values: `PayAsYouGo` and `Subscription`.
     */
    @JvmName("hdwoltdwxbilvxrg")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The pricing cycle. Valid when the `payment_type` is `Subscription`. Valid values: `Month` and `Year`.
     */
    @JvmName("wcapwtyjjxmnplsj")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value Multi-available zone instances, the virtual switch ID of the primary available zone, must be under the available zone corresponding to the PrimaryZoneId. required if you need to create multiple availability zone instances.
     */
    @JvmName("bawaybftkfwdfdqe")
    public suspend fun primaryVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryVswitchId = mapped
    }

    /**
     * @param value Multi-availability zone instance with the availability zone ID of the main availability zone. required if you need to create multiple availability zone instances.
     */
    @JvmName("hhmrofgsvygvnyey")
    public suspend fun primaryZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryZoneId = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("xgxgcxhpedeklcrg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The count of search engine.
     */
    @JvmName("ihrpwghdhpwgwnri")
    public suspend fun searchEngineNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchEngineNodeCount = mapped
    }

    /**
     * @param value The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
     */
    @JvmName("dfawuvhwbwlnailv")
    public suspend fun searchEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchEngineSpecification = mapped
    }

    /**
     * @param value The multiple availability zone instances, the virtual switch ID of the ready availability zone must be under the availability zone corresponding to the StandbyZoneId. required if you need to create multiple availability zone instances.
     */
    @JvmName("mncwdkhkwbfbxjgy")
    public suspend fun standbyVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyVswitchId = mapped
    }

    /**
     * @param value The multiple availability zone instances with availability zone IDs for the prepared availability zones. required if you need to create multiple availability zone instances.
     */
    @JvmName("yjpklsnrfsimqfms")
    public suspend fun standbyZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyZoneId = mapped
    }

    /**
     * @param value The number of LindormStream nodes in the instance.
     */
    @JvmName("ohcgslndmolrpego")
    public suspend fun streamEngineNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamEngineNodeCount = mapped
    }

    /**
     * @param value The specification of the LindormStream nodes in the instance. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    @JvmName("jquemvwnckcrnwmi")
    public suspend fun streamEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamEngineSpecification = mapped
    }

    /**
     * @param value The count of table engine.
     */
    @JvmName("pfbvtgiwyvdxfbgl")
    public suspend fun tableEngineNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableEngineNodeCount = mapped
    }

    /**
     * @param value The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`.
     */
    @JvmName("srdntkllqbeubhpi")
    public suspend fun tableEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableEngineSpecification = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("qvfkjfyiwcgwayxc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("bajckyjkfaboekxs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The count of time series engine.
     */
    @JvmName("akmfkraejlfxjjjh")
    public suspend fun timeSeriesEngineNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesEngineNodeCount = mapped
    }

    /**
     * @param value The specification of time series engine. Valid values: `lindorm.g.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.r.8xlarge`.
     */
    @JvmName("uvplbiyodjkjhqoa")
    public suspend fun timeSeriesEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesEngineSpecification = mapped
    }

    /**
     * @param value Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New field `time_series_engine_specification` instead.
     */
    @Deprecated(
        message = """
  Field `time_serires_engine_specification` has been deprecated from provider version 1.182.0. New
      field `time_series_engine_specification` instead.
  """,
    )
    @JvmName("mjgbwhepdgapiama")
    public suspend fun timeSeriresEngineSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriresEngineSpecification = mapped
    }

    /**
     * @param value The VPC ID of the instance.
     */
    @JvmName("limnmktvojhknfma")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("bexenqewfvnihmbw")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("vvalycixyjllkeex")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        arbiterVswitchId = arbiterVswitchId,
        arbiterZoneId = arbiterZoneId,
        archVersion = archVersion,
        coldStorage = coldStorage,
        coreSingleStorage = coreSingleStorage,
        coreSpec = coreSpec,
        deletionProection = deletionProection,
        diskCategory = diskCategory,
        duration = duration,
        fileEngineNodeCount = fileEngineNodeCount,
        fileEngineSpecification = fileEngineSpecification,
        instanceName = instanceName,
        instanceStorage = instanceStorage,
        ipWhiteLists = ipWhiteLists,
        logDiskCategory = logDiskCategory,
        logNum = logNum,
        logSingleStorage = logSingleStorage,
        logSpec = logSpec,
        ltsNodeCount = ltsNodeCount,
        ltsNodeSpecification = ltsNodeSpecification,
        multiZoneCombination = multiZoneCombination,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        primaryVswitchId = primaryVswitchId,
        primaryZoneId = primaryZoneId,
        resourceGroupId = resourceGroupId,
        searchEngineNodeCount = searchEngineNodeCount,
        searchEngineSpecification = searchEngineSpecification,
        standbyVswitchId = standbyVswitchId,
        standbyZoneId = standbyZoneId,
        streamEngineNodeCount = streamEngineNodeCount,
        streamEngineSpecification = streamEngineSpecification,
        tableEngineNodeCount = tableEngineNodeCount,
        tableEngineSpecification = tableEngineSpecification,
        tags = tags,
        timeSeriesEngineNodeCount = timeSeriesEngineNodeCount,
        timeSeriesEngineSpecification = timeSeriesEngineSpecification,
        timeSeriresEngineSpecification = timeSeriresEngineSpecification,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
