@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.lindorm.kotlin

import com.pulumi.alicloud.lindorm.LindormFunctions.getInstancesPlain
import com.pulumi.alicloud.lindorm.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.lindorm.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.lindorm.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.lindorm.kotlin.outputs.GetInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object LindormFunctions {
    /**
     * This data source provides the Lindorm Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.lindorm.getInstances({});
     * export const lindormInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const nameRegex = alicloud.lindorm.getInstances({
     *     nameRegex: "^my-Instance",
     * });
     * export const lindormInstanceId2 = nameRegex.then(nameRegex => nameRegex.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.lindorm.get_instances()
     * pulumi.export("lindormInstanceId1", ids.instances[0].id)
     * name_regex = alicloud.lindorm.get_instances(name_regex="^my-Instance")
     * pulumi.export("lindormInstanceId2", name_regex.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Lindorm.GetInstances.Invoke();
     *     var nameRegex = AliCloud.Lindorm.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "^my-Instance",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["lindormInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *         ["lindormInstanceId2"] = nameRegex&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/lindorm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := lindorm.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("lindormInstanceId1", ids.Instances[0].Id)
     * 		nameRegex, err := lindorm.GetInstances(ctx, &lindorm.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Instance"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("lindormInstanceId2", nameRegex.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.lindorm.LindormFunctions;
     * import com.pulumi.alicloud.lindorm.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = LindormFunctions.getInstances();
     *         ctx.export("lindormInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         final var nameRegex = LindormFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("lindormInstanceId2", nameRegex.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:lindorm:getInstances
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:lindorm:getInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   lindormInstanceId1: ${ids.instances[0].id}
     *   lindormInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        toKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Instance IDs.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryStr The query str, which can use `instance_name` keyword for fuzzy search.
     * @param status Instance status, Valid values: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`, `INSTANCE_LEVEL_MODIFY`, `NET_MODIFYING`, `RESIZING`, `RESTARTING`, `MINOR_VERSION_TRANSING`.
     * @param supportEngine The support engine. Valid values: `1` to `7`.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        queryStr: String? = null,
        status: String? = null,
        supportEngine: Int? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            queryStr = queryStr,
            status = status,
            supportEngine = supportEngine,
        )
        return toKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;lindorm&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }
}
