@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.lindorm.kotlin.inputs

import com.pulumi.alicloud.lindorm.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Instance IDs.
 * @property nameRegex A regex string to filter results by Instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property queryStr The query str, which can use `instance_name` keyword for fuzzy search.
 * @property status Instance status, Valid values: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`, `INSTANCE_LEVEL_MODIFY`, `NET_MODIFYING`, `RESIZING`, `RESTARTING`, `MINOR_VERSION_TRANSING`.
 * @property supportEngine The support engine. Valid values: `1` to `7`.
 */
public data class GetInstancesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val queryStr: String? = null,
    public val status: String? = null,
    public val supportEngine: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.lindorm.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.lindorm.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.lindorm.inputs.GetInstancesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .queryStr(queryStr?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .supportEngine(supportEngine?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var queryStr: String? = null

    private var status: String? = null

    private var supportEngine: Int? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("enpadjxfgqjxhoah")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Instance IDs.
     */
    @JvmName("gyuaqorrxyfsxkty")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance IDs.
     */
    @JvmName("tedplohvctdtawli")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Instance name.
     */
    @JvmName("xenfdxkpnflpmupo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hwwkxkhnuyjofhpo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The query str, which can use `instance_name` keyword for fuzzy search.
     */
    @JvmName("brhewbumdytpyrit")
    public suspend fun queryStr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryStr = mapped
    }

    /**
     * @param value Instance status, Valid values: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`, `INSTANCE_LEVEL_MODIFY`, `NET_MODIFYING`, `RESIZING`, `RESTARTING`, `MINOR_VERSION_TRANSING`.
     */
    @JvmName("kpuvmoksrrofyewf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The support engine. Valid values: `1` to `7`.
     */
    @JvmName("huyjyrkroijfybsr")
    public suspend fun supportEngine(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportEngine = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        queryStr = queryStr,
        status = status,
        supportEngine = supportEngine,
    )
}
