@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.lindorm.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoRenew AutoRenew.
 * @property coldStorage The cold storage capacity of the instance. Unit: GB.
 * @property createTime The creation date of Instance.
 * @property deletionProection The deletion protection of instance.
 * @property diskCategory The disk type of instance. Valid values: `capacity_cloud_storage`, `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
 * @property diskUsage The usage of disk.
 * @property diskWarningThreshold The threshold of disk.
 * @property engineType The type of Instance engine .
 * @property expiredTime The expiration time of Instance.
 * @property fileEngineNodeCount The count of file engine.
 * @property fileEngineSpecification The specification of file engine. Valid values: `lindorm.c.xlarge`.
 * @property id The ID of the Instance.
 * @property instanceId The ID of the instance.
 * @property instanceName The name of the instance.
 * @property instanceStorage The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
 * @property ipWhiteLists The ip white list of instance.
 * @property ltsNodeCount The count of lindorm tunnel service.
 * @property ltsNodeSpecification The specification of lindorm tunnel service. Valid values: `lindorm.g.2xlarge`, `lindorm.g.xlarge`.
 * @property networkType Instance network type, enumerative.VPC.
 * @property paymentType The billing method. Valid values: `PayAsYouGo` and `Subscription`.
 * @property phoenixNodeCount The count of phoenix.
 * @property phoenixNodeSpecification The specification of phoenix. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.c.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
 * @property resourceOwnerId The owner id of resource.
 * @property searchEngineNodeCount The count of search engine.
 * @property searchEngineSpecification The specification of search engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
 * @property serviceType The service type of Instance, Valid values:  `lindorm`, `serverless_lindorm`, `lindorm_standalone`.
 * @property status The status of Instance, enumerative: Valid values: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`, `INSTANCE_LEVEL_MODIFY`, `NET_MODIFYING`, `RESIZING`, `RESTARTING`, `MINOR_VERSION_TRANSING`.
 * @property tableEngineNodeCount The count of table engine.
 * @property tableEngineSpecification The specification of  table engine. Valid values: `lindorm.c.2xlarge`, `lindorm.c.4xlarge`, `lindorm.c.8xlarge`, `lindorm.c.xlarge`, `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
 * @property timeSeriesEngineNodeCount The count of time series engine.
 * @property timeSeriresEngineSpecification The specification of time series engine. Valid values: `lindorm.g.2xlarge`, `lindorm.g.4xlarge`, `lindorm.g.8xlarge`, `lindorm.g.xlarge`.
 * @property vpcId The ID of the virtual private cloud (VPC) that is connected to the instance.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class GetInstancesInstance(
    public val autoRenew: String,
    public val coldStorage: Int,
    public val createTime: String,
    public val deletionProection: Boolean,
    public val diskCategory: String,
    public val diskUsage: String,
    public val diskWarningThreshold: String,
    public val engineType: Int,
    public val expiredTime: String,
    public val fileEngineNodeCount: Int,
    public val fileEngineSpecification: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceStorage: String,
    public val ipWhiteLists: List<String>,
    public val ltsNodeCount: Int,
    public val ltsNodeSpecification: String,
    public val networkType: String,
    public val paymentType: String,
    public val phoenixNodeCount: Int,
    public val phoenixNodeSpecification: String,
    public val resourceOwnerId: String,
    public val searchEngineNodeCount: Int,
    public val searchEngineSpecification: String,
    public val serviceType: String,
    public val status: String,
    public val tableEngineNodeCount: Int,
    public val tableEngineSpecification: String,
    public val timeSeriesEngineNodeCount: Int,
    public val timeSeriresEngineSpecification: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.lindorm.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            autoRenew = javaType.autoRenew(),
            coldStorage = javaType.coldStorage(),
            createTime = javaType.createTime(),
            deletionProection = javaType.deletionProection(),
            diskCategory = javaType.diskCategory(),
            diskUsage = javaType.diskUsage(),
            diskWarningThreshold = javaType.diskWarningThreshold(),
            engineType = javaType.engineType(),
            expiredTime = javaType.expiredTime(),
            fileEngineNodeCount = javaType.fileEngineNodeCount(),
            fileEngineSpecification = javaType.fileEngineSpecification(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceStorage = javaType.instanceStorage(),
            ipWhiteLists = javaType.ipWhiteLists().map({ args0 -> args0 }),
            ltsNodeCount = javaType.ltsNodeCount(),
            ltsNodeSpecification = javaType.ltsNodeSpecification(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            phoenixNodeCount = javaType.phoenixNodeCount(),
            phoenixNodeSpecification = javaType.phoenixNodeSpecification(),
            resourceOwnerId = javaType.resourceOwnerId(),
            searchEngineNodeCount = javaType.searchEngineNodeCount(),
            searchEngineSpecification = javaType.searchEngineSpecification(),
            serviceType = javaType.serviceType(),
            status = javaType.status(),
            tableEngineNodeCount = javaType.tableEngineNodeCount(),
            tableEngineSpecification = javaType.tableEngineSpecification(),
            timeSeriesEngineNodeCount = javaType.timeSeriesEngineNodeCount(),
            timeSeriresEngineSpecification = javaType.timeSeriresEngineSpecification(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
