@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.kotlin.outputs.AlertAnnotation
import com.pulumi.alicloud.log.kotlin.outputs.AlertGroupConfiguration
import com.pulumi.alicloud.log.kotlin.outputs.AlertJoinConfiguration
import com.pulumi.alicloud.log.kotlin.outputs.AlertLabel
import com.pulumi.alicloud.log.kotlin.outputs.AlertNotificationList
import com.pulumi.alicloud.log.kotlin.outputs.AlertPolicyConfiguration
import com.pulumi.alicloud.log.kotlin.outputs.AlertQueryList
import com.pulumi.alicloud.log.kotlin.outputs.AlertSchedule
import com.pulumi.alicloud.log.kotlin.outputs.AlertSeverityConfiguration
import com.pulumi.alicloud.log.kotlin.outputs.AlertTemplateConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.log.kotlin.outputs.AlertAnnotation.Companion.toKotlin as alertAnnotationToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertGroupConfiguration.Companion.toKotlin as alertGroupConfigurationToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertJoinConfiguration.Companion.toKotlin as alertJoinConfigurationToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertLabel.Companion.toKotlin as alertLabelToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertNotificationList.Companion.toKotlin as alertNotificationListToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertPolicyConfiguration.Companion.toKotlin as alertPolicyConfigurationToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertQueryList.Companion.toKotlin as alertQueryListToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertSchedule.Companion.toKotlin as alertScheduleToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertSeverityConfiguration.Companion.toKotlin as alertSeverityConfigurationToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.AlertTemplateConfiguration.Companion.toKotlin as alertTemplateConfigurationToKotlin

/**
 * Builder for [Alert].
 */
@PulumiTagMarker
public class AlertResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertArgs = AlertArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertArgsBuilder.() -> Unit) {
        val builder = AlertArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alert {
        val builtJavaResource = com.pulumi.alicloud.log.Alert(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alert(builtJavaResource)
    }
}

/**
 * Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
 * Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.
 * For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)
 * > **NOTE:** Available in 1.78.0
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleAlert = new alicloud.log.Alert("example", {
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     condition: "count> 100",
 *     dashboard: "example-dashboard",
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     queryLists: [{
 *         logstore: exampleStore.name,
 *         chartTitle: "chart_title",
 *         start: "-60s",
 *         end: "20s",
 *         query: "* AND aliyun",
 *     }],
 *     notificationLists: [
 *         {
 *             type: "SMS",
 *             mobileLists: [
 *                 "12345678",
 *                 "87654321",
 *             ],
 *             content: "alert content",
 *         },
 *         {
 *             type: "Email",
 *             emailLists: [
 *                 "aliyun@alibaba-inc.com",
 *                 "tf-example@123.com",
 *             ],
 *             content: "alert content",
 *         },
 *         {
 *             type: "DingTalk",
 *             serviceUri: "www.aliyun.com",
 *             content: "alert content",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_alert = alicloud.log.Alert("example",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     condition="count> 100",
 *     dashboard="example-dashboard",
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     query_lists=[{
 *         "logstore": example_store.name,
 *         "chart_title": "chart_title",
 *         "start": "-60s",
 *         "end": "20s",
 *         "query": "* AND aliyun",
 *     }],
 *     notification_lists=[
 *         {
 *             "type": "SMS",
 *             "mobile_lists": [
 *                 "12345678",
 *                 "87654321",
 *             ],
 *             "content": "alert content",
 *         },
 *         {
 *             "type": "Email",
 *             "email_lists": [
 *                 "aliyun@alibaba-inc.com",
 *                 "tf-example@123.com",
 *             ],
 *             "content": "alert content",
 *         },
 *         {
 *             "type": "DingTalk",
 *             "service_uri": "www.aliyun.com",
 *             "content": "alert content",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleAlert = new AliCloud.Log.Alert("example", new()
 *     {
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         Condition = "count> 100",
 *         Dashboard = "example-dashboard",
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         QueryLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Logstore = exampleStore.Name,
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "* AND aliyun",
 *             },
 *         },
 *         NotificationLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "SMS",
 *                 MobileLists = new[]
 *                 {
 *                     "12345678",
 *                     "87654321",
 *                 },
 *                 Content = "alert content",
 *             },
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "Email",
 *                 EmailLists = new[]
 *                 {
 *                     "aliyun@alibaba-inc.com",
 *                     "tf-example@123.com",
 *                 },
 *                 Content = "alert content",
 *             },
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "DingTalk",
 *                 ServiceUri = "www.aliyun.com",
 *                 Content = "alert content",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example", &log.AlertArgs{
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			Condition:        pulumi.String("count> 100"),
 * 			Dashboard:        pulumi.String("example-dashboard"),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			QueryLists: log.AlertQueryListArray{
 * 				&log.AlertQueryListArgs{
 * 					Logstore:   exampleStore.Name,
 * 					ChartTitle: pulumi.String("chart_title"),
 * 					Start:      pulumi.String("-60s"),
 * 					End:        pulumi.String("20s"),
 * 					Query:      pulumi.String("* AND aliyun"),
 * 				},
 * 			},
 * 			NotificationLists: log.AlertNotificationListArray{
 * 				&log.AlertNotificationListArgs{
 * 					Type: pulumi.String("SMS"),
 * 					MobileLists: pulumi.StringArray{
 * 						pulumi.String("12345678"),
 * 						pulumi.String("87654321"),
 * 					},
 * 					Content: pulumi.String("alert content"),
 * 				},
 * 				&log.AlertNotificationListArgs{
 * 					Type: pulumi.String("Email"),
 * 					EmailLists: pulumi.StringArray{
 * 						pulumi.String("aliyun@alibaba-inc.com"),
 * 						pulumi.String("tf-example@123.com"),
 * 					},
 * 					Content: pulumi.String("alert content"),
 * 				},
 * 				&log.AlertNotificationListArgs{
 * 					Type:       pulumi.String("DingTalk"),
 * 					ServiceUri: pulumi.String("www.aliyun.com"),
 * 					Content:    pulumi.String("alert content"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertQueryListArgs;
 * import com.pulumi.alicloud.log.inputs.AlertNotificationListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleAlert = new Alert("exampleAlert", AlertArgs.builder()
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .condition("count> 100")
 *             .dashboard("example-dashboard")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .queryLists(AlertQueryListArgs.builder()
 *                 .logstore(exampleStore.name())
 *                 .chartTitle("chart_title")
 *                 .start("-60s")
 *                 .end("20s")
 *                 .query("* AND aliyun")
 *                 .build())
 *             .notificationLists(
 *                 AlertNotificationListArgs.builder()
 *                     .type("SMS")
 *                     .mobileLists(
 *                         "12345678",
 *                         "87654321")
 *                     .content("alert content")
 *                     .build(),
 *                 AlertNotificationListArgs.builder()
 *                     .type("Email")
 *                     .emailLists(
 *                         "aliyun@alibaba-inc.com",
 *                         "tf-example@123.com")
 *                     .content("alert content")
 *                     .build(),
 *                 AlertNotificationListArgs.builder()
 *                     .type("DingTalk")
 *                     .serviceUri("www.aliyun.com")
 *                     .content("alert content")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleAlert:
 *     type: alicloud:log:Alert
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       condition: count> 100
 *       dashboard: example-dashboard
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       queryLists:
 *         - logstore: ${exampleStore.name}
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: '* AND aliyun'
 *       notificationLists:
 *         - type: SMS
 *           mobileLists:
 *             - '12345678'
 *             - '87654321'
 *           content: alert content
 *         - type: Email
 *           emailLists:
 *             - aliyun@alibaba-inc.com
 *             - tf-example@123.com
 *           content: alert content
 *         - type: DingTalk
 *           serviceUri: www.aliyun.com
 *           content: alert content
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for new alert
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example_2 = new alicloud.log.Alert("example-2", {
 *     version: "2.0",
 *     type: "default",
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     muteUntil: 1632486684,
 *     noDataFire: false,
 *     noDataSeverity: 8,
 *     sendResolved: true,
 *     autoAnnotation: true,
 *     dashboard: "example-dashboard",
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     queryLists: [
 *         {
 *             store: exampleStore.name,
 *             storeType: "log",
 *             project: example.name,
 *             region: "cn-heyuan",
 *             chartTitle: "chart_title",
 *             start: "-60s",
 *             end: "20s",
 *             query: "* AND aliyun | select count(1) as cnt",
 *             powerSqlMode: "auto",
 *         },
 *         {
 *             store: exampleStore.name,
 *             storeType: "log",
 *             project: example.name,
 *             region: "cn-heyuan",
 *             chartTitle: "chart_title",
 *             start: "-60s",
 *             end: "20s",
 *             query: "error | select count(1) as error_cnt",
 *             powerSqlMode: "enable",
 *         },
 *     ],
 *     labels: [{
 *         key: "env",
 *         value: "test",
 *     }],
 *     annotations: [
 *         {
 *             key: "title",
 *             value: "alert title",
 *         },
 *         {
 *             key: "desc",
 *             value: "alert desc",
 *         },
 *         {
 *             key: "test_key",
 *             value: "test value",
 *         },
 *     ],
 *     groupConfiguration: {
 *         type: "custom",
 *         fields: ["cnt"],
 *     },
 *     policyConfiguration: {
 *         alertPolicyId: "sls.bultin",
 *         actionPolicyId: "sls_test_action",
 *         repeatInterval: "4h",
 *     },
 *     severityConfigurations: [
 *         {
 *             severity: 8,
 *             evalCondition: {
 *                 condition: "cnt > 3",
 *                 count_condition: "__count__ > 3",
 *             },
 *         },
 *         {
 *             severity: 6,
 *             evalCondition: {
 *                 condition: "",
 *                 count_condition: "__count__ > 0",
 *             },
 *         },
 *         {
 *             severity: 2,
 *             evalCondition: {
 *                 condition: "",
 *                 count_condition: "",
 *             },
 *         },
 *     ],
 *     joinConfigurations: [{
 *         type: "cross_join",
 *         condition: "",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_2 = alicloud.log.Alert("example-2",
 *     version="2.0",
 *     type="default",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     mute_until=1632486684,
 *     no_data_fire=False,
 *     no_data_severity=8,
 *     send_resolved=True,
 *     auto_annotation=True,
 *     dashboard="example-dashboard",
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     query_lists=[
 *         {
 *             "store": example_store.name,
 *             "store_type": "log",
 *             "project": example.name,
 *             "region": "cn-heyuan",
 *             "chart_title": "chart_title",
 *             "start": "-60s",
 *             "end": "20s",
 *             "query": "* AND aliyun | select count(1) as cnt",
 *             "power_sql_mode": "auto",
 *         },
 *         {
 *             "store": example_store.name,
 *             "store_type": "log",
 *             "project": example.name,
 *             "region": "cn-heyuan",
 *             "chart_title": "chart_title",
 *             "start": "-60s",
 *             "end": "20s",
 *             "query": "error | select count(1) as error_cnt",
 *             "power_sql_mode": "enable",
 *         },
 *     ],
 *     labels=[{
 *         "key": "env",
 *         "value": "test",
 *     }],
 *     annotations=[
 *         {
 *             "key": "title",
 *             "value": "alert title",
 *         },
 *         {
 *             "key": "desc",
 *             "value": "alert desc",
 *         },
 *         {
 *             "key": "test_key",
 *             "value": "test value",
 *         },
 *     ],
 *     group_configuration={
 *         "type": "custom",
 *         "fields": ["cnt"],
 *     },
 *     policy_configuration={
 *         "alert_policy_id": "sls.bultin",
 *         "action_policy_id": "sls_test_action",
 *         "repeat_interval": "4h",
 *     },
 *     severity_configurations=[
 *         {
 *             "severity": 8,
 *             "eval_condition": {
 *                 "condition": "cnt > 3",
 *                 "count_condition": "__count__ > 3",
 *             },
 *         },
 *         {
 *             "severity": 6,
 *             "eval_condition": {
 *                 "condition": "",
 *                 "count_condition": "__count__ > 0",
 *             },
 *         },
 *         {
 *             "severity": 2,
 *             "eval_condition": {
 *                 "condition": "",
 *                 "count_condition": "",
 *             },
 *         },
 *     ],
 *     join_configurations=[{
 *         "type": "cross_join",
 *         "condition": "",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example_2 = new AliCloud.Log.Alert("example-2", new()
 *     {
 *         Version = "2.0",
 *         Type = "default",
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         MuteUntil = 1632486684,
 *         NoDataFire = false,
 *         NoDataSeverity = 8,
 *         SendResolved = true,
 *         AutoAnnotation = true,
 *         Dashboard = "example-dashboard",
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         QueryLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Store = exampleStore.Name,
 *                 StoreType = "log",
 *                 Project = example.Name,
 *                 Region = "cn-heyuan",
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "* AND aliyun | select count(1) as cnt",
 *                 PowerSqlMode = "auto",
 *             },
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Store = exampleStore.Name,
 *                 StoreType = "log",
 *                 Project = example.Name,
 *                 Region = "cn-heyuan",
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "error | select count(1) as error_cnt",
 *                 PowerSqlMode = "enable",
 *             },
 *         },
 *         Labels = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertLabelArgs
 *             {
 *                 Key = "env",
 *                 Value = "test",
 *             },
 *         },
 *         Annotations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "title",
 *                 Value = "alert title",
 *             },
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "desc",
 *                 Value = "alert desc",
 *             },
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "test_key",
 *                 Value = "test value",
 *             },
 *         },
 *         GroupConfiguration = new AliCloud.Log.Inputs.AlertGroupConfigurationArgs
 *         {
 *             Type = "custom",
 *             Fields = new[]
 *             {
 *                 "cnt",
 *             },
 *         },
 *         PolicyConfiguration = new AliCloud.Log.Inputs.AlertPolicyConfigurationArgs
 *         {
 *             AlertPolicyId = "sls.bultin",
 *             ActionPolicyId = "sls_test_action",
 *             RepeatInterval = "4h",
 *         },
 *         SeverityConfigurations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 8,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "cnt > 3" },
 *                     { "count_condition", "__count__ > 3" },
 *                 },
 *             },
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 6,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "" },
 *                     { "count_condition", "__count__ > 0" },
 *                 },
 *             },
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 2,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "" },
 *                     { "count_condition", "" },
 *                 },
 *             },
 *         },
 *         JoinConfigurations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertJoinConfigurationArgs
 *             {
 *                 Type = "cross_join",
 *                 Condition = "",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example-2", &log.AlertArgs{
 * 			Version:          pulumi.String("2.0"),
 * 			Type:             pulumi.String("default"),
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			MuteUntil:        pulumi.Int(1632486684),
 * 			NoDataFire:       pulumi.Bool(false),
 * 			NoDataSeverity:   pulumi.Int(8),
 * 			SendResolved:     pulumi.Bool(true),
 * 			AutoAnnotation:   pulumi.Bool(true),
 * 			Dashboard:        pulumi.String("example-dashboard"),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			QueryLists: log.AlertQueryListArray{
 * 				&log.AlertQueryListArgs{
 * 					Store:        exampleStore.Name,
 * 					StoreType:    pulumi.String("log"),
 * 					Project:      example.Name,
 * 					Region:       pulumi.String("cn-heyuan"),
 * 					ChartTitle:   pulumi.String("chart_title"),
 * 					Start:        pulumi.String("-60s"),
 * 					End:          pulumi.String("20s"),
 * 					Query:        pulumi.String("* AND aliyun | select count(1) as cnt"),
 * 					PowerSqlMode: pulumi.String("auto"),
 * 				},
 * 				&log.AlertQueryListArgs{
 * 					Store:        exampleStore.Name,
 * 					StoreType:    pulumi.String("log"),
 * 					Project:      example.Name,
 * 					Region:       pulumi.String("cn-heyuan"),
 * 					ChartTitle:   pulumi.String("chart_title"),
 * 					Start:        pulumi.String("-60s"),
 * 					End:          pulumi.String("20s"),
 * 					Query:        pulumi.String("error | select count(1) as error_cnt"),
 * 					PowerSqlMode: pulumi.String("enable"),
 * 				},
 * 			},
 * 			Labels: log.AlertLabelArray{
 * 				&log.AlertLabelArgs{
 * 					Key:   pulumi.String("env"),
 * 					Value: pulumi.String("test"),
 * 				},
 * 			},
 * 			Annotations: log.AlertAnnotationArray{
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("title"),
 * 					Value: pulumi.String("alert title"),
 * 				},
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("desc"),
 * 					Value: pulumi.String("alert desc"),
 * 				},
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("test_key"),
 * 					Value: pulumi.String("test value"),
 * 				},
 * 			},
 * 			GroupConfiguration: &log.AlertGroupConfigurationArgs{
 * 				Type: pulumi.String("custom"),
 * 				Fields: pulumi.StringArray{
 * 					pulumi.String("cnt"),
 * 				},
 * 			},
 * 			PolicyConfiguration: &log.AlertPolicyConfigurationArgs{
 * 				AlertPolicyId:  pulumi.String("sls.bultin"),
 * 				ActionPolicyId: pulumi.String("sls_test_action"),
 * 				RepeatInterval: pulumi.String("4h"),
 * 			},
 * 			SeverityConfigurations: log.AlertSeverityConfigurationArray{
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(8),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String("cnt > 3"),
 * 						"count_condition": pulumi.String("__count__ > 3"),
 * 					},
 * 				},
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(6),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String(""),
 * 						"count_condition": pulumi.String("__count__ > 0"),
 * 					},
 * 				},
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(2),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String(""),
 * 						"count_condition": pulumi.String(""),
 * 					},
 * 				},
 * 			},
 * 			JoinConfigurations: log.AlertJoinConfigurationArray{
 * 				&log.AlertJoinConfigurationArgs{
 * 					Type:      pulumi.String("cross_join"),
 * 					Condition: pulumi.String(""),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertQueryListArgs;
 * import com.pulumi.alicloud.log.inputs.AlertLabelArgs;
 * import com.pulumi.alicloud.log.inputs.AlertAnnotationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example_2 = new Alert("example-2", AlertArgs.builder()
 *             .version("2.0")
 *             .type("default")
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .muteUntil("1632486684")
 *             .noDataFire("false")
 *             .noDataSeverity(8)
 *             .sendResolved(true)
 *             .autoAnnotation(true)
 *             .dashboard("example-dashboard")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .queryLists(
 *                 AlertQueryListArgs.builder()
 *                     .store(exampleStore.name())
 *                     .storeType("log")
 *                     .project(example.name())
 *                     .region("cn-heyuan")
 *                     .chartTitle("chart_title")
 *                     .start("-60s")
 *                     .end("20s")
 *                     .query("* AND aliyun | select count(1) as cnt")
 *                     .powerSqlMode("auto")
 *                     .build(),
 *                 AlertQueryListArgs.builder()
 *                     .store(exampleStore.name())
 *                     .storeType("log")
 *                     .project(example.name())
 *                     .region("cn-heyuan")
 *                     .chartTitle("chart_title")
 *                     .start("-60s")
 *                     .end("20s")
 *                     .query("error | select count(1) as error_cnt")
 *                     .powerSqlMode("enable")
 *                     .build())
 *             .labels(AlertLabelArgs.builder()
 *                 .key("env")
 *                 .value("test")
 *                 .build())
 *             .annotations(
 *                 AlertAnnotationArgs.builder()
 *                     .key("title")
 *                     .value("alert title")
 *                     .build(),
 *                 AlertAnnotationArgs.builder()
 *                     .key("desc")
 *                     .value("alert desc")
 *                     .build(),
 *                 AlertAnnotationArgs.builder()
 *                     .key("test_key")
 *                     .value("test value")
 *                     .build())
 *             .groupConfiguration(AlertGroupConfigurationArgs.builder()
 *                 .type("custom")
 *                 .fields("cnt")
 *                 .build())
 *             .policyConfiguration(AlertPolicyConfigurationArgs.builder()
 *                 .alertPolicyId("sls.bultin")
 *                 .actionPolicyId("sls_test_action")
 *                 .repeatInterval("4h")
 *                 .build())
 *             .severityConfigurations(
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(8)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", "cnt > 3"),
 *                         Map.entry("count_condition", "__count__ > 3")
 *                     ))
 *                     .build(),
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(6)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", ""),
 *                         Map.entry("count_condition", "__count__ > 0")
 *                     ))
 *                     .build(),
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(2)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", ""),
 *                         Map.entry("count_condition", "")
 *                     ))
 *                     .build())
 *             .joinConfigurations(AlertJoinConfigurationArgs.builder()
 *                 .type("cross_join")
 *                 .condition("")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example-2:
 *     type: alicloud:log:Alert
 *     properties:
 *       version: '2.0'
 *       type: default
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       muteUntil: '1632486684'
 *       noDataFire: 'false'
 *       noDataSeverity: 8
 *       sendResolved: true
 *       autoAnnotation: true
 *       dashboard: example-dashboard
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       queryLists:
 *         - store: ${exampleStore.name}
 *           storeType: log
 *           project: ${example.name}
 *           region: cn-heyuan
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: '* AND aliyun | select count(1) as cnt'
 *           powerSqlMode: auto
 *         - store: ${exampleStore.name}
 *           storeType: log
 *           project: ${example.name}
 *           region: cn-heyuan
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: error | select count(1) as error_cnt
 *           powerSqlMode: enable
 *       labels:
 *         - key: env
 *           value: test
 *       annotations:
 *         - key: title
 *           value: alert title
 *         - key: desc
 *           value: alert desc
 *         - key: test_key
 *           value: test value
 *       groupConfiguration:
 *         type: custom
 *         fields:
 *           - cnt
 *       policyConfiguration:
 *         alertPolicyId: sls.bultin
 *         actionPolicyId: sls_test_action
 *         repeatInterval: 4h
 *       severityConfigurations:
 *         - severity: 8
 *           evalCondition:
 *             condition: cnt > 3
 *             count_condition: __count__ > 3
 *         - severity: 6
 *           evalCondition:
 *             condition:
 *             count_condition: __count__ > 0
 *         - severity: 2
 *           evalCondition:
 *             condition:
 *             count_condition:
 *       joinConfigurations:
 *         - type: cross_join
 *           condition:
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for alert template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example_3 = new alicloud.log.Alert("example-3", {
 *     version: "2.0",
 *     type: "tpl",
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     muteUntil: 1632486684,
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     templateConfiguration: {
 *         id: "sls.app.sls_ack.node.down",
 *         type: "sys",
 *         lang: "cn",
 *         annotations: {},
 *         tokens: {
 *             interval_minute: "5",
 *             "default.action_policy": "sls.app.ack.builtin",
 *             "default.severity": "6",
 *             sendResolved: "false",
 *             "default.project": example.name,
 *             "default.logstore": "k8s-event",
 *             "default.repeatInterval": "4h",
 *             trigger_threshold: "1",
 *             "default.clusterId": "example-cluster-id",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_3 = alicloud.log.Alert("example-3",
 *     version="2.0",
 *     type="tpl",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     mute_until=1632486684,
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     template_configuration={
 *         "id": "sls.app.sls_ack.node.down",
 *         "type": "sys",
 *         "lang": "cn",
 *         "annotations": {},
 *         "tokens": {
 *             "interval_minute": "5",
 *             "default_action_policy": "sls.app.ack.builtin",
 *             "default_severity": "6",
 *             "send_resolved": "false",
 *             "default_project": example.name,
 *             "default_logstore": "k8s-event",
 *             "default_repeat_interval": "4h",
 *             "trigger_threshold": "1",
 *             "default_cluster_id": "example-cluster-id",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example_3 = new AliCloud.Log.Alert("example-3", new()
 *     {
 *         Version = "2.0",
 *         Type = "tpl",
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         MuteUntil = 1632486684,
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         TemplateConfiguration = new AliCloud.Log.Inputs.AlertTemplateConfigurationArgs
 *         {
 *             Id = "sls.app.sls_ack.node.down",
 *             Type = "sys",
 *             Lang = "cn",
 *             Annotations = null,
 *             Tokens =
 *             {
 *                 { "interval_minute", "5" },
 *                 { "default.action_policy", "sls.app.ack.builtin" },
 *                 { "default.severity", "6" },
 *                 { "sendResolved", "false" },
 *                 { "default.project", example.Name },
 *                 { "default.logstore", "k8s-event" },
 *                 { "default.repeatInterval", "4h" },
 *                 { "trigger_threshold", "1" },
 *                 { "default.clusterId", "example-cluster-id" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example-3", &log.AlertArgs{
 * 			Version:          pulumi.String("2.0"),
 * 			Type:             pulumi.String("tpl"),
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			MuteUntil:        pulumi.Int(1632486684),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			TemplateConfiguration: &log.AlertTemplateConfigurationArgs{
 * 				Id:          pulumi.String("sls.app.sls_ack.node.down"),
 * 				Type:        pulumi.String("sys"),
 * 				Lang:        pulumi.String("cn"),
 * 				Annotations: nil,
 * 				Tokens: pulumi.StringMap{
 * 					"interval_minute":        pulumi.String("5"),
 * 					"default.action_policy":  pulumi.String("sls.app.ack.builtin"),
 * 					"default.severity":       pulumi.String("6"),
 * 					"sendResolved":           pulumi.String("false"),
 * 					"default.project":        example.Name,
 * 					"default.logstore":       pulumi.String("k8s-event"),
 * 					"default.repeatInterval": pulumi.String("4h"),
 * 					"trigger_threshold":      pulumi.String("1"),
 * 					"default.clusterId":      pulumi.String("example-cluster-id"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example_3 = new Alert("example-3", AlertArgs.builder()
 *             .version("2.0")
 *             .type("tpl")
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .muteUntil("1632486684")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .templateConfiguration(AlertTemplateConfigurationArgs.builder()
 *                 .id("sls.app.sls_ack.node.down")
 *                 .type("sys")
 *                 .lang("cn")
 *                 .annotations()
 *                 .tokens(Map.ofEntries(
 *                     Map.entry("interval_minute", "5"),
 *                     Map.entry("default.action_policy", "sls.app.ack.builtin"),
 *                     Map.entry("default.severity", "6"),
 *                     Map.entry("sendResolved", "false"),
 *                     Map.entry("default.project", example.name()),
 *                     Map.entry("default.logstore", "k8s-event"),
 *                     Map.entry("default.repeatInterval", "4h"),
 *                     Map.entry("trigger_threshold", "1"),
 *                     Map.entry("default.clusterId", "example-cluster-id")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example-3:
 *     type: alicloud:log:Alert
 *     properties:
 *       version: '2.0'
 *       type: tpl
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       muteUntil: '1632486684'
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       templateConfiguration:
 *         id: sls.app.sls_ack.node.down
 *         type: sys
 *         lang: cn
 *         annotations: {}
 *         tokens:
 *           interval_minute: '5'
 *           default.action_policy: sls.app.ack.builtin
 *           default.severity: '6'
 *           sendResolved: 'false'
 *           default.project: ${example.name}
 *           default.logstore: k8s-event
 *           default.repeatInterval: 4h
 *           trigger_threshold: '1'
 *           default.clusterId: example-cluster-id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log alert can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
 * ```
 */
public class Alert internal constructor(
    override val javaResource: com.pulumi.alicloud.log.Alert,
) : KotlinCustomResource(javaResource, AlertMapper) {
    /**
     * Alert description.
     */
    public val alertDescription: Output<String>?
        get() = javaResource.alertDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Alert displayname.
     */
    public val alertDisplayname: Output<String>
        get() = javaResource.alertDisplayname().applyValue({ args0 -> args0 })

    /**
     * Name of logstore for configuring alarm service.
     */
    public val alertName: Output<String>
        get() = javaResource.alertName().applyValue({ args0 -> args0 })

    /**
     * Annotations for new alert.
     */
    public val annotations: Output<List<AlertAnnotation>>?
        get() = javaResource.annotations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> alertAnnotationToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * whether to add automatic annotation, default is false.
     */
    public val autoAnnotation: Output<Boolean>?
        get() = javaResource.autoAnnotation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use eval_condition in severity_configurations
  """,
    )
    public val condition: Output<String>?
        get() = javaResource.condition().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use dashboardId in query_list
  """,
    )
    public val dashboard: Output<String>?
        get() = javaResource.dashboard().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Group configuration for new alert.
     */
    public val groupConfiguration: Output<AlertGroupConfiguration>?
        get() = javaResource.groupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> alertGroupConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Join configuration for different queries.
     */
    public val joinConfigurations: Output<List<AlertJoinConfiguration>>?
        get() = javaResource.joinConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        alertJoinConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Labels for new alert.
     */
    public val labels: Output<List<AlertLabel>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> alertLabelToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Timestamp, notifications before closing again.
     */
    public val muteUntil: Output<Int>
        get() = javaResource.muteUntil().applyValue({ args0 -> args0 })

    /**
     * Switch for whether new alert fires when no data happens, default is false.
     */
    public val noDataFire: Output<Boolean>?
        get() = javaResource.noDataFire().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * when no data happens, the severity of new alert.
     */
    public val noDataSeverity: Output<Int>?
        get() = javaResource.noDataSeverity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    public val notificationLists: Output<List<AlertNotificationList>>?
        get() = javaResource.notificationLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        alertNotificationListToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use threshold
  """,
    )
    public val notifyThreshold: Output<Int>?
        get() = javaResource.notifyThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Policy configuration for new alert.
     */
    public val policyConfiguration: Output<AlertPolicyConfiguration>?
        get() = javaResource.policyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> alertPolicyConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The project name.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * Multiple conditions for configured alarm query.
     */
    public val queryLists: Output<List<AlertQueryList>>?
        get() = javaResource.queryLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> alertQueryListToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * schedule for alert.
     */
    public val schedule: Output<AlertSchedule>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    alertScheduleToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    public val scheduleInterval: Output<String>
        get() = javaResource.scheduleInterval().applyValue({ args0 -> args0 })

    /**
     * Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    public val scheduleType: Output<String>
        get() = javaResource.scheduleType().applyValue({ args0 -> args0 })

    /**
     * when new alert is resolved, whether to notify, default is false.
     */
    public val sendResolved: Output<Boolean>?
        get() = javaResource.sendResolved().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Severity configuration for new alert.
     */
    public val severityConfigurations: Output<List<AlertSeverityConfiguration>>?
        get() = javaResource.severityConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        alertSeverityConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Template configuration for alert, when `type` is `tpl`.
     */
    public val templateConfiguration: Output<AlertTemplateConfiguration>?
        get() = javaResource.templateConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> alertTemplateConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
     */
    public val threshold: Output<Int>
        get() = javaResource.threshold().applyValue({ args0 -> args0 })

    /**
     * Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use repeat_interval in policy_configuration
  """,
    )
    public val throttling: Output<String>?
        get() = javaResource.throttling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of new alert, `default` for custom alert, `tpl` for template alert.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The version of alert, new alert is 2.0.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AlertMapper : ResourceMapper<Alert> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.Alert::class == javaResource::class

    override fun map(javaResource: Resource): Alert = Alert(
        javaResource as
            com.pulumi.alicloud.log.Alert,
    )
}

/**
 * @see [Alert].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alert].
 */
public suspend fun alert(name: String, block: suspend AlertResourceBuilder.() -> Unit): Alert {
    val builder = AlertResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alert].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alert(name: String): Alert {
    val builder = AlertResourceBuilder()
    builder.name(name)
    return builder.build()
}
