@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.AlertArgs.builder
import com.pulumi.alicloud.log.kotlin.inputs.AlertAnnotationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertAnnotationArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertGroupConfigurationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertGroupConfigurationArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertJoinConfigurationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertJoinConfigurationArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertLabelArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertLabelArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertNotificationListArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertNotificationListArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertPolicyConfigurationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertPolicyConfigurationArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertQueryListArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertQueryListArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertScheduleArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertScheduleArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertSeverityConfigurationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertSeverityConfigurationArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.AlertTemplateConfigurationArgs
import com.pulumi.alicloud.log.kotlin.inputs.AlertTemplateConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log alert is a unit of log service, which is used to monitor and alert the user's logstore status information.
 * Log Service enables you to configure alerts based on the charts in a dashboard to monitor the service status in real time.
 * For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)
 * > **NOTE:** Available in 1.78.0
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleAlert = new alicloud.log.Alert("example", {
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     condition: "count> 100",
 *     dashboard: "example-dashboard",
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     queryLists: [{
 *         logstore: exampleStore.name,
 *         chartTitle: "chart_title",
 *         start: "-60s",
 *         end: "20s",
 *         query: "* AND aliyun",
 *     }],
 *     notificationLists: [
 *         {
 *             type: "SMS",
 *             mobileLists: [
 *                 "12345678",
 *                 "87654321",
 *             ],
 *             content: "alert content",
 *         },
 *         {
 *             type: "Email",
 *             emailLists: [
 *                 "aliyun@alibaba-inc.com",
 *                 "tf-example@123.com",
 *             ],
 *             content: "alert content",
 *         },
 *         {
 *             type: "DingTalk",
 *             serviceUri: "www.aliyun.com",
 *             content: "alert content",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_alert = alicloud.log.Alert("example",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     condition="count> 100",
 *     dashboard="example-dashboard",
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     query_lists=[{
 *         "logstore": example_store.name,
 *         "chart_title": "chart_title",
 *         "start": "-60s",
 *         "end": "20s",
 *         "query": "* AND aliyun",
 *     }],
 *     notification_lists=[
 *         {
 *             "type": "SMS",
 *             "mobile_lists": [
 *                 "12345678",
 *                 "87654321",
 *             ],
 *             "content": "alert content",
 *         },
 *         {
 *             "type": "Email",
 *             "email_lists": [
 *                 "aliyun@alibaba-inc.com",
 *                 "tf-example@123.com",
 *             ],
 *             "content": "alert content",
 *         },
 *         {
 *             "type": "DingTalk",
 *             "service_uri": "www.aliyun.com",
 *             "content": "alert content",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleAlert = new AliCloud.Log.Alert("example", new()
 *     {
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         Condition = "count> 100",
 *         Dashboard = "example-dashboard",
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         QueryLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Logstore = exampleStore.Name,
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "* AND aliyun",
 *             },
 *         },
 *         NotificationLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "SMS",
 *                 MobileLists = new[]
 *                 {
 *                     "12345678",
 *                     "87654321",
 *                 },
 *                 Content = "alert content",
 *             },
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "Email",
 *                 EmailLists = new[]
 *                 {
 *                     "aliyun@alibaba-inc.com",
 *                     "tf-example@123.com",
 *                 },
 *                 Content = "alert content",
 *             },
 *             new AliCloud.Log.Inputs.AlertNotificationListArgs
 *             {
 *                 Type = "DingTalk",
 *                 ServiceUri = "www.aliyun.com",
 *                 Content = "alert content",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example", &log.AlertArgs{
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			Condition:        pulumi.String("count> 100"),
 * 			Dashboard:        pulumi.String("example-dashboard"),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			QueryLists: log.AlertQueryListArray{
 * 				&log.AlertQueryListArgs{
 * 					Logstore:   exampleStore.Name,
 * 					ChartTitle: pulumi.String("chart_title"),
 * 					Start:      pulumi.String("-60s"),
 * 					End:        pulumi.String("20s"),
 * 					Query:      pulumi.String("* AND aliyun"),
 * 				},
 * 			},
 * 			NotificationLists: log.AlertNotificationListArray{
 * 				&log.AlertNotificationListArgs{
 * 					Type: pulumi.String("SMS"),
 * 					MobileLists: pulumi.StringArray{
 * 						pulumi.String("12345678"),
 * 						pulumi.String("87654321"),
 * 					},
 * 					Content: pulumi.String("alert content"),
 * 				},
 * 				&log.AlertNotificationListArgs{
 * 					Type: pulumi.String("Email"),
 * 					EmailLists: pulumi.StringArray{
 * 						pulumi.String("aliyun@alibaba-inc.com"),
 * 						pulumi.String("tf-example@123.com"),
 * 					},
 * 					Content: pulumi.String("alert content"),
 * 				},
 * 				&log.AlertNotificationListArgs{
 * 					Type:       pulumi.String("DingTalk"),
 * 					ServiceUri: pulumi.String("www.aliyun.com"),
 * 					Content:    pulumi.String("alert content"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertQueryListArgs;
 * import com.pulumi.alicloud.log.inputs.AlertNotificationListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleAlert = new Alert("exampleAlert", AlertArgs.builder()
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .condition("count> 100")
 *             .dashboard("example-dashboard")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .queryLists(AlertQueryListArgs.builder()
 *                 .logstore(exampleStore.name())
 *                 .chartTitle("chart_title")
 *                 .start("-60s")
 *                 .end("20s")
 *                 .query("* AND aliyun")
 *                 .build())
 *             .notificationLists(
 *                 AlertNotificationListArgs.builder()
 *                     .type("SMS")
 *                     .mobileLists(
 *                         "12345678",
 *                         "87654321")
 *                     .content("alert content")
 *                     .build(),
 *                 AlertNotificationListArgs.builder()
 *                     .type("Email")
 *                     .emailLists(
 *                         "aliyun@alibaba-inc.com",
 *                         "tf-example@123.com")
 *                     .content("alert content")
 *                     .build(),
 *                 AlertNotificationListArgs.builder()
 *                     .type("DingTalk")
 *                     .serviceUri("www.aliyun.com")
 *                     .content("alert content")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleAlert:
 *     type: alicloud:log:Alert
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       condition: count> 100
 *       dashboard: example-dashboard
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       queryLists:
 *         - logstore: ${exampleStore.name}
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: '* AND aliyun'
 *       notificationLists:
 *         - type: SMS
 *           mobileLists:
 *             - '12345678'
 *             - '87654321'
 *           content: alert content
 *         - type: Email
 *           emailLists:
 *             - aliyun@alibaba-inc.com
 *             - tf-example@123.com
 *           content: alert content
 *         - type: DingTalk
 *           serviceUri: www.aliyun.com
 *           content: alert content
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for new alert
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example_2 = new alicloud.log.Alert("example-2", {
 *     version: "2.0",
 *     type: "default",
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     muteUntil: 1632486684,
 *     noDataFire: false,
 *     noDataSeverity: 8,
 *     sendResolved: true,
 *     autoAnnotation: true,
 *     dashboard: "example-dashboard",
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     queryLists: [
 *         {
 *             store: exampleStore.name,
 *             storeType: "log",
 *             project: example.name,
 *             region: "cn-heyuan",
 *             chartTitle: "chart_title",
 *             start: "-60s",
 *             end: "20s",
 *             query: "* AND aliyun | select count(1) as cnt",
 *             powerSqlMode: "auto",
 *         },
 *         {
 *             store: exampleStore.name,
 *             storeType: "log",
 *             project: example.name,
 *             region: "cn-heyuan",
 *             chartTitle: "chart_title",
 *             start: "-60s",
 *             end: "20s",
 *             query: "error | select count(1) as error_cnt",
 *             powerSqlMode: "enable",
 *         },
 *     ],
 *     labels: [{
 *         key: "env",
 *         value: "test",
 *     }],
 *     annotations: [
 *         {
 *             key: "title",
 *             value: "alert title",
 *         },
 *         {
 *             key: "desc",
 *             value: "alert desc",
 *         },
 *         {
 *             key: "test_key",
 *             value: "test value",
 *         },
 *     ],
 *     groupConfiguration: {
 *         type: "custom",
 *         fields: ["cnt"],
 *     },
 *     policyConfiguration: {
 *         alertPolicyId: "sls.bultin",
 *         actionPolicyId: "sls_test_action",
 *         repeatInterval: "4h",
 *     },
 *     severityConfigurations: [
 *         {
 *             severity: 8,
 *             evalCondition: {
 *                 condition: "cnt > 3",
 *                 count_condition: "__count__ > 3",
 *             },
 *         },
 *         {
 *             severity: 6,
 *             evalCondition: {
 *                 condition: "",
 *                 count_condition: "__count__ > 0",
 *             },
 *         },
 *         {
 *             severity: 2,
 *             evalCondition: {
 *                 condition: "",
 *                 count_condition: "",
 *             },
 *         },
 *     ],
 *     joinConfigurations: [{
 *         type: "cross_join",
 *         condition: "",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_2 = alicloud.log.Alert("example-2",
 *     version="2.0",
 *     type="default",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     mute_until=1632486684,
 *     no_data_fire=False,
 *     no_data_severity=8,
 *     send_resolved=True,
 *     auto_annotation=True,
 *     dashboard="example-dashboard",
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     query_lists=[
 *         {
 *             "store": example_store.name,
 *             "store_type": "log",
 *             "project": example.name,
 *             "region": "cn-heyuan",
 *             "chart_title": "chart_title",
 *             "start": "-60s",
 *             "end": "20s",
 *             "query": "* AND aliyun | select count(1) as cnt",
 *             "power_sql_mode": "auto",
 *         },
 *         {
 *             "store": example_store.name,
 *             "store_type": "log",
 *             "project": example.name,
 *             "region": "cn-heyuan",
 *             "chart_title": "chart_title",
 *             "start": "-60s",
 *             "end": "20s",
 *             "query": "error | select count(1) as error_cnt",
 *             "power_sql_mode": "enable",
 *         },
 *     ],
 *     labels=[{
 *         "key": "env",
 *         "value": "test",
 *     }],
 *     annotations=[
 *         {
 *             "key": "title",
 *             "value": "alert title",
 *         },
 *         {
 *             "key": "desc",
 *             "value": "alert desc",
 *         },
 *         {
 *             "key": "test_key",
 *             "value": "test value",
 *         },
 *     ],
 *     group_configuration={
 *         "type": "custom",
 *         "fields": ["cnt"],
 *     },
 *     policy_configuration={
 *         "alert_policy_id": "sls.bultin",
 *         "action_policy_id": "sls_test_action",
 *         "repeat_interval": "4h",
 *     },
 *     severity_configurations=[
 *         {
 *             "severity": 8,
 *             "eval_condition": {
 *                 "condition": "cnt > 3",
 *                 "count_condition": "__count__ > 3",
 *             },
 *         },
 *         {
 *             "severity": 6,
 *             "eval_condition": {
 *                 "condition": "",
 *                 "count_condition": "__count__ > 0",
 *             },
 *         },
 *         {
 *             "severity": 2,
 *             "eval_condition": {
 *                 "condition": "",
 *                 "count_condition": "",
 *             },
 *         },
 *     ],
 *     join_configurations=[{
 *         "type": "cross_join",
 *         "condition": "",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example_2 = new AliCloud.Log.Alert("example-2", new()
 *     {
 *         Version = "2.0",
 *         Type = "default",
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         MuteUntil = 1632486684,
 *         NoDataFire = false,
 *         NoDataSeverity = 8,
 *         SendResolved = true,
 *         AutoAnnotation = true,
 *         Dashboard = "example-dashboard",
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         QueryLists = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Store = exampleStore.Name,
 *                 StoreType = "log",
 *                 Project = example.Name,
 *                 Region = "cn-heyuan",
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "* AND aliyun | select count(1) as cnt",
 *                 PowerSqlMode = "auto",
 *             },
 *             new AliCloud.Log.Inputs.AlertQueryListArgs
 *             {
 *                 Store = exampleStore.Name,
 *                 StoreType = "log",
 *                 Project = example.Name,
 *                 Region = "cn-heyuan",
 *                 ChartTitle = "chart_title",
 *                 Start = "-60s",
 *                 End = "20s",
 *                 Query = "error | select count(1) as error_cnt",
 *                 PowerSqlMode = "enable",
 *             },
 *         },
 *         Labels = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertLabelArgs
 *             {
 *                 Key = "env",
 *                 Value = "test",
 *             },
 *         },
 *         Annotations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "title",
 *                 Value = "alert title",
 *             },
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "desc",
 *                 Value = "alert desc",
 *             },
 *             new AliCloud.Log.Inputs.AlertAnnotationArgs
 *             {
 *                 Key = "test_key",
 *                 Value = "test value",
 *             },
 *         },
 *         GroupConfiguration = new AliCloud.Log.Inputs.AlertGroupConfigurationArgs
 *         {
 *             Type = "custom",
 *             Fields = new[]
 *             {
 *                 "cnt",
 *             },
 *         },
 *         PolicyConfiguration = new AliCloud.Log.Inputs.AlertPolicyConfigurationArgs
 *         {
 *             AlertPolicyId = "sls.bultin",
 *             ActionPolicyId = "sls_test_action",
 *             RepeatInterval = "4h",
 *         },
 *         SeverityConfigurations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 8,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "cnt > 3" },
 *                     { "count_condition", "__count__ > 3" },
 *                 },
 *             },
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 6,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "" },
 *                     { "count_condition", "__count__ > 0" },
 *                 },
 *             },
 *             new AliCloud.Log.Inputs.AlertSeverityConfigurationArgs
 *             {
 *                 Severity = 2,
 *                 EvalCondition =
 *                 {
 *                     { "condition", "" },
 *                     { "count_condition", "" },
 *                 },
 *             },
 *         },
 *         JoinConfigurations = new[]
 *         {
 *             new AliCloud.Log.Inputs.AlertJoinConfigurationArgs
 *             {
 *                 Type = "cross_join",
 *                 Condition = "",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example-2", &log.AlertArgs{
 * 			Version:          pulumi.String("2.0"),
 * 			Type:             pulumi.String("default"),
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			MuteUntil:        pulumi.Int(1632486684),
 * 			NoDataFire:       pulumi.Bool(false),
 * 			NoDataSeverity:   pulumi.Int(8),
 * 			SendResolved:     pulumi.Bool(true),
 * 			AutoAnnotation:   pulumi.Bool(true),
 * 			Dashboard:        pulumi.String("example-dashboard"),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			QueryLists: log.AlertQueryListArray{
 * 				&log.AlertQueryListArgs{
 * 					Store:        exampleStore.Name,
 * 					StoreType:    pulumi.String("log"),
 * 					Project:      example.Name,
 * 					Region:       pulumi.String("cn-heyuan"),
 * 					ChartTitle:   pulumi.String("chart_title"),
 * 					Start:        pulumi.String("-60s"),
 * 					End:          pulumi.String("20s"),
 * 					Query:        pulumi.String("* AND aliyun | select count(1) as cnt"),
 * 					PowerSqlMode: pulumi.String("auto"),
 * 				},
 * 				&log.AlertQueryListArgs{
 * 					Store:        exampleStore.Name,
 * 					StoreType:    pulumi.String("log"),
 * 					Project:      example.Name,
 * 					Region:       pulumi.String("cn-heyuan"),
 * 					ChartTitle:   pulumi.String("chart_title"),
 * 					Start:        pulumi.String("-60s"),
 * 					End:          pulumi.String("20s"),
 * 					Query:        pulumi.String("error | select count(1) as error_cnt"),
 * 					PowerSqlMode: pulumi.String("enable"),
 * 				},
 * 			},
 * 			Labels: log.AlertLabelArray{
 * 				&log.AlertLabelArgs{
 * 					Key:   pulumi.String("env"),
 * 					Value: pulumi.String("test"),
 * 				},
 * 			},
 * 			Annotations: log.AlertAnnotationArray{
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("title"),
 * 					Value: pulumi.String("alert title"),
 * 				},
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("desc"),
 * 					Value: pulumi.String("alert desc"),
 * 				},
 * 				&log.AlertAnnotationArgs{
 * 					Key:   pulumi.String("test_key"),
 * 					Value: pulumi.String("test value"),
 * 				},
 * 			},
 * 			GroupConfiguration: &log.AlertGroupConfigurationArgs{
 * 				Type: pulumi.String("custom"),
 * 				Fields: pulumi.StringArray{
 * 					pulumi.String("cnt"),
 * 				},
 * 			},
 * 			PolicyConfiguration: &log.AlertPolicyConfigurationArgs{
 * 				AlertPolicyId:  pulumi.String("sls.bultin"),
 * 				ActionPolicyId: pulumi.String("sls_test_action"),
 * 				RepeatInterval: pulumi.String("4h"),
 * 			},
 * 			SeverityConfigurations: log.AlertSeverityConfigurationArray{
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(8),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String("cnt > 3"),
 * 						"count_condition": pulumi.String("__count__ > 3"),
 * 					},
 * 				},
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(6),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String(""),
 * 						"count_condition": pulumi.String("__count__ > 0"),
 * 					},
 * 				},
 * 				&log.AlertSeverityConfigurationArgs{
 * 					Severity: pulumi.Int(2),
 * 					EvalCondition: pulumi.StringMap{
 * 						"condition":       pulumi.String(""),
 * 						"count_condition": pulumi.String(""),
 * 					},
 * 				},
 * 			},
 * 			JoinConfigurations: log.AlertJoinConfigurationArray{
 * 				&log.AlertJoinConfigurationArgs{
 * 					Type:      pulumi.String("cross_join"),
 * 					Condition: pulumi.String(""),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertQueryListArgs;
 * import com.pulumi.alicloud.log.inputs.AlertLabelArgs;
 * import com.pulumi.alicloud.log.inputs.AlertAnnotationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs;
 * import com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example_2 = new Alert("example-2", AlertArgs.builder()
 *             .version("2.0")
 *             .type("default")
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .muteUntil("1632486684")
 *             .noDataFire("false")
 *             .noDataSeverity(8)
 *             .sendResolved(true)
 *             .autoAnnotation(true)
 *             .dashboard("example-dashboard")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .queryLists(
 *                 AlertQueryListArgs.builder()
 *                     .store(exampleStore.name())
 *                     .storeType("log")
 *                     .project(example.name())
 *                     .region("cn-heyuan")
 *                     .chartTitle("chart_title")
 *                     .start("-60s")
 *                     .end("20s")
 *                     .query("* AND aliyun | select count(1) as cnt")
 *                     .powerSqlMode("auto")
 *                     .build(),
 *                 AlertQueryListArgs.builder()
 *                     .store(exampleStore.name())
 *                     .storeType("log")
 *                     .project(example.name())
 *                     .region("cn-heyuan")
 *                     .chartTitle("chart_title")
 *                     .start("-60s")
 *                     .end("20s")
 *                     .query("error | select count(1) as error_cnt")
 *                     .powerSqlMode("enable")
 *                     .build())
 *             .labels(AlertLabelArgs.builder()
 *                 .key("env")
 *                 .value("test")
 *                 .build())
 *             .annotations(
 *                 AlertAnnotationArgs.builder()
 *                     .key("title")
 *                     .value("alert title")
 *                     .build(),
 *                 AlertAnnotationArgs.builder()
 *                     .key("desc")
 *                     .value("alert desc")
 *                     .build(),
 *                 AlertAnnotationArgs.builder()
 *                     .key("test_key")
 *                     .value("test value")
 *                     .build())
 *             .groupConfiguration(AlertGroupConfigurationArgs.builder()
 *                 .type("custom")
 *                 .fields("cnt")
 *                 .build())
 *             .policyConfiguration(AlertPolicyConfigurationArgs.builder()
 *                 .alertPolicyId("sls.bultin")
 *                 .actionPolicyId("sls_test_action")
 *                 .repeatInterval("4h")
 *                 .build())
 *             .severityConfigurations(
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(8)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", "cnt > 3"),
 *                         Map.entry("count_condition", "__count__ > 3")
 *                     ))
 *                     .build(),
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(6)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", ""),
 *                         Map.entry("count_condition", "__count__ > 0")
 *                     ))
 *                     .build(),
 *                 AlertSeverityConfigurationArgs.builder()
 *                     .severity(2)
 *                     .evalCondition(Map.ofEntries(
 *                         Map.entry("condition", ""),
 *                         Map.entry("count_condition", "")
 *                     ))
 *                     .build())
 *             .joinConfigurations(AlertJoinConfigurationArgs.builder()
 *                 .type("cross_join")
 *                 .condition("")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example-2:
 *     type: alicloud:log:Alert
 *     properties:
 *       version: '2.0'
 *       type: default
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       muteUntil: '1632486684'
 *       noDataFire: 'false'
 *       noDataSeverity: 8
 *       sendResolved: true
 *       autoAnnotation: true
 *       dashboard: example-dashboard
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       queryLists:
 *         - store: ${exampleStore.name}
 *           storeType: log
 *           project: ${example.name}
 *           region: cn-heyuan
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: '* AND aliyun | select count(1) as cnt'
 *           powerSqlMode: auto
 *         - store: ${exampleStore.name}
 *           storeType: log
 *           project: ${example.name}
 *           region: cn-heyuan
 *           chartTitle: chart_title
 *           start: -60s
 *           end: 20s
 *           query: error | select count(1) as error_cnt
 *           powerSqlMode: enable
 *       labels:
 *         - key: env
 *           value: test
 *       annotations:
 *         - key: title
 *           value: alert title
 *         - key: desc
 *           value: alert desc
 *         - key: test_key
 *           value: test value
 *       groupConfiguration:
 *         type: custom
 *         fields:
 *           - cnt
 *       policyConfiguration:
 *         alertPolicyId: sls.bultin
 *         actionPolicyId: sls_test_action
 *         repeatInterval: 4h
 *       severityConfigurations:
 *         - severity: 8
 *           evalCondition:
 *             condition: cnt > 3
 *             count_condition: __count__ > 3
 *         - severity: 6
 *           evalCondition:
 *             condition:
 *             count_condition: __count__ > 0
 *         - severity: 2
 *           evalCondition:
 *             condition:
 *             count_condition:
 *       joinConfigurations:
 *         - type: cross_join
 *           condition:
 * ```
 * <!--End PulumiCodeChooser -->
 * Basic Usage for alert template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example_3 = new alicloud.log.Alert("example-3", {
 *     version: "2.0",
 *     type: "tpl",
 *     projectName: example.name,
 *     alertName: "example-alert",
 *     alertDisplayname: "example-alert",
 *     muteUntil: 1632486684,
 *     schedule: {
 *         type: "FixedRate",
 *         interval: "5m",
 *         hour: 0,
 *         dayOfWeek: 0,
 *         delay: 0,
 *         runImmediately: false,
 *     },
 *     templateConfiguration: {
 *         id: "sls.app.sls_ack.node.down",
 *         type: "sys",
 *         lang: "cn",
 *         annotations: {},
 *         tokens: {
 *             interval_minute: "5",
 *             "default.action_policy": "sls.app.ack.builtin",
 *             "default.severity": "6",
 *             sendResolved: "false",
 *             "default.project": example.name,
 *             "default.logstore": "k8s-event",
 *             "default.repeatInterval": "4h",
 *             trigger_threshold: "1",
 *             "default.clusterId": "example-cluster-id",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_3 = alicloud.log.Alert("example-3",
 *     version="2.0",
 *     type="tpl",
 *     project_name=example.name,
 *     alert_name="example-alert",
 *     alert_displayname="example-alert",
 *     mute_until=1632486684,
 *     schedule={
 *         "type": "FixedRate",
 *         "interval": "5m",
 *         "hour": 0,
 *         "day_of_week": 0,
 *         "delay": 0,
 *         "run_immediately": False,
 *     },
 *     template_configuration={
 *         "id": "sls.app.sls_ack.node.down",
 *         "type": "sys",
 *         "lang": "cn",
 *         "annotations": {},
 *         "tokens": {
 *             "interval_minute": "5",
 *             "default_action_policy": "sls.app.ack.builtin",
 *             "default_severity": "6",
 *             "send_resolved": "false",
 *             "default_project": example.name,
 *             "default_logstore": "k8s-event",
 *             "default_repeat_interval": "4h",
 *             "trigger_threshold": "1",
 *             "default_cluster_id": "example-cluster-id",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example_3 = new AliCloud.Log.Alert("example-3", new()
 *     {
 *         Version = "2.0",
 *         Type = "tpl",
 *         ProjectName = example.Name,
 *         AlertName = "example-alert",
 *         AlertDisplayname = "example-alert",
 *         MuteUntil = 1632486684,
 *         Schedule = new AliCloud.Log.Inputs.AlertScheduleArgs
 *         {
 *             Type = "FixedRate",
 *             Interval = "5m",
 *             Hour = 0,
 *             DayOfWeek = 0,
 *             Delay = 0,
 *             RunImmediately = false,
 *         },
 *         TemplateConfiguration = new AliCloud.Log.Inputs.AlertTemplateConfigurationArgs
 *         {
 *             Id = "sls.app.sls_ack.node.down",
 *             Type = "sys",
 *             Lang = "cn",
 *             Annotations = null,
 *             Tokens =
 *             {
 *                 { "interval_minute", "5" },
 *                 { "default.action_policy", "sls.app.ack.builtin" },
 *                 { "default.severity", "6" },
 *                 { "sendResolved", "false" },
 *                 { "default.project", example.Name },
 *                 { "default.logstore", "k8s-event" },
 *                 { "default.repeatInterval", "4h" },
 *                 { "trigger_threshold", "1" },
 *                 { "default.clusterId", "example-cluster-id" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewAlert(ctx, "example-3", &log.AlertArgs{
 * 			Version:          pulumi.String("2.0"),
 * 			Type:             pulumi.String("tpl"),
 * 			ProjectName:      example.Name,
 * 			AlertName:        pulumi.String("example-alert"),
 * 			AlertDisplayname: pulumi.String("example-alert"),
 * 			MuteUntil:        pulumi.Int(1632486684),
 * 			Schedule: &log.AlertScheduleArgs{
 * 				Type:           pulumi.String("FixedRate"),
 * 				Interval:       pulumi.String("5m"),
 * 				Hour:           pulumi.Int(0),
 * 				DayOfWeek:      pulumi.Int(0),
 * 				Delay:          pulumi.Int(0),
 * 				RunImmediately: pulumi.Bool(false),
 * 			},
 * 			TemplateConfiguration: &log.AlertTemplateConfigurationArgs{
 * 				Id:          pulumi.String("sls.app.sls_ack.node.down"),
 * 				Type:        pulumi.String("sys"),
 * 				Lang:        pulumi.String("cn"),
 * 				Annotations: nil,
 * 				Tokens: pulumi.StringMap{
 * 					"interval_minute":        pulumi.String("5"),
 * 					"default.action_policy":  pulumi.String("sls.app.ack.builtin"),
 * 					"default.severity":       pulumi.String("6"),
 * 					"sendResolved":           pulumi.String("false"),
 * 					"default.project":        example.Name,
 * 					"default.logstore":       pulumi.String("k8s-event"),
 * 					"default.repeatInterval": pulumi.String("4h"),
 * 					"trigger_threshold":      pulumi.String("1"),
 * 					"default.clusterId":      pulumi.String("example-cluster-id"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Alert;
 * import com.pulumi.alicloud.log.AlertArgs;
 * import com.pulumi.alicloud.log.inputs.AlertScheduleArgs;
 * import com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example_3 = new Alert("example-3", AlertArgs.builder()
 *             .version("2.0")
 *             .type("tpl")
 *             .projectName(example.name())
 *             .alertName("example-alert")
 *             .alertDisplayname("example-alert")
 *             .muteUntil("1632486684")
 *             .schedule(AlertScheduleArgs.builder()
 *                 .type("FixedRate")
 *                 .interval("5m")
 *                 .hour(0)
 *                 .dayOfWeek(0)
 *                 .delay(0)
 *                 .runImmediately(false)
 *                 .build())
 *             .templateConfiguration(AlertTemplateConfigurationArgs.builder()
 *                 .id("sls.app.sls_ack.node.down")
 *                 .type("sys")
 *                 .lang("cn")
 *                 .annotations()
 *                 .tokens(Map.ofEntries(
 *                     Map.entry("interval_minute", "5"),
 *                     Map.entry("default.action_policy", "sls.app.ack.builtin"),
 *                     Map.entry("default.severity", "6"),
 *                     Map.entry("sendResolved", "false"),
 *                     Map.entry("default.project", example.name()),
 *                     Map.entry("default.logstore", "k8s-event"),
 *                     Map.entry("default.repeatInterval", "4h"),
 *                     Map.entry("trigger_threshold", "1"),
 *                     Map.entry("default.clusterId", "example-cluster-id")
 *                 ))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example-3:
 *     type: alicloud:log:Alert
 *     properties:
 *       version: '2.0'
 *       type: tpl
 *       projectName: ${example.name}
 *       alertName: example-alert
 *       alertDisplayname: example-alert
 *       muteUntil: '1632486684'
 *       schedule:
 *         type: FixedRate
 *         interval: 5m
 *         hour: 0
 *         dayOfWeek: 0
 *         delay: 0
 *         runImmediately: false
 *       templateConfiguration:
 *         id: sls.app.sls_ack.node.down
 *         type: sys
 *         lang: cn
 *         annotations: {}
 *         tokens:
 *           interval_minute: '5'
 *           default.action_policy: sls.app.ack.builtin
 *           default.severity: '6'
 *           sendResolved: 'false'
 *           default.project: ${example.name}
 *           default.logstore: k8s-event
 *           default.repeatInterval: 4h
 *           trigger_threshold: '1'
 *           default.clusterId: example-cluster-id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log alert can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/alert:Alert example tf-log:tf-log-alert
 * ```
 * @property alertDescription Alert description.
 * @property alertDisplayname Alert displayname.
 * @property alertName Name of logstore for configuring alarm service.
 * @property annotations Annotations for new alert.
 * @property autoAnnotation whether to add automatic annotation, default is false.
 * @property condition Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
 * @property dashboard
 * @property groupConfiguration Group configuration for new alert.
 * @property joinConfigurations Join configuration for different queries.
 * @property labels Labels for new alert.
 * @property muteUntil Timestamp, notifications before closing again.
 * @property noDataFire Switch for whether new alert fires when no data happens, default is false.
 * @property noDataSeverity when no data happens, the severity of new alert.
 * @property notificationLists Alarm information notification list, Deprecated from 1.161.0+.
 * @property notifyThreshold Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
 * @property policyConfiguration Policy configuration for new alert.
 * @property projectName The project name.
 * @property queryLists Multiple conditions for configured alarm query.
 * @property schedule schedule for alert.
 * @property scheduleInterval Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
 * @property scheduleType Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
 * @property sendResolved when new alert is resolved, whether to notify, default is false.
 * @property severityConfigurations Severity configuration for new alert.
 * @property templateConfiguration Template configuration for alert, when `type` is `tpl`.
 * @property threshold Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
 * @property throttling Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
 * @property type The type of new alert, `default` for custom alert, `tpl` for template alert.
 * @property version The version of alert, new alert is 2.0.
 */
public data class AlertArgs(
    public val alertDescription: Output<String>? = null,
    public val alertDisplayname: Output<String>? = null,
    public val alertName: Output<String>? = null,
    public val annotations: Output<List<AlertAnnotationArgs>>? = null,
    public val autoAnnotation: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use eval_condition in severity_configurations
  """,
    )
    public val condition: Output<String>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use dashboardId in query_list
  """,
    )
    public val dashboard: Output<String>? = null,
    public val groupConfiguration: Output<AlertGroupConfigurationArgs>? = null,
    public val joinConfigurations: Output<List<AlertJoinConfigurationArgs>>? = null,
    public val labels: Output<List<AlertLabelArgs>>? = null,
    public val muteUntil: Output<Int>? = null,
    public val noDataFire: Output<Boolean>? = null,
    public val noDataSeverity: Output<Int>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    public val notificationLists: Output<List<AlertNotificationListArgs>>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use threshold
  """,
    )
    public val notifyThreshold: Output<Int>? = null,
    public val policyConfiguration: Output<AlertPolicyConfigurationArgs>? = null,
    public val projectName: Output<String>? = null,
    public val queryLists: Output<List<AlertQueryListArgs>>? = null,
    public val schedule: Output<AlertScheduleArgs>? = null,
    @Deprecated(
        message = """
  Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    public val scheduleInterval: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    public val scheduleType: Output<String>? = null,
    public val sendResolved: Output<Boolean>? = null,
    public val severityConfigurations: Output<List<AlertSeverityConfigurationArgs>>? = null,
    public val templateConfiguration: Output<AlertTemplateConfigurationArgs>? = null,
    public val threshold: Output<Int>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use repeat_interval in policy_configuration
  """,
    )
    public val throttling: Output<String>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.AlertArgs> {
    override fun toJava(): com.pulumi.alicloud.log.AlertArgs =
        com.pulumi.alicloud.log.AlertArgs.builder()
            .alertDescription(alertDescription?.applyValue({ args0 -> args0 }))
            .alertDisplayname(alertDisplayname?.applyValue({ args0 -> args0 }))
            .alertName(alertName?.applyValue({ args0 -> args0 }))
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoAnnotation(autoAnnotation?.applyValue({ args0 -> args0 }))
            .condition(condition?.applyValue({ args0 -> args0 }))
            .dashboard(dashboard?.applyValue({ args0 -> args0 }))
            .groupConfiguration(
                groupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .joinConfigurations(
                joinConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .muteUntil(muteUntil?.applyValue({ args0 -> args0 }))
            .noDataFire(noDataFire?.applyValue({ args0 -> args0 }))
            .noDataSeverity(noDataSeverity?.applyValue({ args0 -> args0 }))
            .notificationLists(
                notificationLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notifyThreshold(notifyThreshold?.applyValue({ args0 -> args0 }))
            .policyConfiguration(
                policyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .queryLists(
                queryLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scheduleInterval(scheduleInterval?.applyValue({ args0 -> args0 }))
            .scheduleType(scheduleType?.applyValue({ args0 -> args0 }))
            .sendResolved(sendResolved?.applyValue({ args0 -> args0 }))
            .severityConfigurations(
                severityConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .templateConfiguration(
                templateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .throttling(throttling?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertArgs].
 */
@PulumiTagMarker
public class AlertArgsBuilder internal constructor() {
    private var alertDescription: Output<String>? = null

    private var alertDisplayname: Output<String>? = null

    private var alertName: Output<String>? = null

    private var annotations: Output<List<AlertAnnotationArgs>>? = null

    private var autoAnnotation: Output<Boolean>? = null

    private var condition: Output<String>? = null

    private var dashboard: Output<String>? = null

    private var groupConfiguration: Output<AlertGroupConfigurationArgs>? = null

    private var joinConfigurations: Output<List<AlertJoinConfigurationArgs>>? = null

    private var labels: Output<List<AlertLabelArgs>>? = null

    private var muteUntil: Output<Int>? = null

    private var noDataFire: Output<Boolean>? = null

    private var noDataSeverity: Output<Int>? = null

    private var notificationLists: Output<List<AlertNotificationListArgs>>? = null

    private var notifyThreshold: Output<Int>? = null

    private var policyConfiguration: Output<AlertPolicyConfigurationArgs>? = null

    private var projectName: Output<String>? = null

    private var queryLists: Output<List<AlertQueryListArgs>>? = null

    private var schedule: Output<AlertScheduleArgs>? = null

    private var scheduleInterval: Output<String>? = null

    private var scheduleType: Output<String>? = null

    private var sendResolved: Output<Boolean>? = null

    private var severityConfigurations: Output<List<AlertSeverityConfigurationArgs>>? = null

    private var templateConfiguration: Output<AlertTemplateConfigurationArgs>? = null

    private var threshold: Output<Int>? = null

    private var throttling: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Alert description.
     */
    @JvmName("uwflibdktfxjqnqb")
    public suspend fun alertDescription(`value`: Output<String>) {
        this.alertDescription = value
    }

    /**
     * @param value Alert displayname.
     */
    @JvmName("holjaxxllncpdbpy")
    public suspend fun alertDisplayname(`value`: Output<String>) {
        this.alertDisplayname = value
    }

    /**
     * @param value Name of logstore for configuring alarm service.
     */
    @JvmName("stoqmimfjjjepsty")
    public suspend fun alertName(`value`: Output<String>) {
        this.alertName = value
    }

    /**
     * @param value Annotations for new alert.
     */
    @JvmName("dychnrlhahdhjtkb")
    public suspend fun annotations(`value`: Output<List<AlertAnnotationArgs>>) {
        this.annotations = value
    }

    @JvmName("kgfgvovfjijotkwh")
    public suspend fun annotations(vararg values: Output<AlertAnnotationArgs>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values Annotations for new alert.
     */
    @JvmName("tdkxvjwceqkhvtrg")
    public suspend fun annotations(values: List<Output<AlertAnnotationArgs>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value whether to add automatic annotation, default is false.
     */
    @JvmName("axetgwbjpdlvbtoj")
    public suspend fun autoAnnotation(`value`: Output<Boolean>) {
        this.autoAnnotation = value
    }

    /**
     * @param value Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use eval_condition in severity_configurations
  """,
    )
    @JvmName("ejyimxfotutlofto")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use dashboardId in query_list
  """,
    )
    @JvmName("qllciolopjxwlewj")
    public suspend fun dashboard(`value`: Output<String>) {
        this.dashboard = value
    }

    /**
     * @param value Group configuration for new alert.
     */
    @JvmName("veysomhpijykixno")
    public suspend fun groupConfiguration(`value`: Output<AlertGroupConfigurationArgs>) {
        this.groupConfiguration = value
    }

    /**
     * @param value Join configuration for different queries.
     */
    @JvmName("ypkregtequjsidjk")
    public suspend fun joinConfigurations(`value`: Output<List<AlertJoinConfigurationArgs>>) {
        this.joinConfigurations = value
    }

    @JvmName("qiptxbyrfnotevsd")
    public suspend fun joinConfigurations(vararg values: Output<AlertJoinConfigurationArgs>) {
        this.joinConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Join configuration for different queries.
     */
    @JvmName("ichmpidykvsxdevo")
    public suspend fun joinConfigurations(values: List<Output<AlertJoinConfigurationArgs>>) {
        this.joinConfigurations = Output.all(values)
    }

    /**
     * @param value Labels for new alert.
     */
    @JvmName("ewxmwkcngqrhdmmc")
    public suspend fun labels(`value`: Output<List<AlertLabelArgs>>) {
        this.labels = value
    }

    @JvmName("xoinempjhkbrawhp")
    public suspend fun labels(vararg values: Output<AlertLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values Labels for new alert.
     */
    @JvmName("wjujokdimqgcjdwh")
    public suspend fun labels(values: List<Output<AlertLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Timestamp, notifications before closing again.
     */
    @JvmName("yhpfoahxquhhaiwx")
    public suspend fun muteUntil(`value`: Output<Int>) {
        this.muteUntil = value
    }

    /**
     * @param value Switch for whether new alert fires when no data happens, default is false.
     */
    @JvmName("fwocnehljsknxtwc")
    public suspend fun noDataFire(`value`: Output<Boolean>) {
        this.noDataFire = value
    }

    /**
     * @param value when no data happens, the severity of new alert.
     */
    @JvmName("cseikkrbcghhsqku")
    public suspend fun noDataSeverity(`value`: Output<Int>) {
        this.noDataSeverity = value
    }

    /**
     * @param value Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("khmfhnlpighhblnv")
    public suspend fun notificationLists(`value`: Output<List<AlertNotificationListArgs>>) {
        this.notificationLists = value
    }

    @JvmName("huajpgsicscfxehi")
    public suspend fun notificationLists(vararg values: Output<AlertNotificationListArgs>) {
        this.notificationLists = Output.all(values.asList())
    }

    /**
     * @param values Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("bslqaghdcxiocltr")
    public suspend fun notificationLists(values: List<Output<AlertNotificationListArgs>>) {
        this.notificationLists = Output.all(values)
    }

    /**
     * @param value Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use threshold
  """,
    )
    @JvmName("xyfnoxdggmwxweeb")
    public suspend fun notifyThreshold(`value`: Output<Int>) {
        this.notifyThreshold = value
    }

    /**
     * @param value Policy configuration for new alert.
     */
    @JvmName("mpytkpkbrbmolsul")
    public suspend fun policyConfiguration(`value`: Output<AlertPolicyConfigurationArgs>) {
        this.policyConfiguration = value
    }

    /**
     * @param value The project name.
     */
    @JvmName("nhmueufksidnabwl")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Multiple conditions for configured alarm query.
     */
    @JvmName("rvkcllkcfbjgyigd")
    public suspend fun queryLists(`value`: Output<List<AlertQueryListArgs>>) {
        this.queryLists = value
    }

    @JvmName("xlyoxwhrbiqhrwrg")
    public suspend fun queryLists(vararg values: Output<AlertQueryListArgs>) {
        this.queryLists = Output.all(values.asList())
    }

    /**
     * @param values Multiple conditions for configured alarm query.
     */
    @JvmName("kbxshqrvgeernbkk")
    public suspend fun queryLists(values: List<Output<AlertQueryListArgs>>) {
        this.queryLists = Output.all(values)
    }

    /**
     * @param value schedule for alert.
     */
    @JvmName("mmqssehhedeqabnu")
    public suspend fun schedule(`value`: Output<AlertScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    @JvmName("meoainugqqbtvkuy")
    public suspend fun scheduleInterval(`value`: Output<String>) {
        this.scheduleInterval = value
    }

    /**
     * @param value Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    @JvmName("bgupyfioobxfiidg")
    public suspend fun scheduleType(`value`: Output<String>) {
        this.scheduleType = value
    }

    /**
     * @param value when new alert is resolved, whether to notify, default is false.
     */
    @JvmName("ppbgrkcpvbfvnchg")
    public suspend fun sendResolved(`value`: Output<Boolean>) {
        this.sendResolved = value
    }

    /**
     * @param value Severity configuration for new alert.
     */
    @JvmName("crhtknsocnshngjt")
    public suspend fun severityConfigurations(`value`: Output<List<AlertSeverityConfigurationArgs>>) {
        this.severityConfigurations = value
    }

    @JvmName("ooehgeoldfxyqxxk")
    public suspend fun severityConfigurations(vararg values: Output<AlertSeverityConfigurationArgs>) {
        this.severityConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Severity configuration for new alert.
     */
    @JvmName("xvwpbcaxidtyuuyg")
    public suspend fun severityConfigurations(values: List<Output<AlertSeverityConfigurationArgs>>) {
        this.severityConfigurations = Output.all(values)
    }

    /**
     * @param value Template configuration for alert, when `type` is `tpl`.
     */
    @JvmName("ubhboykthejbvteg")
    public suspend fun templateConfiguration(`value`: Output<AlertTemplateConfigurationArgs>) {
        this.templateConfiguration = value
    }

    /**
     * @param value Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
     */
    @JvmName("bascwuehmxvgckbk")
    public suspend fun threshold(`value`: Output<Int>) {
        this.threshold = value
    }

    /**
     * @param value Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use repeat_interval in policy_configuration
  """,
    )
    @JvmName("keprbdjliysacqbt")
    public suspend fun throttling(`value`: Output<String>) {
        this.throttling = value
    }

    /**
     * @param value The type of new alert, `default` for custom alert, `tpl` for template alert.
     */
    @JvmName("fgqrodejvioieeoj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The version of alert, new alert is 2.0.
     */
    @JvmName("snxxjsnqnmyhqarp")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Alert description.
     */
    @JvmName("tdibmdsafdaydnsx")
    public suspend fun alertDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDescription = mapped
    }

    /**
     * @param value Alert displayname.
     */
    @JvmName("bobxxdfbmgmpwceh")
    public suspend fun alertDisplayname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDisplayname = mapped
    }

    /**
     * @param value Name of logstore for configuring alarm service.
     */
    @JvmName("evklrjlbvtuwhyrc")
    public suspend fun alertName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertName = mapped
    }

    /**
     * @param value Annotations for new alert.
     */
    @JvmName("krxrgwxroxmsoisa")
    public suspend fun annotations(`value`: List<AlertAnnotationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param argument Annotations for new alert.
     */
    @JvmName("gidunxdjlmicvybp")
    public suspend fun annotations(argument: List<suspend AlertAnnotationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertAnnotationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument Annotations for new alert.
     */
    @JvmName("ittigpwpdnibueip")
    public suspend fun annotations(vararg argument: suspend AlertAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertAnnotationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument Annotations for new alert.
     */
    @JvmName("fwjorskdbwoysejt")
    public suspend fun annotations(argument: suspend AlertAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertAnnotationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param values Annotations for new alert.
     */
    @JvmName("ymhdorxyodufwhpb")
    public suspend fun annotations(vararg values: AlertAnnotationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value whether to add automatic annotation, default is false.
     */
    @JvmName("uodyjwlrnwqvkywe")
    public suspend fun autoAnnotation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAnnotation = mapped
    }

    /**
     * @param value Conditional expression, such as: count> 100, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use eval_condition in severity_configurations
  """,
    )
    @JvmName("feppturuhmmrhvfg")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use dashboardId in query_list
  """,
    )
    @JvmName("jycvmhswspqhvuen")
    public suspend fun dashboard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboard = mapped
    }

    /**
     * @param value Group configuration for new alert.
     */
    @JvmName("oklgphwphsctigqo")
    public suspend fun groupConfiguration(`value`: AlertGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupConfiguration = mapped
    }

    /**
     * @param argument Group configuration for new alert.
     */
    @JvmName("kpiaujasndrxmnhx")
    public suspend fun groupConfiguration(argument: suspend AlertGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertGroupConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.groupConfiguration = mapped
    }

    /**
     * @param value Join configuration for different queries.
     */
    @JvmName("vspieeqgysbvfumt")
    public suspend fun joinConfigurations(`value`: List<AlertJoinConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Join configuration for different queries.
     */
    @JvmName("lpavjyaylcyxcbdp")
    public suspend fun joinConfigurations(argument: List<suspend AlertJoinConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertJoinConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Join configuration for different queries.
     */
    @JvmName("opqgqugbhpeorobb")
    public suspend fun joinConfigurations(vararg argument: suspend AlertJoinConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertJoinConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Join configuration for different queries.
     */
    @JvmName("cgunckuicprktuos")
    public suspend fun joinConfigurations(argument: suspend AlertJoinConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertJoinConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param values Join configuration for different queries.
     */
    @JvmName("skjhmpuvvtwifnxx")
    public suspend fun joinConfigurations(vararg values: AlertJoinConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.joinConfigurations = mapped
    }

    /**
     * @param value Labels for new alert.
     */
    @JvmName("bihckufhbrqraxvo")
    public suspend fun labels(`value`: List<AlertLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument Labels for new alert.
     */
    @JvmName("gyrhfhwdmgxlsuci")
    public suspend fun labels(argument: List<suspend AlertLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AlertLabelArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument Labels for new alert.
     */
    @JvmName("exqudltjoovxstmc")
    public suspend fun labels(vararg argument: suspend AlertLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AlertLabelArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument Labels for new alert.
     */
    @JvmName("itgjrnbbantjnkse")
    public suspend fun labels(argument: suspend AlertLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values Labels for new alert.
     */
    @JvmName("wbiogdynhnjpsttk")
    public suspend fun labels(vararg values: AlertLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Timestamp, notifications before closing again.
     */
    @JvmName("ydcuimtoeoltextp")
    public suspend fun muteUntil(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.muteUntil = mapped
    }

    /**
     * @param value Switch for whether new alert fires when no data happens, default is false.
     */
    @JvmName("ltbaxdxkliueddav")
    public suspend fun noDataFire(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDataFire = mapped
    }

    /**
     * @param value when no data happens, the severity of new alert.
     */
    @JvmName("sorvfdjftotnybkc")
    public suspend fun noDataSeverity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDataSeverity = mapped
    }

    /**
     * @param value Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("ahtmunshptdbcnaq")
    public suspend fun notificationLists(`value`: List<AlertNotificationListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationLists = mapped
    }

    /**
     * @param argument Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("jwmyjxfygtryboor")
    public suspend fun notificationLists(argument: List<suspend AlertNotificationListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertNotificationListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationLists = mapped
    }

    /**
     * @param argument Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("ikfoisuirgqexssb")
    public suspend fun notificationLists(vararg argument: suspend AlertNotificationListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertNotificationListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationLists = mapped
    }

    /**
     * @param argument Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("fymbumiwbcapfbsy")
    public suspend fun notificationLists(argument: suspend AlertNotificationListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertNotificationListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notificationLists = mapped
    }

    /**
     * @param values Alarm information notification list, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use policy_configuration for notification
  """,
    )
    @JvmName("bcxlgrrrciaphjjs")
    public suspend fun notificationLists(vararg values: AlertNotificationListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationLists = mapped
    }

    /**
     * @param value Notification threshold, which is not notified until the number of triggers is reached. The default is 1, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use threshold
  """,
    )
    @JvmName("lxjrerwhycjvvbdr")
    public suspend fun notifyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyThreshold = mapped
    }

    /**
     * @param value Policy configuration for new alert.
     */
    @JvmName("yhshqspafkeixykn")
    public suspend fun policyConfiguration(`value`: AlertPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyConfiguration = mapped
    }

    /**
     * @param argument Policy configuration for new alert.
     */
    @JvmName("tvucydobnmiwbujt")
    public suspend fun policyConfiguration(argument: suspend AlertPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertPolicyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policyConfiguration = mapped
    }

    /**
     * @param value The project name.
     */
    @JvmName("mqtyhvftvxofgwsl")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Multiple conditions for configured alarm query.
     */
    @JvmName("mdudwwoprmomekqx")
    public suspend fun queryLists(`value`: List<AlertQueryListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryLists = mapped
    }

    /**
     * @param argument Multiple conditions for configured alarm query.
     */
    @JvmName("qdrslksoceapvqbx")
    public suspend fun queryLists(argument: List<suspend AlertQueryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertQueryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param argument Multiple conditions for configured alarm query.
     */
    @JvmName("nfrbuqfnhqvdmdex")
    public suspend fun queryLists(vararg argument: suspend AlertQueryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertQueryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param argument Multiple conditions for configured alarm query.
     */
    @JvmName("whoakthrrhinrxiq")
    public suspend fun queryLists(argument: suspend AlertQueryListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertQueryListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param values Multiple conditions for configured alarm query.
     */
    @JvmName("ankgwumnaecivrtl")
    public suspend fun queryLists(vararg values: AlertQueryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryLists = mapped
    }

    /**
     * @param value schedule for alert.
     */
    @JvmName("ksckwanpydlppnaq")
    public suspend fun schedule(`value`: AlertScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument schedule for alert.
     */
    @JvmName("ubhwdyugfpsgldfr")
    public suspend fun schedule(argument: suspend AlertScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = AlertScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Execution interval. 60 seconds minimum, such as 60s, 1h. Deprecated from 1.176.0+. use interval in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_interval' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    @JvmName("qtyjqpgskayritki")
    public suspend fun scheduleInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleInterval = mapped
    }

    /**
     * @param value Default FixedRate. No need to configure this parameter. Deprecated from 1.176.0+. use type in schedule.
     */
    @Deprecated(
        message = """
  Field 'schedule_type' has been deprecated from provider version 1.176.0. New field 'schedule'
      instead.
  """,
    )
    @JvmName("hyibwxwrmsicqabs")
    public suspend fun scheduleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleType = mapped
    }

    /**
     * @param value when new alert is resolved, whether to notify, default is false.
     */
    @JvmName("ldonkshlvxvprrlj")
    public suspend fun sendResolved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendResolved = mapped
    }

    /**
     * @param value Severity configuration for new alert.
     */
    @JvmName("uomjpcfqxkfkdmfu")
    public suspend fun severityConfigurations(`value`: List<AlertSeverityConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Severity configuration for new alert.
     */
    @JvmName("xornnirsjkutyhog")
    public suspend fun severityConfigurations(argument: List<suspend AlertSeverityConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertSeverityConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Severity configuration for new alert.
     */
    @JvmName("mdxgekdueflmumbw")
    public suspend fun severityConfigurations(vararg argument: suspend AlertSeverityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertSeverityConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Severity configuration for new alert.
     */
    @JvmName("dhscseqjqcnvdofl")
    public suspend fun severityConfigurations(argument: suspend AlertSeverityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertSeverityConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param values Severity configuration for new alert.
     */
    @JvmName("whckbeyqhxbwjotl")
    public suspend fun severityConfigurations(vararg values: AlertSeverityConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severityConfigurations = mapped
    }

    /**
     * @param value Template configuration for alert, when `type` is `tpl`.
     */
    @JvmName("vgpcufkglttyyqyi")
    public suspend fun templateConfiguration(`value`: AlertTemplateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateConfiguration = mapped
    }

    /**
     * @param argument Template configuration for alert, when `type` is `tpl`.
     */
    @JvmName("vteolwjeykdapvom")
    public suspend fun templateConfiguration(argument: suspend AlertTemplateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertTemplateConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateConfiguration = mapped
    }

    /**
     * @param value Evaluation threshold, alert will not fire until the number of triggers is reached. The default is 1.
     */
    @JvmName("acjpbmxlnjvywqpn")
    public suspend fun threshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value Notification interval, default is no interval. Support number + unit type, for example 60s, 1h, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use repeat_interval in policy_configuration
  """,
    )
    @JvmName("udxtgyobqckujjlp")
    public suspend fun throttling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttling = mapped
    }

    /**
     * @param value The type of new alert, `default` for custom alert, `tpl` for template alert.
     */
    @JvmName("xgnstduaisgwthru")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The version of alert, new alert is 2.0.
     */
    @JvmName("yvsiosltyippwhdm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AlertArgs = AlertArgs(
        alertDescription = alertDescription,
        alertDisplayname = alertDisplayname,
        alertName = alertName,
        annotations = annotations,
        autoAnnotation = autoAnnotation,
        condition = condition,
        dashboard = dashboard,
        groupConfiguration = groupConfiguration,
        joinConfigurations = joinConfigurations,
        labels = labels,
        muteUntil = muteUntil,
        noDataFire = noDataFire,
        noDataSeverity = noDataSeverity,
        notificationLists = notificationLists,
        notifyThreshold = notifyThreshold,
        policyConfiguration = policyConfiguration,
        projectName = projectName,
        queryLists = queryLists,
        schedule = schedule,
        scheduleInterval = scheduleInterval,
        scheduleType = scheduleType,
        sendResolved = sendResolved,
        severityConfigurations = severityConfigurations,
        templateConfiguration = templateConfiguration,
        threshold = threshold,
        throttling = throttling,
        type = type,
        version = version,
    )
}
