@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlertResource].
 */
@PulumiTagMarker
public class AlertResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertResourceArgs = AlertResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertResourceArgsBuilder.() -> Unit) {
        val builder = AlertResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlertResource {
        val builtJavaResource = com.pulumi.alicloud.log.AlertResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlertResource(builtJavaResource)
    }
}

/**
 * Using this resource can init SLS Alert resources automatically.
 * For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)
 * > **NOTE:** Available since v1.219.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const exampleUser = new alicloud.log.AlertResource("example_user", {
 *     type: "user",
 *     lang: "cn",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example_user = alicloud.log.AlertResource("example_user",
 *     type="user",
 *     lang="cn")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUser = new AliCloud.Log.AlertResource("example_user", new()
 *     {
 *         Type = "user",
 *         Lang = "cn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := log.NewAlertResource(ctx, "example_user", &log.AlertResourceArgs{
 * 			Type: pulumi.String("user"),
 * 			Lang: pulumi.String("cn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.AlertResource;
 * import com.pulumi.alicloud.log.AlertResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new AlertResource("exampleUser", AlertResourceArgs.builder()
 *             .type("user")
 *             .lang("cn")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleUser:
 *     type: alicloud:log:AlertResource
 *     name: example_user
 *     properties:
 *       type: user
 *       lang: cn
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log alert resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/alertResource:AlertResource example alert_resource:project:tf-project
 * ```
 */
public class AlertResource internal constructor(
    override val javaResource: com.pulumi.alicloud.log.AlertResource,
) : KotlinCustomResource(javaResource, AlertResourceMapper) {
    /**
     * The lang of alert center resource when type is user.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The project of alert resource when type is project.
     */
    public val project: Output<String>?
        get() = javaResource.project().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AlertResourceMapper : ResourceMapper<AlertResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.AlertResource::class == javaResource::class

    override fun map(javaResource: Resource): AlertResource = AlertResource(
        javaResource as
            com.pulumi.alicloud.log.AlertResource,
    )
}

/**
 * @see [AlertResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertResource].
 */
public suspend fun alertResource(
    name: String,
    block: suspend AlertResourceResourceBuilder.() -> Unit,
): AlertResource {
    val builder = AlertResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertResource(name: String): AlertResource {
    val builder = AlertResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
