@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.AlertResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Using this resource can init SLS Alert resources automatically.
 * For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)
 * > **NOTE:** Available since v1.219.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const exampleUser = new alicloud.log.AlertResource("example_user", {
 *     type: "user",
 *     lang: "cn",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example_user = alicloud.log.AlertResource("example_user",
 *     type="user",
 *     lang="cn")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUser = new AliCloud.Log.AlertResource("example_user", new()
 *     {
 *         Type = "user",
 *         Lang = "cn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := log.NewAlertResource(ctx, "example_user", &log.AlertResourceArgs{
 * 			Type: pulumi.String("user"),
 * 			Lang: pulumi.String("cn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.AlertResource;
 * import com.pulumi.alicloud.log.AlertResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUser = new AlertResource("exampleUser", AlertResourceArgs.builder()
 *             .type("user")
 *             .lang("cn")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleUser:
 *     type: alicloud:log:AlertResource
 *     name: example_user
 *     properties:
 *       type: user
 *       lang: cn
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log alert resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/alertResource:AlertResource example alert_resource:project:tf-project
 * ```
 * @property lang The lang of alert center resource when type is user.
 * @property project The project of alert resource when type is project.
 * @property type The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
 */
public data class AlertResourceArgs(
    public val lang: Output<String>? = null,
    public val project: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.AlertResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.log.AlertResourceArgs =
        com.pulumi.alicloud.log.AlertResourceArgs.builder()
            .lang(lang?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertResourceArgs].
 */
@PulumiTagMarker
public class AlertResourceArgsBuilder internal constructor() {
    private var lang: Output<String>? = null

    private var project: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The lang of alert center resource when type is user.
     */
    @JvmName("qioagrhmjlolshbx")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The project of alert resource when type is project.
     */
    @JvmName("jywoehlkhrsojmdp")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
     */
    @JvmName("fmmbdsrjtabiucdn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The lang of alert center resource when type is user.
     */
    @JvmName("jxxpcdsqqwboeybf")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The project of alert resource when type is project.
     */
    @JvmName("twuospqfvkflthep")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
     */
    @JvmName("kajdpodktaejvlyu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertResourceArgs = AlertResourceArgs(
        lang = lang,
        project = project,
        type = type,
    )
}
