@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.DashboardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The dashboard is a real-time data analysis platform provided by the log service. You can display frequently used query and analysis statements in the form of charts and save statistical charts to the dashboard.
 * [Refer to details](https://www.alibabacloud.com/help/doc-detail/102530.htm).
 * > **NOTE:** Available since v1.86.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleDashboard = new alicloud.log.Dashboard("example", {
 *     projectName: example.name,
 *     dashboardName: "terraform-example",
 *     displayName: "terraform-example",
 *     attribute: `  {
 *     "type":"grid"
 *   }
 * `,
 *     charList: `  [
 *     {
 *       "action": {},
 *       "title":"new_title",
 *       "type":"map",
 *       "search":{
 *         "logstore":"example-store",
 *         "topic":"new_topic",
 *         "query":"* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product",
 *         "start":"-86400s",
 *         "end":"now"
 *       },
 *       "display":{
 *         "xAxis":[
 *           "ct_name"
 *         ],
 *         "yAxis":[
 *           "ct_product"
 *         ],
 *         "xPos":0,
 *         "yPos":0,
 *         "width":10,
 *         "height":12,
 *         "displayName":"terraform-example"
 *       }
 *     }
 *   ]
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_dashboard = alicloud.log.Dashboard("example",
 *     project_name=example.name,
 *     dashboard_name="terraform-example",
 *     display_name="terraform-example",
 *     attribute="""  {
 *     "type":"grid"
 *   }
 * """,
 *     char_list="""  [
 *     {
 *       "action": {},
 *       "title":"new_title",
 *       "type":"map",
 *       "search":{
 *         "logstore":"example-store",
 *         "topic":"new_topic",
 *         "query":"* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product",
 *         "start":"-86400s",
 *         "end":"now"
 *       },
 *       "display":{
 *         "xAxis":[
 *           "ct_name"
 *         ],
 *         "yAxis":[
 *           "ct_product"
 *         ],
 *         "xPos":0,
 *         "yPos":0,
 *         "width":10,
 *         "height":12,
 *         "displayName":"terraform-example"
 *       }
 *     }
 *   ]
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleDashboard = new AliCloud.Log.Dashboard("example", new()
 *     {
 *         ProjectName = example.Name,
 *         DashboardName = "terraform-example",
 *         DisplayName = "terraform-example",
 *         Attribute = @"  {
 *     ""type"":""grid""
 *   }
 * ",
 *         CharList = @"  [
 *     {
 *       ""action"": {},
 *       ""title"":""new_title"",
 *       ""type"":""map"",
 *       ""search"":{
 *         ""logstore"":""example-store"",
 *         ""topic"":""new_topic"",
 *         ""query"":""* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product"",
 *         ""start"":""-86400s"",
 *         ""end"":""now""
 *       },
 *       ""display"":{
 *         ""xAxis"":[
 *           ""ct_name""
 *         ],
 *         ""yAxis"":[
 *           ""ct_product""
 *         ],
 *         ""xPos"":0,
 *         ""yPos"":0,
 *         ""width"":10,
 *         ""height"":12,
 *         ""displayName"":""terraform-example""
 *       }
 *     }
 *   ]
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewDashboard(ctx, "example", &log.DashboardArgs{
 * 			ProjectName:   example.Name,
 * 			DashboardName: pulumi.String("terraform-example"),
 * 			DisplayName:   pulumi.String("terraform-example"),
 * 			Attribute:     pulumi.String("  {\n    \"type\":\"grid\"\n  }\n"),
 * 			CharList: pulumi.String(`  [
 *     {
 *       "action": {},
 *       "title":"new_title",
 *       "type":"map",
 *       "search":{
 *         "logstore":"example-store",
 *         "topic":"new_topic",
 *         "query":"* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product",
 *         "start":"-86400s",
 *         "end":"now"
 *       },
 *       "display":{
 *         "xAxis":[
 *           "ct_name"
 *         ],
 *         "yAxis":[
 *           "ct_product"
 *         ],
 *         "xPos":0,
 *         "yPos":0,
 *         "width":10,
 *         "height":12,
 *         "displayName":"terraform-example"
 *       }
 *     }
 *   ]
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Dashboard;
 * import com.pulumi.alicloud.log.DashboardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleDashboard = new Dashboard("exampleDashboard", DashboardArgs.builder()
 *             .projectName(example.name())
 *             .dashboardName("terraform-example")
 *             .displayName("terraform-example")
 *             .attribute("""
 *   {
 *     "type":"grid"
 *   }
 *             """)
 *             .charList("""
 *   [
 *     {
 *       "action": {},
 *       "title":"new_title",
 *       "type":"map",
 *       "search":{
 *         "logstore":"example-store",
 *         "topic":"new_topic",
 *         "query":"* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product",
 *         "start":"-86400s",
 *         "end":"now"
 *       },
 *       "display":{
 *         "xAxis":[
 *           "ct_name"
 *         ],
 *         "yAxis":[
 *           "ct_product"
 *         ],
 *         "xPos":0,
 *         "yPos":0,
 *         "width":10,
 *         "height":12,
 *         "displayName":"terraform-example"
 *       }
 *     }
 *   ]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleDashboard:
 *     type: alicloud:log:Dashboard
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       dashboardName: terraform-example
 *       displayName: terraform-example
 *       attribute: |2
 *           {
 *             "type":"grid"
 *           }
 *       charList: |2
 *           [
 *             {
 *               "action": {},
 *               "title":"new_title",
 *               "type":"map",
 *               "search":{
 *                 "logstore":"example-store",
 *                 "topic":"new_topic",
 *                 "query":"* | SELECT COUNT(name) as ct_name, COUNT(product) as ct_product, name,product GROUP BY name,product",
 *                 "start":"-86400s",
 *                 "end":"now"
 *               },
 *               "display":{
 *                 "xAxis":[
 *                   "ct_name"
 *                 ],
 *                 "yAxis":[
 *                   "ct_product"
 *                 ],
 *                 "xPos":0,
 *                 "yPos":0,
 *                 "width":10,
 *                 "height":12,
 *                 "displayName":"terraform-example"
 *               }
 *             }
 *           ]
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log Dashboard can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/dashboard:Dashboard example <project_name>:<dashboard_name>
 * ```
 * @property attribute Dashboard attribute.
 * @property charList Configuration of charts in the dashboard.
 * **Note:** From version 1.164.0, `char_list` can set parameter "action".
 * @property dashboardName The name of the Log Dashboard.
 * @property displayName Dashboard alias.
 * @property projectName The name of the log project. It is the only in one Alicloud account.
 */
public data class DashboardArgs(
    public val attribute: Output<String>? = null,
    public val charList: Output<String>? = null,
    public val dashboardName: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val projectName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.DashboardArgs> {
    override fun toJava(): com.pulumi.alicloud.log.DashboardArgs =
        com.pulumi.alicloud.log.DashboardArgs.builder()
            .attribute(attribute?.applyValue({ args0 -> args0 }))
            .charList(charList?.applyValue({ args0 -> args0 }))
            .dashboardName(dashboardName?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var attribute: Output<String>? = null

    private var charList: Output<String>? = null

    private var dashboardName: Output<String>? = null

    private var displayName: Output<String>? = null

    private var projectName: Output<String>? = null

    /**
     * @param value Dashboard attribute.
     */
    @JvmName("xisfstganiarmhgj")
    public suspend fun attribute(`value`: Output<String>) {
        this.attribute = value
    }

    /**
     * @param value Configuration of charts in the dashboard.
     * **Note:** From version 1.164.0, `char_list` can set parameter "action".
     */
    @JvmName("itvfgdcubdpjvhqr")
    public suspend fun charList(`value`: Output<String>) {
        this.charList = value
    }

    /**
     * @param value The name of the Log Dashboard.
     */
    @JvmName("xifggfotpnyoywkt")
    public suspend fun dashboardName(`value`: Output<String>) {
        this.dashboardName = value
    }

    /**
     * @param value Dashboard alias.
     */
    @JvmName("ixqjuqngfqknuprk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("ydthgwkriavskmlx")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Dashboard attribute.
     */
    @JvmName("sexpanyjemraphgv")
    public suspend fun attribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value Configuration of charts in the dashboard.
     * **Note:** From version 1.164.0, `char_list` can set parameter "action".
     */
    @JvmName("ekercxrkrpdodosq")
    public suspend fun charList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.charList = mapped
    }

    /**
     * @param value The name of the Log Dashboard.
     */
    @JvmName("mboixpcmkiefhmhd")
    public suspend fun dashboardName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardName = mapped
    }

    /**
     * @param value Dashboard alias.
     */
    @JvmName("eaaajicqdpoqgyfe")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("xaeahvuqyyreqred")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        attribute = attribute,
        charList = charList,
        dashboardName = dashboardName,
        displayName = displayName,
        projectName = projectName,
    )
}
