@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.kotlin.outputs.EtlEtlSink
import com.pulumi.alicloud.log.kotlin.outputs.EtlEtlSink.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Etl].
 */
@PulumiTagMarker
public class EtlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EtlArgs = EtlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EtlArgsBuilder.() -> Unit) {
        val builder = EtlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Etl {
        val builtJavaResource = com.pulumi.alicloud.log.Etl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Etl(builtJavaResource)
    }
}

/**
 * The data transformation of the log service is a hosted, highly available, and scalable data processing service,
 * which is widely applicable to scenarios such as data regularization, enrichment, distribution, aggregation, and index reconstruction.
 * [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).
 * > **NOTE:** Available in 1.120.0
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example2 = new alicloud.log.Store("example2", {
 *     project: example.name,
 *     name: "example-store2",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example3 = new alicloud.log.Store("example3", {
 *     project: example.name,
 *     name: "example-store3",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleEtl = new alicloud.log.Etl("example", {
 *     etlName: "terraform-example",
 *     project: example.name,
 *     displayName: "terraform-example",
 *     description: "terraform-example",
 *     accessKeyId: "access_key_id",
 *     accessKeySecret: "access_key_secret",
 *     script: "e_set('new','key')",
 *     logstore: exampleStore.name,
 *     etlSinks: [
 *         {
 *             name: "target_name",
 *             accessKeyId: "example2_access_key_id",
 *             accessKeySecret: "example2_access_key_secret",
 *             endpoint: "cn-hangzhou.log.aliyuncs.com",
 *             project: example.name,
 *             logstore: example2.name,
 *         },
 *         {
 *             name: "target_name2",
 *             accessKeyId: "example3_access_key_id",
 *             accessKeySecret: "example3_access_key_secret",
 *             endpoint: "cn-hangzhou.log.aliyuncs.com",
 *             project: example.name,
 *             logstore: example3.name,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example2 = alicloud.log.Store("example2",
 *     project=example.name,
 *     name="example-store2",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example3 = alicloud.log.Store("example3",
 *     project=example.name,
 *     name="example-store3",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_etl = alicloud.log.Etl("example",
 *     etl_name="terraform-example",
 *     project=example.name,
 *     display_name="terraform-example",
 *     description="terraform-example",
 *     access_key_id="access_key_id",
 *     access_key_secret="access_key_secret",
 *     script="e_set('new','key')",
 *     logstore=example_store.name,
 *     etl_sinks=[
 *         {
 *             "name": "target_name",
 *             "access_key_id": "example2_access_key_id",
 *             "access_key_secret": "example2_access_key_secret",
 *             "endpoint": "cn-hangzhou.log.aliyuncs.com",
 *             "project": example.name,
 *             "logstore": example2.name,
 *         },
 *         {
 *             "name": "target_name2",
 *             "access_key_id": "example3_access_key_id",
 *             "access_key_secret": "example3_access_key_secret",
 *             "endpoint": "cn-hangzhou.log.aliyuncs.com",
 *             "project": example.name,
 *             "logstore": example3.name,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example2 = new AliCloud.Log.Store("example2", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store2",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example3 = new AliCloud.Log.Store("example3", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store3",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleEtl = new AliCloud.Log.Etl("example", new()
 *     {
 *         EtlName = "terraform-example",
 *         Project = example.Name,
 *         DisplayName = "terraform-example",
 *         Description = "terraform-example",
 *         AccessKeyId = "access_key_id",
 *         AccessKeySecret = "access_key_secret",
 *         Script = "e_set('new','key')",
 *         Logstore = exampleStore.Name,
 *         EtlSinks = new[]
 *         {
 *             new AliCloud.Log.Inputs.EtlEtlSinkArgs
 *             {
 *                 Name = "target_name",
 *                 AccessKeyId = "example2_access_key_id",
 *                 AccessKeySecret = "example2_access_key_secret",
 *                 Endpoint = "cn-hangzhou.log.aliyuncs.com",
 *                 Project = example.Name,
 *                 Logstore = example2.Name,
 *             },
 *             new AliCloud.Log.Inputs.EtlEtlSinkArgs
 *             {
 *                 Name = "target_name2",
 *                 AccessKeyId = "example3_access_key_id",
 *                 AccessKeySecret = "example3_access_key_secret",
 *                 Endpoint = "cn-hangzhou.log.aliyuncs.com",
 *                 Project = example.Name,
 *                 Logstore = example3.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example2, err := log.NewStore(ctx, "example2", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store2"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example3, err := log.NewStore(ctx, "example3", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store3"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewEtl(ctx, "example", &log.EtlArgs{
 * 			EtlName:         pulumi.String("terraform-example"),
 * 			Project:         example.Name,
 * 			DisplayName:     pulumi.String("terraform-example"),
 * 			Description:     pulumi.String("terraform-example"),
 * 			AccessKeyId:     pulumi.String("access_key_id"),
 * 			AccessKeySecret: pulumi.String("access_key_secret"),
 * 			Script:          pulumi.String("e_set('new','key')"),
 * 			Logstore:        exampleStore.Name,
 * 			EtlSinks: log.EtlEtlSinkArray{
 * 				&log.EtlEtlSinkArgs{
 * 					Name:            pulumi.String("target_name"),
 * 					AccessKeyId:     pulumi.String("example2_access_key_id"),
 * 					AccessKeySecret: pulumi.String("example2_access_key_secret"),
 * 					Endpoint:        pulumi.String("cn-hangzhou.log.aliyuncs.com"),
 * 					Project:         example.Name,
 * 					Logstore:        example2.Name,
 * 				},
 * 				&log.EtlEtlSinkArgs{
 * 					Name:            pulumi.String("target_name2"),
 * 					AccessKeyId:     pulumi.String("example3_access_key_id"),
 * 					AccessKeySecret: pulumi.String("example3_access_key_secret"),
 * 					Endpoint:        pulumi.String("cn-hangzhou.log.aliyuncs.com"),
 * 					Project:         example.Name,
 * 					Logstore:        example3.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Etl;
 * import com.pulumi.alicloud.log.EtlArgs;
 * import com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example2 = new Store("example2", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store2")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example3 = new Store("example3", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store3")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleEtl = new Etl("exampleEtl", EtlArgs.builder()
 *             .etlName("terraform-example")
 *             .project(example.name())
 *             .displayName("terraform-example")
 *             .description("terraform-example")
 *             .accessKeyId("access_key_id")
 *             .accessKeySecret("access_key_secret")
 *             .script("e_set('new','key')")
 *             .logstore(exampleStore.name())
 *             .etlSinks(
 *                 EtlEtlSinkArgs.builder()
 *                     .name("target_name")
 *                     .accessKeyId("example2_access_key_id")
 *                     .accessKeySecret("example2_access_key_secret")
 *                     .endpoint("cn-hangzhou.log.aliyuncs.com")
 *                     .project(example.name())
 *                     .logstore(example2.name())
 *                     .build(),
 *                 EtlEtlSinkArgs.builder()
 *                     .name("target_name2")
 *                     .accessKeyId("example3_access_key_id")
 *                     .accessKeySecret("example3_access_key_secret")
 *                     .endpoint("cn-hangzhou.log.aliyuncs.com")
 *                     .project(example.name())
 *                     .logstore(example3.name())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example2:
 *     type: alicloud:log:Store
 *     properties:
 *       project: ${example.name}
 *       name: example-store2
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example3:
 *     type: alicloud:log:Store
 *     properties:
 *       project: ${example.name}
 *       name: example-store3
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleEtl:
 *     type: alicloud:log:Etl
 *     name: example
 *     properties:
 *       etlName: terraform-example
 *       project: ${example.name}
 *       displayName: terraform-example
 *       description: terraform-example
 *       accessKeyId: access_key_id
 *       accessKeySecret: access_key_secret
 *       script: e_set('new','key')
 *       logstore: ${exampleStore.name}
 *       etlSinks:
 *         - name: target_name
 *           accessKeyId: example2_access_key_id
 *           accessKeySecret: example2_access_key_secret
 *           endpoint: cn-hangzhou.log.aliyuncs.com
 *           project: ${example.name}
 *           logstore: ${example2.name}
 *         - name: target_name2
 *           accessKeyId: example3_access_key_id
 *           accessKeySecret: example3_access_key_secret
 *           endpoint: cn-hangzhou.log.aliyuncs.com
 *           project: ${example.name}
 *           logstore: ${example3.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log etl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/etl:Etl example tf-log-project:tf-log-etl-name
 * ```
 */
public class Etl internal constructor(
    override val javaResource: com.pulumi.alicloud.log.Etl,
) : KotlinCustomResource(javaResource, EtlMapper) {
    /**
     * Source logstore access key id.
     */
    public val accessKeyId: Output<String>?
        get() = javaResource.accessKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source logstore access key secret.
     */
    public val accessKeySecret: Output<String>?
        get() = javaResource.accessKeySecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The etl job create time.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the log etl job.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Log service etl job alias.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The name of the log etl job.
     */
    public val etlName: Output<String>
        get() = javaResource.etlName().applyValue({ args0 -> args0 })

    /**
     * Target logstore configuration for delivery after data processing.
     */
    public val etlSinks: Output<List<EtlEtlSink>>
        get() = javaResource.etlSinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Log service etl type, the default value is `ETL`.
     */
    public val etlType: Output<String>?
        get() = javaResource.etlType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
     */
    public val fromTime: Output<Int>?
        get() = javaResource.fromTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
     */
    public val kmsEncryptedAccessKeyId: Output<String>?
        get() = javaResource.kmsEncryptedAccessKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
     */
    public val kmsEncryptedAccessKeySecret: Output<String>?
        get() = javaResource.kmsEncryptedAccessKeySecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    public val kmsEncryptionAccessKeyIdContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionAccessKeyIdContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    public val kmsEncryptionAccessKeySecretContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionAccessKeySecretContext().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }).orElse(null)
        })

    /**
     * ETL job last modified time.
     */
    public val lastModifiedTime: Output<Int>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The source logstore of the processing job.
     */
    public val logstore: Output<String>
        get() = javaResource.logstore().applyValue({ args0 -> args0 })

    /**
     * Advanced parameter configuration of processing operations.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the project where the etl job is located.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Job scheduling type, the default value is Resident.
     */
    public val schedule: Output<String>?
        get() = javaResource.schedule().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Processing operation grammar.
     */
    public val script: Output<String>
        get() = javaResource.script().applyValue({ args0 -> args0 })

    /**
     * Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
     */
    public val toTime: Output<Int>?
        get() = javaResource.toTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Log etl job version. the default value is `2`.
     */
    public val version: Output<Int>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EtlMapper : ResourceMapper<Etl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.Etl::class == javaResource::class

    override fun map(javaResource: Resource): Etl = Etl(javaResource as com.pulumi.alicloud.log.Etl)
}

/**
 * @see [Etl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Etl].
 */
public suspend fun etl(name: String, block: suspend EtlResourceBuilder.() -> Unit): Etl {
    val builder = EtlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Etl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun etl(name: String): Etl {
    val builder = EtlResourceBuilder()
    builder.name(name)
    return builder.build()
}
