@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.EtlArgs.builder
import com.pulumi.alicloud.log.kotlin.inputs.EtlEtlSinkArgs
import com.pulumi.alicloud.log.kotlin.inputs.EtlEtlSinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The data transformation of the log service is a hosted, highly available, and scalable data processing service,
 * which is widely applicable to scenarios such as data regularization, enrichment, distribution, aggregation, and index reconstruction.
 * [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).
 * > **NOTE:** Available in 1.120.0
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example2 = new alicloud.log.Store("example2", {
 *     project: example.name,
 *     name: "example-store2",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const example3 = new alicloud.log.Store("example3", {
 *     project: example.name,
 *     name: "example-store3",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleEtl = new alicloud.log.Etl("example", {
 *     etlName: "terraform-example",
 *     project: example.name,
 *     displayName: "terraform-example",
 *     description: "terraform-example",
 *     accessKeyId: "access_key_id",
 *     accessKeySecret: "access_key_secret",
 *     script: "e_set('new','key')",
 *     logstore: exampleStore.name,
 *     etlSinks: [
 *         {
 *             name: "target_name",
 *             accessKeyId: "example2_access_key_id",
 *             accessKeySecret: "example2_access_key_secret",
 *             endpoint: "cn-hangzhou.log.aliyuncs.com",
 *             project: example.name,
 *             logstore: example2.name,
 *         },
 *         {
 *             name: "target_name2",
 *             accessKeyId: "example3_access_key_id",
 *             accessKeySecret: "example3_access_key_secret",
 *             endpoint: "cn-hangzhou.log.aliyuncs.com",
 *             project: example.name,
 *             logstore: example3.name,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example2 = alicloud.log.Store("example2",
 *     project=example.name,
 *     name="example-store2",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example3 = alicloud.log.Store("example3",
 *     project=example.name,
 *     name="example-store3",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_etl = alicloud.log.Etl("example",
 *     etl_name="terraform-example",
 *     project=example.name,
 *     display_name="terraform-example",
 *     description="terraform-example",
 *     access_key_id="access_key_id",
 *     access_key_secret="access_key_secret",
 *     script="e_set('new','key')",
 *     logstore=example_store.name,
 *     etl_sinks=[
 *         {
 *             "name": "target_name",
 *             "access_key_id": "example2_access_key_id",
 *             "access_key_secret": "example2_access_key_secret",
 *             "endpoint": "cn-hangzhou.log.aliyuncs.com",
 *             "project": example.name,
 *             "logstore": example2.name,
 *         },
 *         {
 *             "name": "target_name2",
 *             "access_key_id": "example3_access_key_id",
 *             "access_key_secret": "example3_access_key_secret",
 *             "endpoint": "cn-hangzhou.log.aliyuncs.com",
 *             "project": example.name,
 *             "logstore": example3.name,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example2 = new AliCloud.Log.Store("example2", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store2",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var example3 = new AliCloud.Log.Store("example3", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store3",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleEtl = new AliCloud.Log.Etl("example", new()
 *     {
 *         EtlName = "terraform-example",
 *         Project = example.Name,
 *         DisplayName = "terraform-example",
 *         Description = "terraform-example",
 *         AccessKeyId = "access_key_id",
 *         AccessKeySecret = "access_key_secret",
 *         Script = "e_set('new','key')",
 *         Logstore = exampleStore.Name,
 *         EtlSinks = new[]
 *         {
 *             new AliCloud.Log.Inputs.EtlEtlSinkArgs
 *             {
 *                 Name = "target_name",
 *                 AccessKeyId = "example2_access_key_id",
 *                 AccessKeySecret = "example2_access_key_secret",
 *                 Endpoint = "cn-hangzhou.log.aliyuncs.com",
 *                 Project = example.Name,
 *                 Logstore = example2.Name,
 *             },
 *             new AliCloud.Log.Inputs.EtlEtlSinkArgs
 *             {
 *                 Name = "target_name2",
 *                 AccessKeyId = "example3_access_key_id",
 *                 AccessKeySecret = "example3_access_key_secret",
 *                 Endpoint = "cn-hangzhou.log.aliyuncs.com",
 *                 Project = example.Name,
 *                 Logstore = example3.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example2, err := log.NewStore(ctx, "example2", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store2"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example3, err := log.NewStore(ctx, "example3", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store3"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewEtl(ctx, "example", &log.EtlArgs{
 * 			EtlName:         pulumi.String("terraform-example"),
 * 			Project:         example.Name,
 * 			DisplayName:     pulumi.String("terraform-example"),
 * 			Description:     pulumi.String("terraform-example"),
 * 			AccessKeyId:     pulumi.String("access_key_id"),
 * 			AccessKeySecret: pulumi.String("access_key_secret"),
 * 			Script:          pulumi.String("e_set('new','key')"),
 * 			Logstore:        exampleStore.Name,
 * 			EtlSinks: log.EtlEtlSinkArray{
 * 				&log.EtlEtlSinkArgs{
 * 					Name:            pulumi.String("target_name"),
 * 					AccessKeyId:     pulumi.String("example2_access_key_id"),
 * 					AccessKeySecret: pulumi.String("example2_access_key_secret"),
 * 					Endpoint:        pulumi.String("cn-hangzhou.log.aliyuncs.com"),
 * 					Project:         example.Name,
 * 					Logstore:        example2.Name,
 * 				},
 * 				&log.EtlEtlSinkArgs{
 * 					Name:            pulumi.String("target_name2"),
 * 					AccessKeyId:     pulumi.String("example3_access_key_id"),
 * 					AccessKeySecret: pulumi.String("example3_access_key_secret"),
 * 					Endpoint:        pulumi.String("cn-hangzhou.log.aliyuncs.com"),
 * 					Project:         example.Name,
 * 					Logstore:        example3.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Etl;
 * import com.pulumi.alicloud.log.EtlArgs;
 * import com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example2 = new Store("example2", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store2")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var example3 = new Store("example3", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store3")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleEtl = new Etl("exampleEtl", EtlArgs.builder()
 *             .etlName("terraform-example")
 *             .project(example.name())
 *             .displayName("terraform-example")
 *             .description("terraform-example")
 *             .accessKeyId("access_key_id")
 *             .accessKeySecret("access_key_secret")
 *             .script("e_set('new','key')")
 *             .logstore(exampleStore.name())
 *             .etlSinks(
 *                 EtlEtlSinkArgs.builder()
 *                     .name("target_name")
 *                     .accessKeyId("example2_access_key_id")
 *                     .accessKeySecret("example2_access_key_secret")
 *                     .endpoint("cn-hangzhou.log.aliyuncs.com")
 *                     .project(example.name())
 *                     .logstore(example2.name())
 *                     .build(),
 *                 EtlEtlSinkArgs.builder()
 *                     .name("target_name2")
 *                     .accessKeyId("example3_access_key_id")
 *                     .accessKeySecret("example3_access_key_secret")
 *                     .endpoint("cn-hangzhou.log.aliyuncs.com")
 *                     .project(example.name())
 *                     .logstore(example3.name())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example2:
 *     type: alicloud:log:Store
 *     properties:
 *       project: ${example.name}
 *       name: example-store2
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   example3:
 *     type: alicloud:log:Store
 *     properties:
 *       project: ${example.name}
 *       name: example-store3
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleEtl:
 *     type: alicloud:log:Etl
 *     name: example
 *     properties:
 *       etlName: terraform-example
 *       project: ${example.name}
 *       displayName: terraform-example
 *       description: terraform-example
 *       accessKeyId: access_key_id
 *       accessKeySecret: access_key_secret
 *       script: e_set('new','key')
 *       logstore: ${exampleStore.name}
 *       etlSinks:
 *         - name: target_name
 *           accessKeyId: example2_access_key_id
 *           accessKeySecret: example2_access_key_secret
 *           endpoint: cn-hangzhou.log.aliyuncs.com
 *           project: ${example.name}
 *           logstore: ${example2.name}
 *         - name: target_name2
 *           accessKeyId: example3_access_key_id
 *           accessKeySecret: example3_access_key_secret
 *           endpoint: cn-hangzhou.log.aliyuncs.com
 *           project: ${example.name}
 *           logstore: ${example3.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log etl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/etl:Etl example tf-log-project:tf-log-etl-name
 * ```
 * @property accessKeyId Source logstore access key id.
 * @property accessKeySecret Source logstore access key secret.
 * @property createTime The etl job create time.
 * @property description Description of the log etl job.
 * @property displayName Log service etl job alias.
 * @property etlName The name of the log etl job.
 * @property etlSinks Target logstore configuration for delivery after data processing.
 * @property etlType Log service etl type, the default value is `ETL`.
 * @property fromTime The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
 * @property kmsEncryptedAccessKeyId An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
 * @property kmsEncryptedAccessKeySecret An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
 * @property kmsEncryptionAccessKeyIdContext An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
 * @property kmsEncryptionAccessKeySecretContext An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
 * @property lastModifiedTime ETL job last modified time.
 * @property logstore The source logstore of the processing job.
 * @property parameters Advanced parameter configuration of processing operations.
 * @property project The name of the project where the etl job is located.
 * @property roleArn Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
 * @property schedule Job scheduling type, the default value is Resident.
 * @property script Processing operation grammar.
 * @property status Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
 * @property toTime Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
 * @property version Log etl job version. the default value is `2`.
 */
public data class EtlArgs(
    public val accessKeyId: Output<String>? = null,
    public val accessKeySecret: Output<String>? = null,
    public val createTime: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val etlName: Output<String>? = null,
    public val etlSinks: Output<List<EtlEtlSinkArgs>>? = null,
    public val etlType: Output<String>? = null,
    public val fromTime: Output<Int>? = null,
    public val kmsEncryptedAccessKeyId: Output<String>? = null,
    public val kmsEncryptedAccessKeySecret: Output<String>? = null,
    public val kmsEncryptionAccessKeyIdContext: Output<Map<String, String>>? = null,
    public val kmsEncryptionAccessKeySecretContext: Output<Map<String, String>>? = null,
    public val lastModifiedTime: Output<Int>? = null,
    public val logstore: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val project: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val script: Output<String>? = null,
    public val status: Output<String>? = null,
    public val toTime: Output<Int>? = null,
    public val version: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.EtlArgs> {
    override fun toJava(): com.pulumi.alicloud.log.EtlArgs = com.pulumi.alicloud.log.EtlArgs.builder()
        .accessKeyId(accessKeyId?.applyValue({ args0 -> args0 }))
        .accessKeySecret(accessKeySecret?.applyValue({ args0 -> args0 }))
        .createTime(createTime?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .displayName(displayName?.applyValue({ args0 -> args0 }))
        .etlName(etlName?.applyValue({ args0 -> args0 }))
        .etlSinks(
            etlSinks?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .etlType(etlType?.applyValue({ args0 -> args0 }))
        .fromTime(fromTime?.applyValue({ args0 -> args0 }))
        .kmsEncryptedAccessKeyId(kmsEncryptedAccessKeyId?.applyValue({ args0 -> args0 }))
        .kmsEncryptedAccessKeySecret(kmsEncryptedAccessKeySecret?.applyValue({ args0 -> args0 }))
        .kmsEncryptionAccessKeyIdContext(
            kmsEncryptionAccessKeyIdContext?.applyValue({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }),
        )
        .kmsEncryptionAccessKeySecretContext(
            kmsEncryptionAccessKeySecretContext?.applyValue({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }),
        )
        .lastModifiedTime(lastModifiedTime?.applyValue({ args0 -> args0 }))
        .logstore(logstore?.applyValue({ args0 -> args0 }))
        .parameters(
            parameters?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .project(project?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .schedule(schedule?.applyValue({ args0 -> args0 }))
        .script(script?.applyValue({ args0 -> args0 }))
        .status(status?.applyValue({ args0 -> args0 }))
        .toTime(toTime?.applyValue({ args0 -> args0 }))
        .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EtlArgs].
 */
@PulumiTagMarker
public class EtlArgsBuilder internal constructor() {
    private var accessKeyId: Output<String>? = null

    private var accessKeySecret: Output<String>? = null

    private var createTime: Output<Int>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var etlName: Output<String>? = null

    private var etlSinks: Output<List<EtlEtlSinkArgs>>? = null

    private var etlType: Output<String>? = null

    private var fromTime: Output<Int>? = null

    private var kmsEncryptedAccessKeyId: Output<String>? = null

    private var kmsEncryptedAccessKeySecret: Output<String>? = null

    private var kmsEncryptionAccessKeyIdContext: Output<Map<String, String>>? = null

    private var kmsEncryptionAccessKeySecretContext: Output<Map<String, String>>? = null

    private var lastModifiedTime: Output<Int>? = null

    private var logstore: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var project: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var schedule: Output<String>? = null

    private var script: Output<String>? = null

    private var status: Output<String>? = null

    private var toTime: Output<Int>? = null

    private var version: Output<Int>? = null

    /**
     * @param value Source logstore access key id.
     */
    @JvmName("cnajqmsvffbwtsxe")
    public suspend fun accessKeyId(`value`: Output<String>) {
        this.accessKeyId = value
    }

    /**
     * @param value Source logstore access key secret.
     */
    @JvmName("vhangsydovcmkxna")
    public suspend fun accessKeySecret(`value`: Output<String>) {
        this.accessKeySecret = value
    }

    /**
     * @param value The etl job create time.
     */
    @JvmName("dbcbvprlearmqjrv")
    public suspend fun createTime(`value`: Output<Int>) {
        this.createTime = value
    }

    /**
     * @param value Description of the log etl job.
     */
    @JvmName("xegffujvjbbbwowg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Log service etl job alias.
     */
    @JvmName("bqqhouumgalaxpks")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the log etl job.
     */
    @JvmName("idejasonfulyyyfa")
    public suspend fun etlName(`value`: Output<String>) {
        this.etlName = value
    }

    /**
     * @param value Target logstore configuration for delivery after data processing.
     */
    @JvmName("ahwgsphyfpwwfbso")
    public suspend fun etlSinks(`value`: Output<List<EtlEtlSinkArgs>>) {
        this.etlSinks = value
    }

    @JvmName("vvnvkkbtplmaojrx")
    public suspend fun etlSinks(vararg values: Output<EtlEtlSinkArgs>) {
        this.etlSinks = Output.all(values.asList())
    }

    /**
     * @param values Target logstore configuration for delivery after data processing.
     */
    @JvmName("mcxpqqnueyrbyxff")
    public suspend fun etlSinks(values: List<Output<EtlEtlSinkArgs>>) {
        this.etlSinks = Output.all(values)
    }

    /**
     * @param value Log service etl type, the default value is `ETL`.
     */
    @JvmName("oosgjrogovsgmyde")
    public suspend fun etlType(`value`: Output<String>) {
        this.etlType = value
    }

    /**
     * @param value The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
     */
    @JvmName("axvlmjetyppnjwda")
    public suspend fun fromTime(`value`: Output<Int>) {
        this.fromTime = value
    }

    /**
     * @param value An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
     */
    @JvmName("bqcqsnuwerafypwm")
    public suspend fun kmsEncryptedAccessKeyId(`value`: Output<String>) {
        this.kmsEncryptedAccessKeyId = value
    }

    /**
     * @param value An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
     */
    @JvmName("ctfubfiwnarnnxwm")
    public suspend fun kmsEncryptedAccessKeySecret(`value`: Output<String>) {
        this.kmsEncryptedAccessKeySecret = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("grcprshpoebeioni")
    public suspend fun kmsEncryptionAccessKeyIdContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionAccessKeyIdContext = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("gdrjlqvlusrknidt")
    public suspend fun kmsEncryptionAccessKeySecretContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionAccessKeySecretContext = value
    }

    /**
     * @param value ETL job last modified time.
     */
    @JvmName("vxbajoekmwlhgsac")
    public suspend fun lastModifiedTime(`value`: Output<Int>) {
        this.lastModifiedTime = value
    }

    /**
     * @param value The source logstore of the processing job.
     */
    @JvmName("qftxlaypokuiuskt")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value Advanced parameter configuration of processing operations.
     */
    @JvmName("obdywrmsponkqiww")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the project where the etl job is located.
     */
    @JvmName("adjihjygfqxkgotn")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
     */
    @JvmName("ksbyioguxghgjsqb")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Job scheduling type, the default value is Resident.
     */
    @JvmName("nhcimvvupfyfmlnd")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Processing operation grammar.
     */
    @JvmName("ltilqovnotcntvpq")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
     */
    @JvmName("kiphnimtakqcivnp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
     */
    @JvmName("mrdthmybnppdgbnf")
    public suspend fun toTime(`value`: Output<Int>) {
        this.toTime = value
    }

    /**
     * @param value Log etl job version. the default value is `2`.
     */
    @JvmName("nsphfiivwgjiiqpu")
    public suspend fun version(`value`: Output<Int>) {
        this.version = value
    }

    /**
     * @param value Source logstore access key id.
     */
    @JvmName("huthrdnqfspesmas")
    public suspend fun accessKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value Source logstore access key secret.
     */
    @JvmName("ngigkjwntncnecxl")
    public suspend fun accessKeySecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeySecret = mapped
    }

    /**
     * @param value The etl job create time.
     */
    @JvmName("eulfjlkluhhpchfi")
    public suspend fun createTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTime = mapped
    }

    /**
     * @param value Description of the log etl job.
     */
    @JvmName("skfmxkfxkwcksygq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Log service etl job alias.
     */
    @JvmName("qesyabtmgehfyvlc")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the log etl job.
     */
    @JvmName("bvorjigsfhjbkedt")
    public suspend fun etlName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etlName = mapped
    }

    /**
     * @param value Target logstore configuration for delivery after data processing.
     */
    @JvmName("ordvioeavodvwiov")
    public suspend fun etlSinks(`value`: List<EtlEtlSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etlSinks = mapped
    }

    /**
     * @param argument Target logstore configuration for delivery after data processing.
     */
    @JvmName("uioajpcrkqfijhkp")
    public suspend fun etlSinks(argument: List<suspend EtlEtlSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EtlEtlSinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.etlSinks = mapped
    }

    /**
     * @param argument Target logstore configuration for delivery after data processing.
     */
    @JvmName("nxseqockdhojstho")
    public suspend fun etlSinks(vararg argument: suspend EtlEtlSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EtlEtlSinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.etlSinks = mapped
    }

    /**
     * @param argument Target logstore configuration for delivery after data processing.
     */
    @JvmName("kurywduyuehlccnv")
    public suspend fun etlSinks(argument: suspend EtlEtlSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EtlEtlSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.etlSinks = mapped
    }

    /**
     * @param values Target logstore configuration for delivery after data processing.
     */
    @JvmName("grgsoqhffwbgebdm")
    public suspend fun etlSinks(vararg values: EtlEtlSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.etlSinks = mapped
    }

    /**
     * @param value Log service etl type, the default value is `ETL`.
     */
    @JvmName("ggnuqitsrjplhyda")
    public suspend fun etlType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etlType = mapped
    }

    /**
     * @param value The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
     */
    @JvmName("gmoxpvdvgxfqpynx")
    public suspend fun fromTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromTime = mapped
    }

    /**
     * @param value An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
     */
    @JvmName("ugtyyicvodwwlwrb")
    public suspend fun kmsEncryptedAccessKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedAccessKeyId = mapped
    }

    /**
     * @param value An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
     */
    @JvmName("envoisjkcjkjkila")
    public suspend fun kmsEncryptedAccessKeySecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedAccessKeySecret = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("qupfswdliqwqhaws")
    public suspend fun kmsEncryptionAccessKeyIdContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionAccessKeyIdContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("cbhgvuewwgkgxret")
    public fun kmsEncryptionAccessKeyIdContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionAccessKeyIdContext = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("nghqettsukcoiejo")
    public suspend fun kmsEncryptionAccessKeySecretContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionAccessKeySecretContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
     */
    @JvmName("ufwsyooulwbnajpu")
    public fun kmsEncryptionAccessKeySecretContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionAccessKeySecretContext = mapped
    }

    /**
     * @param value ETL job last modified time.
     */
    @JvmName("qdwymofscxshtpyv")
    public suspend fun lastModifiedTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedTime = mapped
    }

    /**
     * @param value The source logstore of the processing job.
     */
    @JvmName("kkhvlxuliykkdvhv")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value Advanced parameter configuration of processing operations.
     */
    @JvmName("mftkreceoddguuqq")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Advanced parameter configuration of processing operations.
     */
    @JvmName("arvnlfjoujqyxmtq")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the project where the etl job is located.
     */
    @JvmName("xdafrjoxocbtmelp")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
     */
    @JvmName("ustimqbdjoamvpjs")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Job scheduling type, the default value is Resident.
     */
    @JvmName("wodituilmmxladwf")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Processing operation grammar.
     */
    @JvmName("mahmcorwydexvxag")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
     */
    @JvmName("ppbidxyxejtdjame")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
     */
    @JvmName("ccnxbhxnfqesqonu")
    public suspend fun toTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toTime = mapped
    }

    /**
     * @param value Log etl job version. the default value is `2`.
     */
    @JvmName("sjgivbpefjswtqmr")
    public suspend fun version(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): EtlArgs = EtlArgs(
        accessKeyId = accessKeyId,
        accessKeySecret = accessKeySecret,
        createTime = createTime,
        description = description,
        displayName = displayName,
        etlName = etlName,
        etlSinks = etlSinks,
        etlType = etlType,
        fromTime = fromTime,
        kmsEncryptedAccessKeyId = kmsEncryptedAccessKeyId,
        kmsEncryptedAccessKeySecret = kmsEncryptedAccessKeySecret,
        kmsEncryptionAccessKeyIdContext = kmsEncryptionAccessKeyIdContext,
        kmsEncryptionAccessKeySecretContext = kmsEncryptionAccessKeySecretContext,
        lastModifiedTime = lastModifiedTime,
        logstore = logstore,
        parameters = parameters,
        project = project,
        roleArn = roleArn,
        schedule = schedule,
        script = script,
        status = status,
        toTime = toTime,
        version = version,
    )
}
