@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Ingestion].
 */
@PulumiTagMarker
public class IngestionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IngestionArgs = IngestionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IngestionArgsBuilder.() -> Unit) {
        val builder = IngestionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ingestion {
        val builtJavaResource = com.pulumi.alicloud.log.Ingestion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ingestion(builtJavaResource)
    }
}

/**
 * Log service ingestion, this service provides the function of importing logs of various data sources(OSS, MaxCompute) into logstore.
 * [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
 * > **NOTE:** Available in 1.161.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleIngestion = new alicloud.log.Ingestion("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     ingestionName: "terraform-example",
 *     displayName: "terraform-example",
 *     description: "terraform-example",
 *     interval: "30m",
 *     runImmediately: true,
 *     timeZone: "+0800",
 *     source: `        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_ingestion = alicloud.log.Ingestion("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     ingestion_name="terraform-example",
 *     display_name="terraform-example",
 *     description="terraform-example",
 *     interval="30m",
 *     run_immediately=True,
 *     time_zone="+0800",
 *     source="""        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleIngestion = new AliCloud.Log.Ingestion("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         IngestionName = "terraform-example",
 *         DisplayName = "terraform-example",
 *         Description = "terraform-example",
 *         Interval = "30m",
 *         RunImmediately = true,
 *         TimeZone = "+0800",
 *         Source = @"        {
 *           ""bucket"": ""bucket_name"",
 *           ""compressionCodec"": ""none"",
 *           ""encoding"": ""UTF-8"",
 *           ""endpoint"": ""oss-cn-hangzhou-internal.aliyuncs.com"",
 *           ""format"": {
 *             ""escapeChar"": ""\\"",
 *             ""fieldDelimiter"": "","",
 *             ""fieldNames"": [],
 *             ""firstRowAsHeader"": true,
 *             ""maxLines"": 1,
 *             ""quoteChar"": ""\"""",
 *             ""skipLeadingRows"": 0,
 *             ""timeField"": """",
 *             ""type"": ""DelimitedText""
 *           },
 *           ""pattern"": """",
 *           ""prefix"": ""test-prefix/"",
 *           ""restoreObjectEnabled"": false,
 *           ""roleARN"": ""acs:ram::1049446484210612:role/aliyunlogimportossrole"",
 *           ""type"": ""AliyunOSS""
 *         }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewIngestion(ctx, "example", &log.IngestionArgs{
 * 			Project:        example.Name,
 * 			Logstore:       exampleStore.Name,
 * 			IngestionName:  pulumi.String("terraform-example"),
 * 			DisplayName:    pulumi.String("terraform-example"),
 * 			Description:    pulumi.String("terraform-example"),
 * 			Interval:       pulumi.String("30m"),
 * 			RunImmediately: pulumi.Bool(true),
 * 			TimeZone:       pulumi.String("+0800"),
 * 			Source: pulumi.String(`        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Ingestion;
 * import com.pulumi.alicloud.log.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleIngestion = new Ingestion("exampleIngestion", IngestionArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .ingestionName("terraform-example")
 *             .displayName("terraform-example")
 *             .description("terraform-example")
 *             .interval("30m")
 *             .runImmediately(true)
 *             .timeZone("+0800")
 *             .source("""
 *         {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleIngestion:
 *     type: alicloud:log:Ingestion
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       ingestionName: terraform-example
 *       displayName: terraform-example
 *       description: terraform-example
 *       interval: 30m
 *       runImmediately: true
 *       timeZone: '+0800'
 *       source: |2
 *                 {
 *                   "bucket": "bucket_name",
 *                   "compressionCodec": "none",
 *                   "encoding": "UTF-8",
 *                   "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *                   "format": {
 *                     "escapeChar": "\\",
 *                     "fieldDelimiter": ",",
 *                     "fieldNames": [],
 *                     "firstRowAsHeader": true,
 *                     "maxLines": 1,
 *                     "quoteChar": "\"",
 *                     "skipLeadingRows": 0,
 *                     "timeField": "",
 *                     "type": "DelimitedText"
 *                   },
 *                   "pattern": "",
 *                   "prefix": "test-prefix/",
 *                   "restoreObjectEnabled": false,
 *                   "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *                   "type": "AliyunOSS"
 *                 }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log ingestion can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:log/ingestion:Ingestion example tf-log-project:tf-log-logstore:ingestion_name
 * ```
 */
public class Ingestion internal constructor(
    override val javaResource: com.pulumi.alicloud.log.Ingestion,
) : KotlinCustomResource(javaResource, IngestionMapper) {
    /**
     * Ingestion job description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name displayed on the web page.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    public val ingestionName: Output<String>
        get() = javaResource.ingestionName().applyValue({ args0 -> args0 })

    /**
     * Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
     */
    public val interval: Output<String>
        get() = javaResource.interval().applyValue({ args0 -> args0 })

    /**
     * The name of the target logstore.
     */
    public val logstore: Output<String>
        get() = javaResource.logstore().applyValue({ args0 -> args0 })

    /**
     * The name of the log project. It is the only in one Alicloud account.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
     */
    public val runImmediately: Output<Boolean>
        get() = javaResource.runImmediately().applyValue({ args0 -> args0 })

    /**
     * Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * Which time zone is the log time imported in, e.g. `+0800`.
     */
    public val timeZone: Output<String>?
        get() = javaResource.timeZone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IngestionMapper : ResourceMapper<Ingestion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.Ingestion::class == javaResource::class

    override fun map(javaResource: Resource): Ingestion = Ingestion(
        javaResource as
            com.pulumi.alicloud.log.Ingestion,
    )
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ingestion].
 */
public suspend fun ingestion(name: String, block: suspend IngestionResourceBuilder.() -> Unit): Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ingestion(name: String): Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    return builder.build()
}
