@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.IngestionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log service ingestion, this service provides the function of importing logs of various data sources(OSS, MaxCompute) into logstore.
 * [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
 * > **NOTE:** Available in 1.161.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleIngestion = new alicloud.log.Ingestion("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     ingestionName: "terraform-example",
 *     displayName: "terraform-example",
 *     description: "terraform-example",
 *     interval: "30m",
 *     runImmediately: true,
 *     timeZone: "+0800",
 *     source: `        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_ingestion = alicloud.log.Ingestion("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     ingestion_name="terraform-example",
 *     display_name="terraform-example",
 *     description="terraform-example",
 *     interval="30m",
 *     run_immediately=True,
 *     time_zone="+0800",
 *     source="""        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleIngestion = new AliCloud.Log.Ingestion("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         IngestionName = "terraform-example",
 *         DisplayName = "terraform-example",
 *         Description = "terraform-example",
 *         Interval = "30m",
 *         RunImmediately = true,
 *         TimeZone = "+0800",
 *         Source = @"        {
 *           ""bucket"": ""bucket_name"",
 *           ""compressionCodec"": ""none"",
 *           ""encoding"": ""UTF-8"",
 *           ""endpoint"": ""oss-cn-hangzhou-internal.aliyuncs.com"",
 *           ""format"": {
 *             ""escapeChar"": ""\\"",
 *             ""fieldDelimiter"": "","",
 *             ""fieldNames"": [],
 *             ""firstRowAsHeader"": true,
 *             ""maxLines"": 1,
 *             ""quoteChar"": ""\"""",
 *             ""skipLeadingRows"": 0,
 *             ""timeField"": """",
 *             ""type"": ""DelimitedText""
 *           },
 *           ""pattern"": """",
 *           ""prefix"": ""test-prefix/"",
 *           ""restoreObjectEnabled"": false,
 *           ""roleARN"": ""acs:ram::1049446484210612:role/aliyunlogimportossrole"",
 *           ""type"": ""AliyunOSS""
 *         }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewIngestion(ctx, "example", &log.IngestionArgs{
 * 			Project:        example.Name,
 * 			Logstore:       exampleStore.Name,
 * 			IngestionName:  pulumi.String("terraform-example"),
 * 			DisplayName:    pulumi.String("terraform-example"),
 * 			Description:    pulumi.String("terraform-example"),
 * 			Interval:       pulumi.String("30m"),
 * 			RunImmediately: pulumi.Bool(true),
 * 			TimeZone:       pulumi.String("+0800"),
 * 			Source: pulumi.String(`        {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.Ingestion;
 * import com.pulumi.alicloud.log.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleIngestion = new Ingestion("exampleIngestion", IngestionArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .ingestionName("terraform-example")
 *             .displayName("terraform-example")
 *             .description("terraform-example")
 *             .interval("30m")
 *             .runImmediately(true)
 *             .timeZone("+0800")
 *             .source("""
 *         {
 *           "bucket": "bucket_name",
 *           "compressionCodec": "none",
 *           "encoding": "UTF-8",
 *           "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *           "format": {
 *             "escapeChar": "\\",
 *             "fieldDelimiter": ",",
 *             "fieldNames": [],
 *             "firstRowAsHeader": true,
 *             "maxLines": 1,
 *             "quoteChar": "\"",
 *             "skipLeadingRows": 0,
 *             "timeField": "",
 *             "type": "DelimitedText"
 *           },
 *           "pattern": "",
 *           "prefix": "test-prefix/",
 *           "restoreObjectEnabled": false,
 *           "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *           "type": "AliyunOSS"
 *         }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleIngestion:
 *     type: alicloud:log:Ingestion
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       ingestionName: terraform-example
 *       displayName: terraform-example
 *       description: terraform-example
 *       interval: 30m
 *       runImmediately: true
 *       timeZone: '+0800'
 *       source: |2
 *                 {
 *                   "bucket": "bucket_name",
 *                   "compressionCodec": "none",
 *                   "encoding": "UTF-8",
 *                   "endpoint": "oss-cn-hangzhou-internal.aliyuncs.com",
 *                   "format": {
 *                     "escapeChar": "\\",
 *                     "fieldDelimiter": ",",
 *                     "fieldNames": [],
 *                     "firstRowAsHeader": true,
 *                     "maxLines": 1,
 *                     "quoteChar": "\"",
 *                     "skipLeadingRows": 0,
 *                     "timeField": "",
 *                     "type": "DelimitedText"
 *                   },
 *                   "pattern": "",
 *                   "prefix": "test-prefix/",
 *                   "restoreObjectEnabled": false,
 *                   "roleARN": "acs:ram::1049446484210612:role/aliyunlogimportossrole",
 *                   "type": "AliyunOSS"
 *                 }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log ingestion can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:log/ingestion:Ingestion example tf-log-project:tf-log-logstore:ingestion_name
 * ```
 * @property description Ingestion job description.
 * @property displayName The name displayed on the web page.
 * @property ingestionName Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
 * @property interval Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
 * @property logstore The name of the target logstore.
 * @property project The name of the log project. It is the only in one Alicloud account.
 * @property runImmediately Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
 * @property source Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
 * @property timeZone Which time zone is the log time imported in, e.g. `+0800`.
 */
public data class IngestionArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val ingestionName: Output<String>? = null,
    public val interval: Output<String>? = null,
    public val logstore: Output<String>? = null,
    public val project: Output<String>? = null,
    public val runImmediately: Output<Boolean>? = null,
    public val source: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.IngestionArgs> {
    override fun toJava(): com.pulumi.alicloud.log.IngestionArgs =
        com.pulumi.alicloud.log.IngestionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .ingestionName(ingestionName?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .runImmediately(runImmediately?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionArgs].
 */
@PulumiTagMarker
public class IngestionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var ingestionName: Output<String>? = null

    private var interval: Output<String>? = null

    private var logstore: Output<String>? = null

    private var project: Output<String>? = null

    private var runImmediately: Output<Boolean>? = null

    private var source: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Ingestion job description.
     */
    @JvmName("kblsmprepqehubhk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name displayed on the web page.
     */
    @JvmName("lthojdsmxrmbdveu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("tfpytghnvcldygnc")
    public suspend fun ingestionName(`value`: Output<String>) {
        this.ingestionName = value
    }

    /**
     * @param value Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
     */
    @JvmName("tkrhwfvmkscmtkok")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value The name of the target logstore.
     */
    @JvmName("oskcydvptenlbrwd")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("knxfqqvponfpqttx")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
     */
    @JvmName("pwpamhrtkrtkngii")
    public suspend fun runImmediately(`value`: Output<Boolean>) {
        this.runImmediately = value
    }

    /**
     * @param value Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
     */
    @JvmName("eidrcttyssbxtaca")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Which time zone is the log time imported in, e.g. `+0800`.
     */
    @JvmName("tohkptjuxiswxuos")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Ingestion job description.
     */
    @JvmName("lnnuefusjirlytuk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name displayed on the web page.
     */
    @JvmName("lpedhsnbxwaoiaat")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Ingestion job name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("pxcskfxguwqvdmlg")
    public suspend fun ingestionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionName = mapped
    }

    /**
     * @param value Task execution interval, support minute `m`, hour `h`, day `d`, for example 30 minutes `30m`.
     */
    @JvmName("rhdbobqvwthcvbsm")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The name of the target logstore.
     */
    @JvmName("nbfxiyxcshiaaexm")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("bnpsfcjfhrlwrjfe")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Whether to run the ingestion job immediately, if false, wait for an interval before starting the ingestion.
     */
    @JvmName("xmfqtpaurduqhxsx")
    public suspend fun runImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runImmediately = mapped
    }

    /**
     * @param value Data source and data format details. [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/147819.html).
     */
    @JvmName("nnxqrugglhxcuosl")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Which time zone is the log time imported in, e.g. `+0800`.
     */
    @JvmName("onnfdbfikxwsnegn")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): IngestionArgs = IngestionArgs(
        description = description,
        displayName = displayName,
        ingestionName = ingestionName,
        interval = interval,
        logstore = logstore,
        project = project,
        runImmediately = runImmediately,
        source = source,
        timeZone = timeZone,
    )
}
