@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.LogFunctions.getAlertResourcePlain
import com.pulumi.alicloud.log.LogFunctions.getProjectsPlain
import com.pulumi.alicloud.log.LogFunctions.getServicePlain
import com.pulumi.alicloud.log.LogFunctions.getStoresPlain
import com.pulumi.alicloud.log.kotlin.inputs.GetAlertResourcePlainArgs
import com.pulumi.alicloud.log.kotlin.inputs.GetAlertResourcePlainArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.GetProjectsPlainArgs
import com.pulumi.alicloud.log.kotlin.inputs.GetProjectsPlainArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.log.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.GetStoresPlainArgs
import com.pulumi.alicloud.log.kotlin.inputs.GetStoresPlainArgsBuilder
import com.pulumi.alicloud.log.kotlin.outputs.GetAlertResourceResult
import com.pulumi.alicloud.log.kotlin.outputs.GetProjectsResult
import com.pulumi.alicloud.log.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.log.kotlin.outputs.GetStoresResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.log.kotlin.outputs.GetAlertResourceResult.Companion.toKotlin as getAlertResourceResultToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.GetProjectsResult.Companion.toKotlin as getProjectsResultToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.log.kotlin.outputs.GetStoresResult.Companion.toKotlin as getStoresResultToKotlin

public object LogFunctions {
    /**
     * Using this data source can init SLS Alert resources automatically.
     * For information about SLS Alert and how to use it, see [SLS Alert Overview](https://www.alibabacloud.com/help/en/doc-detail/209202.html)
     * > **DEPRECATED:**  This resource  has been deprecated from version `1.219.0`. Please use new resource alicloud_log_alert_resource.
     * > **NOTE:** Available since v1.161.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const exampleUser = alicloud.log.getAlertResource({
     *     type: "user",
     *     lang: "cn",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example_user = alicloud.log.get_alert_resource(type="user",
     *     lang="cn")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var exampleUser = AliCloud.Log.GetAlertResource.Invoke(new()
     *     {
     *         Type = "user",
     *         Lang = "cn",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := log.LookupAlertResource(ctx, &log.LookupAlertResourceArgs{
     * 			Type: "user",
     * 			Lang: pulumi.StringRef("cn"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.log.LogFunctions;
     * import com.pulumi.alicloud.log.inputs.GetAlertResourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleUser = LogFunctions.getAlertResource(GetAlertResourceArgs.builder()
     *             .type("user")
     *             .lang("cn")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   exampleUser:
     *     fn::invoke:
     *       Function: alicloud:log:getAlertResource
     *       Arguments:
     *         type: user
     *         lang: cn
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlertResource.
     * @return A collection of values returned by getAlertResource.
     */
    public suspend fun getAlertResource(argument: GetAlertResourcePlainArgs): GetAlertResourceResult =
        getAlertResourceResultToKotlin(getAlertResourcePlain(argument.toJava()).await())

    /**
     * @see [getAlertResource].
     * @param lang The lang of alert center resource when type is user.
     * @param project The project of alert resource when type is project.
     * @param type The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
     * @return A collection of values returned by getAlertResource.
     */
    public suspend fun getAlertResource(
        lang: String? = null,
        project: String? = null,
        type: String,
    ): GetAlertResourceResult {
        val argument = GetAlertResourcePlainArgs(
            lang = lang,
            project = project,
            type = type,
        )
        return getAlertResourceResultToKotlin(getAlertResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertResource].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;log&#46;kotlin&#46;inputs&#46;GetAlertResourcePlainArgs].
     * @return A collection of values returned by getAlertResource.
     */
    public suspend fun getAlertResource(argument: suspend GetAlertResourcePlainArgsBuilder.() -> Unit): GetAlertResourceResult {
        val builder = GetAlertResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertResourceResultToKotlin(getAlertResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Log Projects of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.126.0+.
     * @param argument A collection of arguments for invoking getProjects.
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: GetProjectsPlainArgs): GetProjectsResult =
        getProjectsResultToKotlin(getProjectsPlain(argument.toJava()).await())

    /**
     * @see [getProjects].
     * @param ids A list of project IDs.
     * @param nameRegex A regex string to filter results by project name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of log project. Valid values `Normal` and `Disable`.
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetProjectsResult {
        val argument = GetProjectsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getProjectsResultToKotlin(getProjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjects].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;log&#46;kotlin&#46;inputs&#46;GetProjectsPlainArgs].
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: suspend GetProjectsPlainArgsBuilder.() -> Unit): GetProjectsResult {
        val builder = GetProjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectsResultToKotlin(getProjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable Log service automatically. If the service has been enabled, it will return `Opened`.
     * For information about Log service and how to use it, see [What is Log Service](https://www.alibabacloud.com/help/product/28958.htm).
     * > **NOTE:** Available since v1.96.0
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.log.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.log.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Log.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := log.GetService(ctx, &log.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.log.LogFunctions;
     * import com.pulumi.alicloud.log.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = LogFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:log:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Log service that means you have read and agreed the [Log Terms of Service](https://help.aliyun.com/document_detail/53476.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;log&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Log Stores of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.126.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.log.getStores({
     *     project: "the_project_name",
     *     ids: ["the_store_name"],
     * });
     * export const firstLogStoreId = example.then(example => example.stores?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.log.get_stores(project="the_project_name",
     *     ids=["the_store_name"])
     * pulumi.export("firstLogStoreId", example.stores[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Log.GetStores.Invoke(new()
     *     {
     *         Project = "the_project_name",
     *         Ids = new[]
     *         {
     *             "the_store_name",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstLogStoreId"] = example&#46;Apply(getStoresResult => getStoresResult&#46;Stores[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := log.GetStores(ctx, &log.GetStoresArgs{
     * 			Project: "the_project_name",
     * 			Ids: []string{
     * 				"the_store_name",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstLogStoreId", example.Stores[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.log.LogFunctions;
     * import com.pulumi.alicloud.log.inputs.GetStoresArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LogFunctions.getStores(GetStoresArgs.builder()
     *             .project("the_project_name")
     *             .ids("the_store_name")
     *             .build());
     *         ctx.export("firstLogStoreId", example.applyValue(getStoresResult -> getStoresResult.stores()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:log:getStores
     *       Arguments:
     *         project: the_project_name
     *         ids:
     *           - the_store_name
     * outputs:
     *   firstLogStoreId: ${example.stores[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStores.
     * @return A collection of values returned by getStores.
     */
    public suspend fun getStores(argument: GetStoresPlainArgs): GetStoresResult =
        getStoresResultToKotlin(getStoresPlain(argument.toJava()).await())

    /**
     * @see [getStores].
     * @param ids A list of store IDs.
     * @param nameRegex A regex string to filter results by store name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param project
     * @return A collection of values returned by getStores.
     */
    public suspend fun getStores(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        project: String,
    ): GetStoresResult {
        val argument = GetStoresPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            project = project,
        )
        return getStoresResultToKotlin(getStoresPlain(argument.toJava()).await())
    }

    /**
     * @see [getStores].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;log&#46;kotlin&#46;inputs&#46;GetStoresPlainArgs].
     * @return A collection of values returned by getStores.
     */
    public suspend fun getStores(argument: suspend GetStoresPlainArgsBuilder.() -> Unit): GetStoresResult {
        val builder = GetStoresPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStoresResultToKotlin(getStoresPlain(builtArgument.toJava()).await())
    }
}
