@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.LogTailAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Logtail access service is a log collection agent provided by Log Service.
 * You can use Logtail to collect logs from servers such as Alibaba Cloud Elastic
 * Compute Service (ECS) instances in real time in the Log Service console. [Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm)
 * This resource amis to attach one logtail configure to a machine group.
 * > **NOTE:** One logtail configure can be attached to multiple machine groups and one machine group can attach several logtail configures.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleLogTailConfig = new alicloud.log.LogTailConfig("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     inputType: "file",
 *     name: "terraform-example",
 *     outputType: "LogService",
 *     inputDetail: `  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * `,
 * });
 * const exampleMachineGroup = new alicloud.log.MachineGroup("example", {
 *     project: example.name,
 *     name: "terraform-example",
 *     identifyType: "ip",
 *     topic: "terraform",
 *     identifyLists: [
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ],
 * });
 * const exampleLogTailAttachment = new alicloud.log.LogTailAttachment("example", {
 *     project: example.name,
 *     logtailConfigName: exampleLogTailConfig.name,
 *     machineGroupName: exampleMachineGroup.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_log_tail_config = alicloud.log.LogTailConfig("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     input_type="file",
 *     name="terraform-example",
 *     output_type="LogService",
 *     input_detail="""  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * """)
 * example_machine_group = alicloud.log.MachineGroup("example",
 *     project=example.name,
 *     name="terraform-example",
 *     identify_type="ip",
 *     topic="terraform",
 *     identify_lists=[
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ])
 * example_log_tail_attachment = alicloud.log.LogTailAttachment("example",
 *     project=example.name,
 *     logtail_config_name=example_log_tail_config.name,
 *     machine_group_name=example_machine_group.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleLogTailConfig = new AliCloud.Log.LogTailConfig("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         InputType = "file",
 *         Name = "terraform-example",
 *         OutputType = "LogService",
 *         InputDetail = @"  	{
 * 		""logPath"": ""/logPath"",
 * 		""filePattern"": ""access.log"",
 * 		""logType"": ""json_log"",
 * 		""topicFormat"": ""default"",
 * 		""discardUnmatch"": false,
 * 		""enableRawLog"": true,
 * 		""fileEncoding"": ""gbk"",
 * 		""maxDepth"": 10
 * 	}
 * ",
 *     });
 *     var exampleMachineGroup = new AliCloud.Log.MachineGroup("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "terraform-example",
 *         IdentifyType = "ip",
 *         Topic = "terraform",
 *         IdentifyLists = new[]
 *         {
 *             "10.0.0.1",
 *             "10.0.0.2",
 *         },
 *     });
 *     var exampleLogTailAttachment = new AliCloud.Log.LogTailAttachment("example", new()
 *     {
 *         Project = example.Name,
 *         LogtailConfigName = exampleLogTailConfig.Name,
 *         MachineGroupName = exampleMachineGroup.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLogTailConfig, err := log.NewLogTailConfig(ctx, "example", &log.LogTailConfigArgs{
 * 			Project:    example.Name,
 * 			Logstore:   exampleStore.Name,
 * 			InputType:  pulumi.String("file"),
 * 			Name:       pulumi.String("terraform-example"),
 * 			OutputType: pulumi.String("LogService"),
 * 			InputDetail: pulumi.String(`  	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleMachineGroup, err := log.NewMachineGroup(ctx, "example", &log.MachineGroupArgs{
 * 			Project:      example.Name,
 * 			Name:         pulumi.String("terraform-example"),
 * 			IdentifyType: pulumi.String("ip"),
 * 			Topic:        pulumi.String("terraform"),
 * 			IdentifyLists: pulumi.StringArray{
 * 				pulumi.String("10.0.0.1"),
 * 				pulumi.String("10.0.0.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewLogTailAttachment(ctx, "example", &log.LogTailAttachmentArgs{
 * 			Project:           example.Name,
 * 			LogtailConfigName: exampleLogTailConfig.Name,
 * 			MachineGroupName:  exampleMachineGroup.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.LogTailConfig;
 * import com.pulumi.alicloud.log.LogTailConfigArgs;
 * import com.pulumi.alicloud.log.MachineGroup;
 * import com.pulumi.alicloud.log.MachineGroupArgs;
 * import com.pulumi.alicloud.log.LogTailAttachment;
 * import com.pulumi.alicloud.log.LogTailAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleLogTailConfig = new LogTailConfig("exampleLogTailConfig", LogTailConfigArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .inputType("file")
 *             .name("terraform-example")
 *             .outputType("LogService")
 *             .inputDetail("""
 *   	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 *             """)
 *             .build());
 *         var exampleMachineGroup = new MachineGroup("exampleMachineGroup", MachineGroupArgs.builder()
 *             .project(example.name())
 *             .name("terraform-example")
 *             .identifyType("ip")
 *             .topic("terraform")
 *             .identifyLists(
 *                 "10.0.0.1",
 *                 "10.0.0.2")
 *             .build());
 *         var exampleLogTailAttachment = new LogTailAttachment("exampleLogTailAttachment", LogTailAttachmentArgs.builder()
 *             .project(example.name())
 *             .logtailConfigName(exampleLogTailConfig.name())
 *             .machineGroupName(exampleMachineGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleLogTailConfig:
 *     type: alicloud:log:LogTailConfig
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       inputType: file
 *       name: terraform-example
 *       outputType: LogService
 *       inputDetail: |2
 *           	{
 *         		"logPath": "/logPath",
 *         		"filePattern": "access.log",
 *         		"logType": "json_log",
 *         		"topicFormat": "default",
 *         		"discardUnmatch": false,
 *         		"enableRawLog": true,
 *         		"fileEncoding": "gbk",
 *         		"maxDepth": 10
 *         	}
 *   exampleMachineGroup:
 *     type: alicloud:log:MachineGroup
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: terraform-example
 *       identifyType: ip
 *       topic: terraform
 *       identifyLists:
 *         - 10.0.0.1
 *         - 10.0.0.2
 *   exampleLogTailAttachment:
 *     type: alicloud:log:LogTailAttachment
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logtailConfigName: ${exampleLogTailConfig.name}
 *       machineGroupName: ${exampleMachineGroup.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Logtial to machine group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/logTailAttachment:LogTailAttachment example tf-log:tf-log-config:tf-log-machine-group
 * ```
 * @property logtailConfigName The Logtail configuration name, which is unique in the same project.
 * @property machineGroupName The machine group name, which is unique in the same project.
 * @property project The project name to the log store belongs.
 */
public data class LogTailAttachmentArgs(
    public val logtailConfigName: Output<String>? = null,
    public val machineGroupName: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.LogTailAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.log.LogTailAttachmentArgs =
        com.pulumi.alicloud.log.LogTailAttachmentArgs.builder()
            .logtailConfigName(logtailConfigName?.applyValue({ args0 -> args0 }))
            .machineGroupName(machineGroupName?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogTailAttachmentArgs].
 */
@PulumiTagMarker
public class LogTailAttachmentArgsBuilder internal constructor() {
    private var logtailConfigName: Output<String>? = null

    private var machineGroupName: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The Logtail configuration name, which is unique in the same project.
     */
    @JvmName("uuilwtudtsimcaxo")
    public suspend fun logtailConfigName(`value`: Output<String>) {
        this.logtailConfigName = value
    }

    /**
     * @param value The machine group name, which is unique in the same project.
     */
    @JvmName("vvqivigbeycthksl")
    public suspend fun machineGroupName(`value`: Output<String>) {
        this.machineGroupName = value
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("wcawlcngppsxidhh")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The Logtail configuration name, which is unique in the same project.
     */
    @JvmName("ydwkpdyuwscaylkw")
    public suspend fun logtailConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logtailConfigName = mapped
    }

    /**
     * @param value The machine group name, which is unique in the same project.
     */
    @JvmName("axfeaewursmfsvpy")
    public suspend fun machineGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineGroupName = mapped
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("bhabbvgnmpacnjtx")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): LogTailAttachmentArgs = LogTailAttachmentArgs(
        logtailConfigName = logtailConfigName,
        machineGroupName = machineGroupName,
        project = project,
    )
}
