@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogTailConfig].
 */
@PulumiTagMarker
public class LogTailConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogTailConfigArgs = LogTailConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogTailConfigArgsBuilder.() -> Unit) {
        val builder = LogTailConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogTailConfig {
        val builtJavaResource = com.pulumi.alicloud.log.LogTailConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogTailConfig(builtJavaResource)
    }
}

/**
 * The Logtail access service is a log collection agent provided by Log Service.
 * You can use Logtail to collect logs from servers such as Alibaba Cloud Elastic
 * Compute Service (ECS) instances in real time in the Log Service console. [Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm
 * )
 * > **NOTE:** Available since v1.93.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleLogTailConfig = new alicloud.log.LogTailConfig("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     inputType: "file",
 *     name: "terraform-example",
 *     outputType: "LogService",
 *     inputDetail: `  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_log_tail_config = alicloud.log.LogTailConfig("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     input_type="file",
 *     name="terraform-example",
 *     output_type="LogService",
 *     input_detail="""  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleLogTailConfig = new AliCloud.Log.LogTailConfig("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         InputType = "file",
 *         Name = "terraform-example",
 *         OutputType = "LogService",
 *         InputDetail = @"  	{
 * 		""logPath"": ""/logPath"",
 * 		""filePattern"": ""access.log"",
 * 		""logType"": ""json_log"",
 * 		""topicFormat"": ""default"",
 * 		""discardUnmatch"": false,
 * 		""enableRawLog"": true,
 * 		""fileEncoding"": ""gbk"",
 * 		""maxDepth"": 10
 * 	}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewLogTailConfig(ctx, "example", &log.LogTailConfigArgs{
 * 			Project:    example.Name,
 * 			Logstore:   exampleStore.Name,
 * 			InputType:  pulumi.String("file"),
 * 			Name:       pulumi.String("terraform-example"),
 * 			OutputType: pulumi.String("LogService"),
 * 			InputDetail: pulumi.String(`  	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.LogTailConfig;
 * import com.pulumi.alicloud.log.LogTailConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleLogTailConfig = new LogTailConfig("exampleLogTailConfig", LogTailConfigArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .inputType("file")
 *             .name("terraform-example")
 *             .outputType("LogService")
 *             .inputDetail("""
 *   	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleLogTailConfig:
 *     type: alicloud:log:LogTailConfig
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       inputType: file
 *       name: terraform-example
 *       outputType: LogService
 *       inputDetail: |2
 *           	{
 *         		"logPath": "/logPath",
 *         		"filePattern": "access.log",
 *         		"logType": "json_log",
 *         		"topicFormat": "default",
 *         		"discardUnmatch": false,
 *         		"enableRawLog": true,
 *         		"fileEncoding": "gbk",
 *         		"maxDepth": 10
 *         	}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls-logtail module
 * to create logtail config, machine group, install logtail on ECS instances and join instances into machine group one-click.
 * ## Import
 * Logtial config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/logTailConfig:LogTailConfig example tf-log:tf-log-store:tf-log-config
 * ```
 */
public class LogTailConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.log.LogTailConfig,
) : KotlinCustomResource(javaResource, LogTailConfigMapper) {
    /**
     * The logtail configure the required JSON files. ([Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm))
     */
    public val inputDetail: Output<String>
        get() = javaResource.inputDetail().applyValue({ args0 -> args0 })

    /**
     * The input type. Currently only two types of files and plugin are supported.
     */
    public val inputType: Output<String>
        get() = javaResource.inputType().applyValue({ args0 -> args0 })

    /**
     * This parameter is auto generated by server, please do not fill in.
     */
    public val lastModifyTime: Output<String>
        get() = javaResource.lastModifyTime().applyValue({ args0 -> args0 })

    /**
     * The log sample of the Logtail configuration. The log size cannot exceed 1,000 bytes.
     */
    public val logSample: Output<String>?
        get() = javaResource.logSample().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The log store name to the query index belongs.
     */
    public val logstore: Output<String>
        get() = javaResource.logstore().applyValue({ args0 -> args0 })

    /**
     * The Logtail configuration name, which is unique in the same project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The output type. Currently, only LogService is supported.
     */
    public val outputType: Output<String>
        get() = javaResource.outputType().applyValue({ args0 -> args0 })

    /**
     * The project name to the log store belongs.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object LogTailConfigMapper : ResourceMapper<LogTailConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.LogTailConfig::class == javaResource::class

    override fun map(javaResource: Resource): LogTailConfig = LogTailConfig(
        javaResource as
            com.pulumi.alicloud.log.LogTailConfig,
    )
}

/**
 * @see [LogTailConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogTailConfig].
 */
public suspend fun logTailConfig(
    name: String,
    block: suspend LogTailConfigResourceBuilder.() -> Unit,
): LogTailConfig {
    val builder = LogTailConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogTailConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logTailConfig(name: String): LogTailConfig {
    val builder = LogTailConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
