@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.LogTailConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Logtail access service is a log collection agent provided by Log Service.
 * You can use Logtail to collect logs from servers such as Alibaba Cloud Elastic
 * Compute Service (ECS) instances in real time in the Log Service console. [Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm
 * )
 * > **NOTE:** Available since v1.93.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleLogTailConfig = new alicloud.log.LogTailConfig("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     inputType: "file",
 *     name: "terraform-example",
 *     outputType: "LogService",
 *     inputDetail: `  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_log_tail_config = alicloud.log.LogTailConfig("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     input_type="file",
 *     name="terraform-example",
 *     output_type="LogService",
 *     input_detail="""  \x09{
 * \x09\x09"logPath": "/logPath",
 * \x09\x09"filePattern": "access.log",
 * \x09\x09"logType": "json_log",
 * \x09\x09"topicFormat": "default",
 * \x09\x09"discardUnmatch": false,
 * \x09\x09"enableRawLog": true,
 * \x09\x09"fileEncoding": "gbk",
 * \x09\x09"maxDepth": 10
 * \x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleLogTailConfig = new AliCloud.Log.LogTailConfig("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         InputType = "file",
 *         Name = "terraform-example",
 *         OutputType = "LogService",
 *         InputDetail = @"  	{
 * 		""logPath"": ""/logPath"",
 * 		""filePattern"": ""access.log"",
 * 		""logType"": ""json_log"",
 * 		""topicFormat"": ""default"",
 * 		""discardUnmatch"": false,
 * 		""enableRawLog"": true,
 * 		""fileEncoding"": ""gbk"",
 * 		""maxDepth"": 10
 * 	}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewLogTailConfig(ctx, "example", &log.LogTailConfigArgs{
 * 			Project:    example.Name,
 * 			Logstore:   exampleStore.Name,
 * 			InputType:  pulumi.String("file"),
 * 			Name:       pulumi.String("terraform-example"),
 * 			OutputType: pulumi.String("LogService"),
 * 			InputDetail: pulumi.String(`  	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.LogTailConfig;
 * import com.pulumi.alicloud.log.LogTailConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleLogTailConfig = new LogTailConfig("exampleLogTailConfig", LogTailConfigArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .inputType("file")
 *             .name("terraform-example")
 *             .outputType("LogService")
 *             .inputDetail("""
 *   	{
 * 		"logPath": "/logPath",
 * 		"filePattern": "access.log",
 * 		"logType": "json_log",
 * 		"topicFormat": "default",
 * 		"discardUnmatch": false,
 * 		"enableRawLog": true,
 * 		"fileEncoding": "gbk",
 * 		"maxDepth": 10
 * 	}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleLogTailConfig:
 *     type: alicloud:log:LogTailConfig
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       inputType: file
 *       name: terraform-example
 *       outputType: LogService
 *       inputDetail: |2
 *           	{
 *         		"logPath": "/logPath",
 *         		"filePattern": "access.log",
 *         		"logType": "json_log",
 *         		"topicFormat": "default",
 *         		"discardUnmatch": false,
 *         		"enableRawLog": true,
 *         		"fileEncoding": "gbk",
 *         		"maxDepth": 10
 *         	}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls-logtail module
 * to create logtail config, machine group, install logtail on ECS instances and join instances into machine group one-click.
 * ## Import
 * Logtial config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/logTailConfig:LogTailConfig example tf-log:tf-log-store:tf-log-config
 * ```
 * @property inputDetail The logtail configure the required JSON files. ([Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm))
 * @property inputType The input type. Currently only two types of files and plugin are supported.
 * @property logSample The log sample of the Logtail configuration. The log size cannot exceed 1,000 bytes.
 * @property logstore The log store name to the query index belongs.
 * @property name The Logtail configuration name, which is unique in the same project.
 * @property outputType The output type. Currently, only LogService is supported.
 * @property project The project name to the log store belongs.
 */
public data class LogTailConfigArgs(
    public val inputDetail: Output<String>? = null,
    public val inputType: Output<String>? = null,
    public val logSample: Output<String>? = null,
    public val logstore: Output<String>? = null,
    public val name: Output<String>? = null,
    public val outputType: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.LogTailConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.log.LogTailConfigArgs =
        com.pulumi.alicloud.log.LogTailConfigArgs.builder()
            .inputDetail(inputDetail?.applyValue({ args0 -> args0 }))
            .inputType(inputType?.applyValue({ args0 -> args0 }))
            .logSample(logSample?.applyValue({ args0 -> args0 }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outputType(outputType?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogTailConfigArgs].
 */
@PulumiTagMarker
public class LogTailConfigArgsBuilder internal constructor() {
    private var inputDetail: Output<String>? = null

    private var inputType: Output<String>? = null

    private var logSample: Output<String>? = null

    private var logstore: Output<String>? = null

    private var name: Output<String>? = null

    private var outputType: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The logtail configure the required JSON files. ([Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm))
     */
    @JvmName("riqdjvwxbqqkeddd")
    public suspend fun inputDetail(`value`: Output<String>) {
        this.inputDetail = value
    }

    /**
     * @param value The input type. Currently only two types of files and plugin are supported.
     */
    @JvmName("ukvmhrlygnuugvue")
    public suspend fun inputType(`value`: Output<String>) {
        this.inputType = value
    }

    /**
     * @param value The log sample of the Logtail configuration. The log size cannot exceed 1,000 bytes.
     */
    @JvmName("equlcuujccjtemmr")
    public suspend fun logSample(`value`: Output<String>) {
        this.logSample = value
    }

    /**
     * @param value The log store name to the query index belongs.
     */
    @JvmName("ahbabgklpbuoajku")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The Logtail configuration name, which is unique in the same project.
     */
    @JvmName("ovscdwehwcvjbovi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The output type. Currently, only LogService is supported.
     */
    @JvmName("hvqbrkrwnmtnacuw")
    public suspend fun outputType(`value`: Output<String>) {
        this.outputType = value
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("sjlksyrgvdljdsdo")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The logtail configure the required JSON files. ([Refer to details](https://www.alibabacloud.com/help/doc-detail/29058.htm))
     */
    @JvmName("ivmyqbpgfbbdqqif")
    public suspend fun inputDetail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDetail = mapped
    }

    /**
     * @param value The input type. Currently only two types of files and plugin are supported.
     */
    @JvmName("lnmmddvxvdavsmef")
    public suspend fun inputType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputType = mapped
    }

    /**
     * @param value The log sample of the Logtail configuration. The log size cannot exceed 1,000 bytes.
     */
    @JvmName("uegdqxvalvclgpie")
    public suspend fun logSample(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logSample = mapped
    }

    /**
     * @param value The log store name to the query index belongs.
     */
    @JvmName("nalqngmhnmlpfaav")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The Logtail configuration name, which is unique in the same project.
     */
    @JvmName("kykqrvjnonduhiha")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The output type. Currently, only LogService is supported.
     */
    @JvmName("syvpyyjljtowfevq")
    public suspend fun outputType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("hnaujyvcapaddxox")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): LogTailConfigArgs = LogTailConfigArgs(
        inputDetail = inputDetail,
        inputType = inputType,
        logSample = logSample,
        logstore = logstore,
        name = name,
        outputType = outputType,
        project = project,
    )
}
