@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MachineGroup].
 */
@PulumiTagMarker
public class MachineGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineGroupArgs = MachineGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineGroupArgsBuilder.() -> Unit) {
        val builder = MachineGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MachineGroup {
        val builtJavaResource = com.pulumi.alicloud.log.MachineGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MachineGroup(builtJavaResource)
    }
}

/**
 * Log Service manages all the ECS instances whose logs need to be collected by using the Logtail client in the form of machine groups.
 *  [Refer to details](https://www.alibabacloud.com/help/doc-detail/28966.htm)
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleMachineGroup = new alicloud.log.MachineGroup("example", {
 *     project: example.name,
 *     name: "terraform-example",
 *     identifyType: "ip",
 *     topic: "terraform",
 *     identifyLists: [
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_machine_group = alicloud.log.MachineGroup("example",
 *     project=example.name,
 *     name="terraform-example",
 *     identify_type="ip",
 *     topic="terraform",
 *     identify_lists=[
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleMachineGroup = new AliCloud.Log.MachineGroup("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "terraform-example",
 *         IdentifyType = "ip",
 *         Topic = "terraform",
 *         IdentifyLists = new[]
 *         {
 *             "10.0.0.1",
 *             "10.0.0.2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewMachineGroup(ctx, "example", &log.MachineGroupArgs{
 * 			Project:      example.Name,
 * 			Name:         pulumi.String("terraform-example"),
 * 			IdentifyType: pulumi.String("ip"),
 * 			Topic:        pulumi.String("terraform"),
 * 			IdentifyLists: pulumi.StringArray{
 * 				pulumi.String("10.0.0.1"),
 * 				pulumi.String("10.0.0.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.MachineGroup;
 * import com.pulumi.alicloud.log.MachineGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleMachineGroup = new MachineGroup("exampleMachineGroup", MachineGroupArgs.builder()
 *             .project(example.name())
 *             .name("terraform-example")
 *             .identifyType("ip")
 *             .topic("terraform")
 *             .identifyLists(
 *                 "10.0.0.1",
 *                 "10.0.0.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleMachineGroup:
 *     type: alicloud:log:MachineGroup
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: terraform-example
 *       identifyType: ip
 *       topic: terraform
 *       identifyLists:
 *         - 10.0.0.1
 *         - 10.0.0.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls-logtail module
 * to create logtail config, machine group, install logtail on ECS instances and join instances into machine group one-click.
 * ## Import
 * Log machine group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/machineGroup:MachineGroup example tf-log:tf-machine-group
 * ```
 */
public class MachineGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.log.MachineGroup,
) : KotlinCustomResource(javaResource, MachineGroupMapper) {
    /**
     * The specific machine identification, which can be an IP address or user-defined identity.
     */
    public val identifyLists: Output<List<String>>
        get() = javaResource.identifyLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The machine identification type, including IP and user-defined identity. Valid values are "ip" and "userdefined". Default to "ip".
     */
    public val identifyType: Output<String>?
        get() = javaResource.identifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The machine group name, which is unique in the same project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The project name to the machine group belongs.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The topic of a machine group.
     */
    public val topic: Output<String>?
        get() = javaResource.topic().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MachineGroupMapper : ResourceMapper<MachineGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.MachineGroup::class == javaResource::class

    override fun map(javaResource: Resource): MachineGroup = MachineGroup(
        javaResource as
            com.pulumi.alicloud.log.MachineGroup,
    )
}

/**
 * @see [MachineGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineGroup].
 */
public suspend fun machineGroup(
    name: String,
    block: suspend MachineGroupResourceBuilder.() -> Unit,
): MachineGroup {
    val builder = MachineGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineGroup(name: String): MachineGroup {
    val builder = MachineGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
