@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.MachineGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log Service manages all the ECS instances whose logs need to be collected by using the Logtail client in the form of machine groups.
 *  [Refer to details](https://www.alibabacloud.com/help/doc-detail/28966.htm)
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleMachineGroup = new alicloud.log.MachineGroup("example", {
 *     project: example.name,
 *     name: "terraform-example",
 *     identifyType: "ip",
 *     topic: "terraform",
 *     identifyLists: [
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_machine_group = alicloud.log.MachineGroup("example",
 *     project=example.name,
 *     name="terraform-example",
 *     identify_type="ip",
 *     topic="terraform",
 *     identify_lists=[
 *         "10.0.0.1",
 *         "10.0.0.2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleMachineGroup = new AliCloud.Log.MachineGroup("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "terraform-example",
 *         IdentifyType = "ip",
 *         Topic = "terraform",
 *         IdentifyLists = new[]
 *         {
 *             "10.0.0.1",
 *             "10.0.0.2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewMachineGroup(ctx, "example", &log.MachineGroupArgs{
 * 			Project:      example.Name,
 * 			Name:         pulumi.String("terraform-example"),
 * 			IdentifyType: pulumi.String("ip"),
 * 			Topic:        pulumi.String("terraform"),
 * 			IdentifyLists: pulumi.StringArray{
 * 				pulumi.String("10.0.0.1"),
 * 				pulumi.String("10.0.0.2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.MachineGroup;
 * import com.pulumi.alicloud.log.MachineGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleMachineGroup = new MachineGroup("exampleMachineGroup", MachineGroupArgs.builder()
 *             .project(example.name())
 *             .name("terraform-example")
 *             .identifyType("ip")
 *             .topic("terraform")
 *             .identifyLists(
 *                 "10.0.0.1",
 *                 "10.0.0.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleMachineGroup:
 *     type: alicloud:log:MachineGroup
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: terraform-example
 *       identifyType: ip
 *       topic: terraform
 *       identifyLists:
 *         - 10.0.0.1
 *         - 10.0.0.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls-logtail module
 * to create logtail config, machine group, install logtail on ECS instances and join instances into machine group one-click.
 * ## Import
 * Log machine group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/machineGroup:MachineGroup example tf-log:tf-machine-group
 * ```
 * @property identifyLists The specific machine identification, which can be an IP address or user-defined identity.
 * @property identifyType The machine identification type, including IP and user-defined identity. Valid values are "ip" and "userdefined". Default to "ip".
 * @property name The machine group name, which is unique in the same project.
 * @property project The project name to the machine group belongs.
 * @property topic The topic of a machine group.
 */
public data class MachineGroupArgs(
    public val identifyLists: Output<List<String>>? = null,
    public val identifyType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.MachineGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.log.MachineGroupArgs =
        com.pulumi.alicloud.log.MachineGroupArgs.builder()
            .identifyLists(identifyLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identifyType(identifyType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineGroupArgs].
 */
@PulumiTagMarker
public class MachineGroupArgsBuilder internal constructor() {
    private var identifyLists: Output<List<String>>? = null

    private var identifyType: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value The specific machine identification, which can be an IP address or user-defined identity.
     */
    @JvmName("cvfdhchrkamkxeth")
    public suspend fun identifyLists(`value`: Output<List<String>>) {
        this.identifyLists = value
    }

    @JvmName("wouseiohyrbbvtkd")
    public suspend fun identifyLists(vararg values: Output<String>) {
        this.identifyLists = Output.all(values.asList())
    }

    /**
     * @param values The specific machine identification, which can be an IP address or user-defined identity.
     */
    @JvmName("dkaeyqjyoqwndxmj")
    public suspend fun identifyLists(values: List<Output<String>>) {
        this.identifyLists = Output.all(values)
    }

    /**
     * @param value The machine identification type, including IP and user-defined identity. Valid values are "ip" and "userdefined". Default to "ip".
     */
    @JvmName("qppnawlpeddvdstf")
    public suspend fun identifyType(`value`: Output<String>) {
        this.identifyType = value
    }

    /**
     * @param value The machine group name, which is unique in the same project.
     */
    @JvmName("qepjhpillsddxmff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The project name to the machine group belongs.
     */
    @JvmName("bfxidskjqctqnhid")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The topic of a machine group.
     */
    @JvmName("ofxjmcytbqteglnv")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value The specific machine identification, which can be an IP address or user-defined identity.
     */
    @JvmName("ierfnwlfluiyxdou")
    public suspend fun identifyLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifyLists = mapped
    }

    /**
     * @param values The specific machine identification, which can be an IP address or user-defined identity.
     */
    @JvmName("xmvksikvaifhcnmg")
    public suspend fun identifyLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identifyLists = mapped
    }

    /**
     * @param value The machine identification type, including IP and user-defined identity. Valid values are "ip" and "userdefined". Default to "ip".
     */
    @JvmName("nkneixtjgcksedkq")
    public suspend fun identifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifyType = mapped
    }

    /**
     * @param value The machine group name, which is unique in the same project.
     */
    @JvmName("kkptrhnyeqbeajwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The project name to the machine group belongs.
     */
    @JvmName("nhjjwqvsfctpxixn")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The topic of a machine group.
     */
    @JvmName("hveabiauiiisgxvi")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): MachineGroupArgs = MachineGroupArgs(
        identifyLists = identifyLists,
        identifyType = identifyType,
        name = name,
        project = project,
        topic = topic,
    )
}
