@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.kotlin.outputs.OssExportConfigColumn
import com.pulumi.alicloud.log.kotlin.outputs.OssExportConfigColumn.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OssExport].
 */
@PulumiTagMarker
public class OssExportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OssExportArgs = OssExportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OssExportArgsBuilder.() -> Unit) {
        val builder = OssExportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OssExport {
        val builtJavaResource = com.pulumi.alicloud.log.OssExport(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OssExport(builtJavaResource)
    }
}

/**
 * Log service data delivery management, this service provides the function of delivering data in logstore to oss product storage.
 * [Refer to details](https://www.alibabacloud.com/help/en/log-service/latest/ship-logs-to-oss-new-version).
 * > **NOTE:** Available in 1.187.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleOssExport = new alicloud.log.OssExport("example", {
 *     projectName: example.name,
 *     logstoreName: exampleStore.name,
 *     exportName: "terraform-example",
 *     displayName: "terraform-example",
 *     bucket: "example-bucket",
 *     prefix: "root",
 *     suffix: "",
 *     bufferInterval: 300,
 *     bufferSize: 250,
 *     compressType: "none",
 *     pathFormat: "%Y/%m/%d/%H/%M",
 *     contentType: "json",
 *     jsonEnableTag: true,
 *     roleArn: "role_arn_for_oss_write",
 *     logReadRoleArn: "role_arn_for_sls_read",
 *     timeZone: "+0800",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_oss_export = alicloud.log.OssExport("example",
 *     project_name=example.name,
 *     logstore_name=example_store.name,
 *     export_name="terraform-example",
 *     display_name="terraform-example",
 *     bucket="example-bucket",
 *     prefix="root",
 *     suffix="",
 *     buffer_interval=300,
 *     buffer_size=250,
 *     compress_type="none",
 *     path_format="%Y/%m/%d/%H/%M",
 *     content_type="json",
 *     json_enable_tag=True,
 *     role_arn="role_arn_for_oss_write",
 *     log_read_role_arn="role_arn_for_sls_read",
 *     time_zone="+0800")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleOssExport = new AliCloud.Log.OssExport("example", new()
 *     {
 *         ProjectName = example.Name,
 *         LogstoreName = exampleStore.Name,
 *         ExportName = "terraform-example",
 *         DisplayName = "terraform-example",
 *         Bucket = "example-bucket",
 *         Prefix = "root",
 *         Suffix = "",
 *         BufferInterval = 300,
 *         BufferSize = 250,
 *         CompressType = "none",
 *         PathFormat = "%Y/%m/%d/%H/%M",
 *         ContentType = "json",
 *         JsonEnableTag = true,
 *         RoleArn = "role_arn_for_oss_write",
 *         LogReadRoleArn = "role_arn_for_sls_read",
 *         TimeZone = "+0800",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewOssExport(ctx, "example", &log.OssExportArgs{
 * 			ProjectName:    example.Name,
 * 			LogstoreName:   exampleStore.Name,
 * 			ExportName:     pulumi.String("terraform-example"),
 * 			DisplayName:    pulumi.String("terraform-example"),
 * 			Bucket:         pulumi.String("example-bucket"),
 * 			Prefix:         pulumi.String("root"),
 * 			Suffix:         pulumi.String(""),
 * 			BufferInterval: pulumi.Int(300),
 * 			BufferSize:     pulumi.Int(250),
 * 			CompressType:   pulumi.String("none"),
 * 			PathFormat:     pulumi.String("%Y/%m/%d/%H/%M"),
 * 			ContentType:    pulumi.String("json"),
 * 			JsonEnableTag:  pulumi.Bool(true),
 * 			RoleArn:        pulumi.String("role_arn_for_oss_write"),
 * 			LogReadRoleArn: pulumi.String("role_arn_for_sls_read"),
 * 			TimeZone:       pulumi.String("+0800"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.OssExport;
 * import com.pulumi.alicloud.log.OssExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleOssExport = new OssExport("exampleOssExport", OssExportArgs.builder()
 *             .projectName(example.name())
 *             .logstoreName(exampleStore.name())
 *             .exportName("terraform-example")
 *             .displayName("terraform-example")
 *             .bucket("example-bucket")
 *             .prefix("root")
 *             .suffix("")
 *             .bufferInterval(300)
 *             .bufferSize(250)
 *             .compressType("none")
 *             .pathFormat("%Y/%m/%d/%H/%M")
 *             .contentType("json")
 *             .jsonEnableTag(true)
 *             .roleArn("role_arn_for_oss_write")
 *             .logReadRoleArn("role_arn_for_sls_read")
 *             .timeZone("+0800")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleOssExport:
 *     type: alicloud:log:OssExport
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       logstoreName: ${exampleStore.name}
 *       exportName: terraform-example
 *       displayName: terraform-example
 *       bucket: example-bucket
 *       prefix: root
 *       suffix:
 *       bufferInterval: 300
 *       bufferSize: 250
 *       compressType: none
 *       pathFormat: '%Y/%m/%d/%H/%M'
 *       contentType: json
 *       jsonEnableTag: true
 *       roleArn: role_arn_for_oss_write
 *       logReadRoleArn: role_arn_for_sls_read
 *       timeZone: '+0800'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log oss export can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:log/ossExport:OssExport example tf-log-project:tf-log-logstore:tf-log-export
 * ```
 */
public class OssExport internal constructor(
    override val javaResource: com.pulumi.alicloud.log.OssExport,
) : KotlinCustomResource(javaResource, OssExportMapper) {
    /**
     * The name of the oss bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * How often is it delivered every interval.
     */
    public val bufferInterval: Output<Int>
        get() = javaResource.bufferInterval().applyValue({ args0 -> args0 })

    /**
     * Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
     */
    public val bufferSize: Output<Int>
        get() = javaResource.bufferSize().applyValue({ args0 -> args0 })

    /**
     * OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
     */
    public val compressType: Output<String>
        get() = javaResource.compressType().applyValue({ args0 -> args0 })

    /**
     * Configure columns when `content_type` is `parquet` or `orc`.
     */
    public val configColumns: Output<List<OssExportConfigColumn>>?
        get() = javaResource.configColumns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
     * **According to the different format, please select the following parameters**
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Field configuration in csv content_type.
     */
    public val csvConfigColumns: Output<List<String>>?
        get() = javaResource.csvConfigColumns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Separator configuration in csv content_type.
     */
    public val csvConfigDelimiter: Output<String>?
        get() = javaResource.csvConfigDelimiter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * escape in csv content_type.
     */
    public val csvConfigEscape: Output<String>?
        get() = javaResource.csvConfigEscape().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to write the field name to the CSV file, the default value is `false`.
     */
    public val csvConfigHeader: Output<Boolean>?
        get() = javaResource.csvConfigHeader().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * lineFeed in csv content_type.
     */
    public val csvConfigLinefeed: Output<String>?
        get() = javaResource.csvConfigLinefeed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invalid field content in csv content_type.
     */
    public val csvConfigNull: Output<String>?
        get() = javaResource.csvConfigNull().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Escape character in csv content_type.
     */
    public val csvConfigQuote: Output<String>?
        get() = javaResource.csvConfigQuote().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for oss export.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    public val exportName: Output<String>
        get() = javaResource.exportName().applyValue({ args0 -> args0 })

    /**
     * The log from when to export to oss.
     */
    public val fromTime: Output<Int>?
        get() = javaResource.fromTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to deliver the label when `content_type` = `json`.
     */
    public val jsonEnableTag: Output<Boolean>?
        get() = javaResource.jsonEnableTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
     */
    public val logReadRoleArn: Output<String>?
        get() = javaResource.logReadRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the log logstore.
     */
    public val logstoreName: Output<String>
        get() = javaResource.logstoreName().applyValue({ args0 -> args0 })

    /**
     * The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
     */
    public val pathFormat: Output<String>
        get() = javaResource.pathFormat().applyValue({ args0 -> args0 })

    /**
     * The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the log project. It is the only in one Alicloud account.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The suffix for the objects in which the shipped data is stored.
     */
    public val suffix: Output<String>?
        get() = javaResource.suffix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This time zone that is used to format the time, `+0800` e.g.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })
}

public object OssExportMapper : ResourceMapper<OssExport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.OssExport::class == javaResource::class

    override fun map(javaResource: Resource): OssExport = OssExport(
        javaResource as
            com.pulumi.alicloud.log.OssExport,
    )
}

/**
 * @see [OssExport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OssExport].
 */
public suspend fun ossExport(name: String, block: suspend OssExportResourceBuilder.() -> Unit): OssExport {
    val builder = OssExportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OssExport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ossExport(name: String): OssExport {
    val builder = OssExportResourceBuilder()
    builder.name(name)
    return builder.build()
}
