@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.OssExportArgs.builder
import com.pulumi.alicloud.log.kotlin.inputs.OssExportConfigColumnArgs
import com.pulumi.alicloud.log.kotlin.inputs.OssExportConfigColumnArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log service data delivery management, this service provides the function of delivering data in logstore to oss product storage.
 * [Refer to details](https://www.alibabacloud.com/help/en/log-service/latest/ship-logs-to-oss-new-version).
 * > **NOTE:** Available in 1.187.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleOssExport = new alicloud.log.OssExport("example", {
 *     projectName: example.name,
 *     logstoreName: exampleStore.name,
 *     exportName: "terraform-example",
 *     displayName: "terraform-example",
 *     bucket: "example-bucket",
 *     prefix: "root",
 *     suffix: "",
 *     bufferInterval: 300,
 *     bufferSize: 250,
 *     compressType: "none",
 *     pathFormat: "%Y/%m/%d/%H/%M",
 *     contentType: "json",
 *     jsonEnableTag: true,
 *     roleArn: "role_arn_for_oss_write",
 *     logReadRoleArn: "role_arn_for_sls_read",
 *     timeZone: "+0800",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_oss_export = alicloud.log.OssExport("example",
 *     project_name=example.name,
 *     logstore_name=example_store.name,
 *     export_name="terraform-example",
 *     display_name="terraform-example",
 *     bucket="example-bucket",
 *     prefix="root",
 *     suffix="",
 *     buffer_interval=300,
 *     buffer_size=250,
 *     compress_type="none",
 *     path_format="%Y/%m/%d/%H/%M",
 *     content_type="json",
 *     json_enable_tag=True,
 *     role_arn="role_arn_for_oss_write",
 *     log_read_role_arn="role_arn_for_sls_read",
 *     time_zone="+0800")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleOssExport = new AliCloud.Log.OssExport("example", new()
 *     {
 *         ProjectName = example.Name,
 *         LogstoreName = exampleStore.Name,
 *         ExportName = "terraform-example",
 *         DisplayName = "terraform-example",
 *         Bucket = "example-bucket",
 *         Prefix = "root",
 *         Suffix = "",
 *         BufferInterval = 300,
 *         BufferSize = 250,
 *         CompressType = "none",
 *         PathFormat = "%Y/%m/%d/%H/%M",
 *         ContentType = "json",
 *         JsonEnableTag = true,
 *         RoleArn = "role_arn_for_oss_write",
 *         LogReadRoleArn = "role_arn_for_sls_read",
 *         TimeZone = "+0800",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewOssExport(ctx, "example", &log.OssExportArgs{
 * 			ProjectName:    example.Name,
 * 			LogstoreName:   exampleStore.Name,
 * 			ExportName:     pulumi.String("terraform-example"),
 * 			DisplayName:    pulumi.String("terraform-example"),
 * 			Bucket:         pulumi.String("example-bucket"),
 * 			Prefix:         pulumi.String("root"),
 * 			Suffix:         pulumi.String(""),
 * 			BufferInterval: pulumi.Int(300),
 * 			BufferSize:     pulumi.Int(250),
 * 			CompressType:   pulumi.String("none"),
 * 			PathFormat:     pulumi.String("%Y/%m/%d/%H/%M"),
 * 			ContentType:    pulumi.String("json"),
 * 			JsonEnableTag:  pulumi.Bool(true),
 * 			RoleArn:        pulumi.String("role_arn_for_oss_write"),
 * 			LogReadRoleArn: pulumi.String("role_arn_for_sls_read"),
 * 			TimeZone:       pulumi.String("+0800"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.OssExport;
 * import com.pulumi.alicloud.log.OssExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleOssExport = new OssExport("exampleOssExport", OssExportArgs.builder()
 *             .projectName(example.name())
 *             .logstoreName(exampleStore.name())
 *             .exportName("terraform-example")
 *             .displayName("terraform-example")
 *             .bucket("example-bucket")
 *             .prefix("root")
 *             .suffix("")
 *             .bufferInterval(300)
 *             .bufferSize(250)
 *             .compressType("none")
 *             .pathFormat("%Y/%m/%d/%H/%M")
 *             .contentType("json")
 *             .jsonEnableTag(true)
 *             .roleArn("role_arn_for_oss_write")
 *             .logReadRoleArn("role_arn_for_sls_read")
 *             .timeZone("+0800")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleOssExport:
 *     type: alicloud:log:OssExport
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       logstoreName: ${exampleStore.name}
 *       exportName: terraform-example
 *       displayName: terraform-example
 *       bucket: example-bucket
 *       prefix: root
 *       suffix:
 *       bufferInterval: 300
 *       bufferSize: 250
 *       compressType: none
 *       pathFormat: '%Y/%m/%d/%H/%M'
 *       contentType: json
 *       jsonEnableTag: true
 *       roleArn: role_arn_for_oss_write
 *       logReadRoleArn: role_arn_for_sls_read
 *       timeZone: '+0800'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log oss export can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:log/ossExport:OssExport example tf-log-project:tf-log-logstore:tf-log-export
 * ```
 * @property bucket The name of the oss bucket.
 * @property bufferInterval How often is it delivered every interval.
 * @property bufferSize Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
 * @property compressType OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
 * @property configColumns Configure columns when `content_type` is `parquet` or `orc`.
 * @property contentType Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
 * **According to the different format, please select the following parameters**
 * @property csvConfigColumns Field configuration in csv content_type.
 * @property csvConfigDelimiter Separator configuration in csv content_type.
 * @property csvConfigEscape escape in csv content_type.
 * @property csvConfigHeader Indicates whether to write the field name to the CSV file, the default value is `false`.
 * @property csvConfigLinefeed lineFeed in csv content_type.
 * @property csvConfigNull Invalid field content in csv content_type.
 * @property csvConfigQuote Escape character in csv content_type.
 * @property displayName The display name for oss export.
 * @property exportName Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
 * @property fromTime The log from when to export to oss.
 * @property jsonEnableTag Whether to deliver the label when `content_type` = `json`.
 * @property logReadRoleArn Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
 * @property logstoreName The name of the log logstore.
 * @property pathFormat The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
 * @property prefix The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
 * @property projectName The name of the log project. It is the only in one Alicloud account.
 * @property roleArn Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
 * @property suffix The suffix for the objects in which the shipped data is stored.
 * @property timeZone This time zone that is used to format the time, `+0800` e.g.
 */
public data class OssExportArgs(
    public val bucket: Output<String>? = null,
    public val bufferInterval: Output<Int>? = null,
    public val bufferSize: Output<Int>? = null,
    public val compressType: Output<String>? = null,
    public val configColumns: Output<List<OssExportConfigColumnArgs>>? = null,
    public val contentType: Output<String>? = null,
    public val csvConfigColumns: Output<List<String>>? = null,
    public val csvConfigDelimiter: Output<String>? = null,
    public val csvConfigEscape: Output<String>? = null,
    public val csvConfigHeader: Output<Boolean>? = null,
    public val csvConfigLinefeed: Output<String>? = null,
    public val csvConfigNull: Output<String>? = null,
    public val csvConfigQuote: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val exportName: Output<String>? = null,
    public val fromTime: Output<Int>? = null,
    public val jsonEnableTag: Output<Boolean>? = null,
    public val logReadRoleArn: Output<String>? = null,
    public val logstoreName: Output<String>? = null,
    public val pathFormat: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val suffix: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.OssExportArgs> {
    override fun toJava(): com.pulumi.alicloud.log.OssExportArgs =
        com.pulumi.alicloud.log.OssExportArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .bufferInterval(bufferInterval?.applyValue({ args0 -> args0 }))
            .bufferSize(bufferSize?.applyValue({ args0 -> args0 }))
            .compressType(compressType?.applyValue({ args0 -> args0 }))
            .configColumns(
                configColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .csvConfigColumns(csvConfigColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .csvConfigDelimiter(csvConfigDelimiter?.applyValue({ args0 -> args0 }))
            .csvConfigEscape(csvConfigEscape?.applyValue({ args0 -> args0 }))
            .csvConfigHeader(csvConfigHeader?.applyValue({ args0 -> args0 }))
            .csvConfigLinefeed(csvConfigLinefeed?.applyValue({ args0 -> args0 }))
            .csvConfigNull(csvConfigNull?.applyValue({ args0 -> args0 }))
            .csvConfigQuote(csvConfigQuote?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .exportName(exportName?.applyValue({ args0 -> args0 }))
            .fromTime(fromTime?.applyValue({ args0 -> args0 }))
            .jsonEnableTag(jsonEnableTag?.applyValue({ args0 -> args0 }))
            .logReadRoleArn(logReadRoleArn?.applyValue({ args0 -> args0 }))
            .logstoreName(logstoreName?.applyValue({ args0 -> args0 }))
            .pathFormat(pathFormat?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssExportArgs].
 */
@PulumiTagMarker
public class OssExportArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var bufferInterval: Output<Int>? = null

    private var bufferSize: Output<Int>? = null

    private var compressType: Output<String>? = null

    private var configColumns: Output<List<OssExportConfigColumnArgs>>? = null

    private var contentType: Output<String>? = null

    private var csvConfigColumns: Output<List<String>>? = null

    private var csvConfigDelimiter: Output<String>? = null

    private var csvConfigEscape: Output<String>? = null

    private var csvConfigHeader: Output<Boolean>? = null

    private var csvConfigLinefeed: Output<String>? = null

    private var csvConfigNull: Output<String>? = null

    private var csvConfigQuote: Output<String>? = null

    private var displayName: Output<String>? = null

    private var exportName: Output<String>? = null

    private var fromTime: Output<Int>? = null

    private var jsonEnableTag: Output<Boolean>? = null

    private var logReadRoleArn: Output<String>? = null

    private var logstoreName: Output<String>? = null

    private var pathFormat: Output<String>? = null

    private var prefix: Output<String>? = null

    private var projectName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var suffix: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value The name of the oss bucket.
     */
    @JvmName("uutnqxfiihtooevp")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value How often is it delivered every interval.
     */
    @JvmName("balghvqpajsvbekv")
    public suspend fun bufferInterval(`value`: Output<Int>) {
        this.bufferInterval = value
    }

    /**
     * @param value Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
     */
    @JvmName("ujgfgrywfjfnnphg")
    public suspend fun bufferSize(`value`: Output<Int>) {
        this.bufferSize = value
    }

    /**
     * @param value OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
     */
    @JvmName("bmfvkihesaprbjsw")
    public suspend fun compressType(`value`: Output<String>) {
        this.compressType = value
    }

    /**
     * @param value Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("oaabmbcpajumtvpn")
    public suspend fun configColumns(`value`: Output<List<OssExportConfigColumnArgs>>) {
        this.configColumns = value
    }

    @JvmName("etdxxyhobwttfrjt")
    public suspend fun configColumns(vararg values: Output<OssExportConfigColumnArgs>) {
        this.configColumns = Output.all(values.asList())
    }

    /**
     * @param values Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("acbkvsxdrywssxng")
    public suspend fun configColumns(values: List<Output<OssExportConfigColumnArgs>>) {
        this.configColumns = Output.all(values)
    }

    /**
     * @param value Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
     * **According to the different format, please select the following parameters**
     */
    @JvmName("pvuilkpupvvbaopk")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Field configuration in csv content_type.
     */
    @JvmName("xyymvwlerxowdisj")
    public suspend fun csvConfigColumns(`value`: Output<List<String>>) {
        this.csvConfigColumns = value
    }

    @JvmName("xsmmwotpymbggfqv")
    public suspend fun csvConfigColumns(vararg values: Output<String>) {
        this.csvConfigColumns = Output.all(values.asList())
    }

    /**
     * @param values Field configuration in csv content_type.
     */
    @JvmName("yvjpgvvtlcttgloe")
    public suspend fun csvConfigColumns(values: List<Output<String>>) {
        this.csvConfigColumns = Output.all(values)
    }

    /**
     * @param value Separator configuration in csv content_type.
     */
    @JvmName("ssmrdkrxvnqxfhcg")
    public suspend fun csvConfigDelimiter(`value`: Output<String>) {
        this.csvConfigDelimiter = value
    }

    /**
     * @param value escape in csv content_type.
     */
    @JvmName("esgtlmjgtxdsdfss")
    public suspend fun csvConfigEscape(`value`: Output<String>) {
        this.csvConfigEscape = value
    }

    /**
     * @param value Indicates whether to write the field name to the CSV file, the default value is `false`.
     */
    @JvmName("udgntxeimoucvmqm")
    public suspend fun csvConfigHeader(`value`: Output<Boolean>) {
        this.csvConfigHeader = value
    }

    /**
     * @param value lineFeed in csv content_type.
     */
    @JvmName("lakocomkvfbwjryn")
    public suspend fun csvConfigLinefeed(`value`: Output<String>) {
        this.csvConfigLinefeed = value
    }

    /**
     * @param value Invalid field content in csv content_type.
     */
    @JvmName("lggvbajnssojefpr")
    public suspend fun csvConfigNull(`value`: Output<String>) {
        this.csvConfigNull = value
    }

    /**
     * @param value Escape character in csv content_type.
     */
    @JvmName("xaylhjfcjkbxnjgp")
    public suspend fun csvConfigQuote(`value`: Output<String>) {
        this.csvConfigQuote = value
    }

    /**
     * @param value The display name for oss export.
     */
    @JvmName("yaslaypntcxhnoyv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("whhwwsgabgldoalf")
    public suspend fun exportName(`value`: Output<String>) {
        this.exportName = value
    }

    /**
     * @param value The log from when to export to oss.
     */
    @JvmName("hgqlabitxhlyumks")
    public suspend fun fromTime(`value`: Output<Int>) {
        this.fromTime = value
    }

    /**
     * @param value Whether to deliver the label when `content_type` = `json`.
     */
    @JvmName("bkyahumjlvgwqvcl")
    public suspend fun jsonEnableTag(`value`: Output<Boolean>) {
        this.jsonEnableTag = value
    }

    /**
     * @param value Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
     */
    @JvmName("aierspeaiwovmcaw")
    public suspend fun logReadRoleArn(`value`: Output<String>) {
        this.logReadRoleArn = value
    }

    /**
     * @param value The name of the log logstore.
     */
    @JvmName("mfmbrbqlrsskxeqn")
    public suspend fun logstoreName(`value`: Output<String>) {
        this.logstoreName = value
    }

    /**
     * @param value The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
     */
    @JvmName("ygygwisrtpmeugff")
    public suspend fun pathFormat(`value`: Output<String>) {
        this.pathFormat = value
    }

    /**
     * @param value The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
     */
    @JvmName("fxdxerjfrvmhhwxw")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("ctkneyjqrheyqeri")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
     */
    @JvmName("yvpdflvslrvhckfc")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The suffix for the objects in which the shipped data is stored.
     */
    @JvmName("rwtgitbnacllsquj")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value This time zone that is used to format the time, `+0800` e.g.
     */
    @JvmName("jydfmihogxmvldyi")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value The name of the oss bucket.
     */
    @JvmName("rvmdygawisbbwtox")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value How often is it delivered every interval.
     */
    @JvmName("mjpinqqvtfxnqqan")
    public suspend fun bufferInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferInterval = mapped
    }

    /**
     * @param value Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
     */
    @JvmName("pgepaneirdabroab")
    public suspend fun bufferSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferSize = mapped
    }

    /**
     * @param value OSS data storage compression method, support: `none`, `snappy`, `zstd`, `gzip`. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
     */
    @JvmName("fpuctgvmwjxwanoh")
    public suspend fun compressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressType = mapped
    }

    /**
     * @param value Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("yyiednbiyruehpwk")
    public suspend fun configColumns(`value`: List<OssExportConfigColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configColumns = mapped
    }

    /**
     * @param argument Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("wnagxdgrksihetut")
    public suspend fun configColumns(argument: List<suspend OssExportConfigColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OssExportConfigColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configColumns = mapped
    }

    /**
     * @param argument Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("ydhklfrifdxmhhgr")
    public suspend fun configColumns(vararg argument: suspend OssExportConfigColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OssExportConfigColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configColumns = mapped
    }

    /**
     * @param argument Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("gmvgftgweidrfevs")
    public suspend fun configColumns(argument: suspend OssExportConfigColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OssExportConfigColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configColumns = mapped
    }

    /**
     * @param values Configure columns when `content_type` is `parquet` or `orc`.
     */
    @JvmName("onlufnrnrcwbcxcy")
    public suspend fun configColumns(vararg values: OssExportConfigColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configColumns = mapped
    }

    /**
     * @param value Storage format, only supports three types: `json`, `parquet`, `orc`, `csv`.
     * **According to the different format, please select the following parameters**
     */
    @JvmName("dncueuixnjaobikr")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Field configuration in csv content_type.
     */
    @JvmName("mymxpucqcgiuuuah")
    public suspend fun csvConfigColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigColumns = mapped
    }

    /**
     * @param values Field configuration in csv content_type.
     */
    @JvmName("nuiptogauhbqojpn")
    public suspend fun csvConfigColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.csvConfigColumns = mapped
    }

    /**
     * @param value Separator configuration in csv content_type.
     */
    @JvmName("yfnpmsdnwmhbaqwd")
    public suspend fun csvConfigDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigDelimiter = mapped
    }

    /**
     * @param value escape in csv content_type.
     */
    @JvmName("ppjaaokhaoocrcei")
    public suspend fun csvConfigEscape(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigEscape = mapped
    }

    /**
     * @param value Indicates whether to write the field name to the CSV file, the default value is `false`.
     */
    @JvmName("hmsjkjqpgwyhjfse")
    public suspend fun csvConfigHeader(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigHeader = mapped
    }

    /**
     * @param value lineFeed in csv content_type.
     */
    @JvmName("tlcygkghtdhkcbhc")
    public suspend fun csvConfigLinefeed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigLinefeed = mapped
    }

    /**
     * @param value Invalid field content in csv content_type.
     */
    @JvmName("syuxuvgmgabdntxg")
    public suspend fun csvConfigNull(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigNull = mapped
    }

    /**
     * @param value Escape character in csv content_type.
     */
    @JvmName("vjgsjsqbhpfxilts")
    public suspend fun csvConfigQuote(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigQuote = mapped
    }

    /**
     * @param value The display name for oss export.
     */
    @JvmName("fnacgqksftylhcqd")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("uhflpenelnvefwtr")
    public suspend fun exportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportName = mapped
    }

    /**
     * @param value The log from when to export to oss.
     */
    @JvmName("xlryknpvumslsrhk")
    public suspend fun fromTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromTime = mapped
    }

    /**
     * @param value Whether to deliver the label when `content_type` = `json`.
     */
    @JvmName("jfhmygosrvkcrsdy")
    public suspend fun jsonEnableTag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonEnableTag = mapped
    }

    /**
     * @param value Used for logstore reading, the role should have log read policy, such as `acs:ram::13234:role/logrole`, if `log_read_role_arn` is not set, `role_arn` is used to read logstore.
     */
    @JvmName("quhawltsfgmilgiw")
    public suspend fun logReadRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logReadRoleArn = mapped
    }

    /**
     * @param value The name of the log logstore.
     */
    @JvmName("qmkfmqlighwthxhk")
    public suspend fun logstoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstoreName = mapped
    }

    /**
     * @param value The OSS Bucket directory is dynamically generated according to the creation time of the export task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
     */
    @JvmName("gapypqckgqxrulqy")
    public suspend fun pathFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathFormat = mapped
    }

    /**
     * @param value The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
     */
    @JvmName("qtuqnxbtrujvwwom")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("dgvuinyduqtexghg")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Used to write to oss bucket, the OSS Bucket owner creates the role mark which has the oss bucket write policy, such as `acs:ram::13234:role/logrole`.
     */
    @JvmName("bibsuiolmmjijgay")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The suffix for the objects in which the shipped data is stored.
     */
    @JvmName("mqbibcochhfcyqug")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    /**
     * @param value This time zone that is used to format the time, `+0800` e.g.
     */
    @JvmName("mutatgrftgjyrwuq")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): OssExportArgs = OssExportArgs(
        bucket = bucket,
        bufferInterval = bufferInterval,
        bufferSize = bufferSize,
        compressType = compressType,
        configColumns = configColumns,
        contentType = contentType,
        csvConfigColumns = csvConfigColumns,
        csvConfigDelimiter = csvConfigDelimiter,
        csvConfigEscape = csvConfigEscape,
        csvConfigHeader = csvConfigHeader,
        csvConfigLinefeed = csvConfigLinefeed,
        csvConfigNull = csvConfigNull,
        csvConfigQuote = csvConfigQuote,
        displayName = displayName,
        exportName = exportName,
        fromTime = fromTime,
        jsonEnableTag = jsonEnableTag,
        logReadRoleArn = logReadRoleArn,
        logstoreName = logstoreName,
        pathFormat = pathFormat,
        prefix = prefix,
        projectName = projectName,
        roleArn = roleArn,
        suffix = suffix,
        timeZone = timeZone,
    )
}
