@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.OssShipperArgs.builder
import com.pulumi.alicloud.log.kotlin.inputs.OssShipperParquetConfigArgs
import com.pulumi.alicloud.log.kotlin.inputs.OssShipperParquetConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log service data delivery management, this service provides the function of delivering data in logstore to oss product storage.
 * [Refer to details](https://www.alibabacloud.com/help/en/doc-detail/43724.htm).
 * > **NOTE:** Available in 1.121.0+
 * > **DEPRECATED:**  This resource has been deprecated from version `1.215.0`. Please use new resource alicloud_log_oss_export.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     retentionPeriod: 3650,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleOssShipper = new alicloud.log.OssShipper("example", {
 *     projectName: example.name,
 *     logstoreName: exampleStore.name,
 *     shipperName: "terraform-example",
 *     ossBucket: "example_bucket",
 *     ossPrefix: "root",
 *     bufferInterval: 300,
 *     bufferSize: 250,
 *     compressType: "none",
 *     pathFormat: "%Y/%m/%d/%H/%M",
 *     format: "json",
 *     jsonEnableTag: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     retention_period=3650,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_oss_shipper = alicloud.log.OssShipper("example",
 *     project_name=example.name,
 *     logstore_name=example_store.name,
 *     shipper_name="terraform-example",
 *     oss_bucket="example_bucket",
 *     oss_prefix="root",
 *     buffer_interval=300,
 *     buffer_size=250,
 *     compress_type="none",
 *     path_format="%Y/%m/%d/%H/%M",
 *     format="json",
 *     json_enable_tag=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         RetentionPeriod = 3650,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleOssShipper = new AliCloud.Log.OssShipper("example", new()
 *     {
 *         ProjectName = example.Name,
 *         LogstoreName = exampleStore.Name,
 *         ShipperName = "terraform-example",
 *         OssBucket = "example_bucket",
 *         OssPrefix = "root",
 *         BufferInterval = 300,
 *         BufferSize = 250,
 *         CompressType = "none",
 *         PathFormat = "%Y/%m/%d/%H/%M",
 *         Format = "json",
 *         JsonEnableTag = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewOssShipper(ctx, "example", &log.OssShipperArgs{
 * 			ProjectName:    example.Name,
 * 			LogstoreName:   exampleStore.Name,
 * 			ShipperName:    pulumi.String("terraform-example"),
 * 			OssBucket:      pulumi.String("example_bucket"),
 * 			OssPrefix:      pulumi.String("root"),
 * 			BufferInterval: pulumi.Int(300),
 * 			BufferSize:     pulumi.Int(250),
 * 			CompressType:   pulumi.String("none"),
 * 			PathFormat:     pulumi.String("%Y/%m/%d/%H/%M"),
 * 			Format:         pulumi.String("json"),
 * 			JsonEnableTag:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.OssShipper;
 * import com.pulumi.alicloud.log.OssShipperArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .retentionPeriod(3650)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleOssShipper = new OssShipper("exampleOssShipper", OssShipperArgs.builder()
 *             .projectName(example.name())
 *             .logstoreName(exampleStore.name())
 *             .shipperName("terraform-example")
 *             .ossBucket("example_bucket")
 *             .ossPrefix("root")
 *             .bufferInterval(300)
 *             .bufferSize(250)
 *             .compressType("none")
 *             .pathFormat("%Y/%m/%d/%H/%M")
 *             .format("json")
 *             .jsonEnableTag(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       retentionPeriod: 3650
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleOssShipper:
 *     type: alicloud:log:OssShipper
 *     name: example
 *     properties:
 *       projectName: ${example.name}
 *       logstoreName: ${exampleStore.name}
 *       shipperName: terraform-example
 *       ossBucket: example_bucket
 *       ossPrefix: root
 *       bufferInterval: 300
 *       bufferSize: 250
 *       compressType: none
 *       pathFormat: '%Y/%m/%d/%H/%M'
 *       format: json
 *       jsonEnableTag: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log oss shipper can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:log/ossShipper:OssShipper example tf-log-project:tf-log-logstore:tf-log-shipper
 * ```
 * @property bufferInterval How often is it delivered every interval.
 * @property bufferSize Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
 * @property compressType OSS data storage compression method, support: none, snappy. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
 * @property csvConfigColumns
 * @property csvConfigDelimiter
 * @property csvConfigHeader
 * @property csvConfigLinefeed
 * @property csvConfigNullidentifier
 * @property csvConfigQuote
 * @property format Storage format, only supports three types: `json`, `parquet`, `csv`.
 * **According to the different format, please select the following parameters**
 * - format = `json`
 * `json_enable_tag` - (Optional) Whether to deliver the label.
 * - format = `csv`
 * `csv_config_delimiter` - (Optional) Separator configuration in csv configuration format.
 * `csv_config_columns` - (Optional) Field configuration in csv configuration format.
 * `csv_config_nullidentifier` - (Optional) Invalid field content.
 * `csv_config_quote` - (Optional) Escape character under csv configuration.
 * `csv_config_header` - (Optional) Indicates whether to write the field name to the CSV file, the default value is `false`.
 * `csv_config_linefeed` - (Optional) lineFeed in csv configuration.
 * - format = `parquet`
 * `parquet_config` - (Optional) Configure to use parquet storage format.
 * `name` - (Required) The name of the key.
 * `type` - (Required) Type of configuration name.
 * @property jsonEnableTag
 * @property logstoreName The name of the log logstore.
 * @property ossBucket The name of the oss bucket.
 * @property ossPrefix The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
 * @property parquetConfigs
 * @property pathFormat The OSS Bucket directory is dynamically generated according to the creation time of the shipper task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
 * @property projectName The name of the log project. It is the only in one Alicloud account.
 * @property roleArn Used for access control, the OSS Bucket owner creates the role mark, such as `acs:ram::13234:role/logrole`
 * @property shipperName Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
 */
public data class OssShipperArgs(
    public val bufferInterval: Output<Int>? = null,
    public val bufferSize: Output<Int>? = null,
    public val compressType: Output<String>? = null,
    public val csvConfigColumns: Output<List<String>>? = null,
    public val csvConfigDelimiter: Output<String>? = null,
    public val csvConfigHeader: Output<Boolean>? = null,
    public val csvConfigLinefeed: Output<String>? = null,
    public val csvConfigNullidentifier: Output<String>? = null,
    public val csvConfigQuote: Output<String>? = null,
    public val format: Output<String>? = null,
    public val jsonEnableTag: Output<Boolean>? = null,
    public val logstoreName: Output<String>? = null,
    public val ossBucket: Output<String>? = null,
    public val ossPrefix: Output<String>? = null,
    public val parquetConfigs: Output<List<OssShipperParquetConfigArgs>>? = null,
    public val pathFormat: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val shipperName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.OssShipperArgs> {
    override fun toJava(): com.pulumi.alicloud.log.OssShipperArgs =
        com.pulumi.alicloud.log.OssShipperArgs.builder()
            .bufferInterval(bufferInterval?.applyValue({ args0 -> args0 }))
            .bufferSize(bufferSize?.applyValue({ args0 -> args0 }))
            .compressType(compressType?.applyValue({ args0 -> args0 }))
            .csvConfigColumns(csvConfigColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .csvConfigDelimiter(csvConfigDelimiter?.applyValue({ args0 -> args0 }))
            .csvConfigHeader(csvConfigHeader?.applyValue({ args0 -> args0 }))
            .csvConfigLinefeed(csvConfigLinefeed?.applyValue({ args0 -> args0 }))
            .csvConfigNullidentifier(csvConfigNullidentifier?.applyValue({ args0 -> args0 }))
            .csvConfigQuote(csvConfigQuote?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .jsonEnableTag(jsonEnableTag?.applyValue({ args0 -> args0 }))
            .logstoreName(logstoreName?.applyValue({ args0 -> args0 }))
            .ossBucket(ossBucket?.applyValue({ args0 -> args0 }))
            .ossPrefix(ossPrefix?.applyValue({ args0 -> args0 }))
            .parquetConfigs(
                parquetConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pathFormat(pathFormat?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .shipperName(shipperName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssShipperArgs].
 */
@PulumiTagMarker
public class OssShipperArgsBuilder internal constructor() {
    private var bufferInterval: Output<Int>? = null

    private var bufferSize: Output<Int>? = null

    private var compressType: Output<String>? = null

    private var csvConfigColumns: Output<List<String>>? = null

    private var csvConfigDelimiter: Output<String>? = null

    private var csvConfigHeader: Output<Boolean>? = null

    private var csvConfigLinefeed: Output<String>? = null

    private var csvConfigNullidentifier: Output<String>? = null

    private var csvConfigQuote: Output<String>? = null

    private var format: Output<String>? = null

    private var jsonEnableTag: Output<Boolean>? = null

    private var logstoreName: Output<String>? = null

    private var ossBucket: Output<String>? = null

    private var ossPrefix: Output<String>? = null

    private var parquetConfigs: Output<List<OssShipperParquetConfigArgs>>? = null

    private var pathFormat: Output<String>? = null

    private var projectName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var shipperName: Output<String>? = null

    /**
     * @param value How often is it delivered every interval.
     */
    @JvmName("gwvpqwdnkaqlbous")
    public suspend fun bufferInterval(`value`: Output<Int>) {
        this.bufferInterval = value
    }

    /**
     * @param value Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
     */
    @JvmName("omsupnljdkktjgrk")
    public suspend fun bufferSize(`value`: Output<Int>) {
        this.bufferSize = value
    }

    /**
     * @param value OSS data storage compression method, support: none, snappy. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
     */
    @JvmName("hsygrgaaffryewro")
    public suspend fun compressType(`value`: Output<String>) {
        this.compressType = value
    }

    /**
     * @param value
     */
    @JvmName("cirixpbemmicykiw")
    public suspend fun csvConfigColumns(`value`: Output<List<String>>) {
        this.csvConfigColumns = value
    }

    @JvmName("xevmnpwkuejurdve")
    public suspend fun csvConfigColumns(vararg values: Output<String>) {
        this.csvConfigColumns = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("viinubmiucupabre")
    public suspend fun csvConfigColumns(values: List<Output<String>>) {
        this.csvConfigColumns = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cuqaybcfcggkemnj")
    public suspend fun csvConfigDelimiter(`value`: Output<String>) {
        this.csvConfigDelimiter = value
    }

    /**
     * @param value
     */
    @JvmName("vwkwbgkkebdehicm")
    public suspend fun csvConfigHeader(`value`: Output<Boolean>) {
        this.csvConfigHeader = value
    }

    /**
     * @param value
     */
    @JvmName("rebyspencukwkslk")
    public suspend fun csvConfigLinefeed(`value`: Output<String>) {
        this.csvConfigLinefeed = value
    }

    /**
     * @param value
     */
    @JvmName("rqfisevmbajxflul")
    public suspend fun csvConfigNullidentifier(`value`: Output<String>) {
        this.csvConfigNullidentifier = value
    }

    /**
     * @param value
     */
    @JvmName("wkfpgsyfixwkeamh")
    public suspend fun csvConfigQuote(`value`: Output<String>) {
        this.csvConfigQuote = value
    }

    /**
     * @param value Storage format, only supports three types: `json`, `parquet`, `csv`.
     * **According to the different format, please select the following parameters**
     * - format = `json`
     * `json_enable_tag` - (Optional) Whether to deliver the label.
     * - format = `csv`
     * `csv_config_delimiter` - (Optional) Separator configuration in csv configuration format.
     * `csv_config_columns` - (Optional) Field configuration in csv configuration format.
     * `csv_config_nullidentifier` - (Optional) Invalid field content.
     * `csv_config_quote` - (Optional) Escape character under csv configuration.
     * `csv_config_header` - (Optional) Indicates whether to write the field name to the CSV file, the default value is `false`.
     * `csv_config_linefeed` - (Optional) lineFeed in csv configuration.
     * - format = `parquet`
     * `parquet_config` - (Optional) Configure to use parquet storage format.
     * `name` - (Required) The name of the key.
     * `type` - (Required) Type of configuration name.
     */
    @JvmName("heemmlrfufnplgyo")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value
     */
    @JvmName("ohmioifjpjsiuteb")
    public suspend fun jsonEnableTag(`value`: Output<Boolean>) {
        this.jsonEnableTag = value
    }

    /**
     * @param value The name of the log logstore.
     */
    @JvmName("golxsgogkotlqpgy")
    public suspend fun logstoreName(`value`: Output<String>) {
        this.logstoreName = value
    }

    /**
     * @param value The name of the oss bucket.
     */
    @JvmName("phfnoywhyxmbdynh")
    public suspend fun ossBucket(`value`: Output<String>) {
        this.ossBucket = value
    }

    /**
     * @param value The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
     */
    @JvmName("stjhsbhlhkdvtwjo")
    public suspend fun ossPrefix(`value`: Output<String>) {
        this.ossPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("ktctrpptvncdrwio")
    public suspend fun parquetConfigs(`value`: Output<List<OssShipperParquetConfigArgs>>) {
        this.parquetConfigs = value
    }

    @JvmName("ncvsxrrvektuhkdd")
    public suspend fun parquetConfigs(vararg values: Output<OssShipperParquetConfigArgs>) {
        this.parquetConfigs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ejqubrnlfbgpybgf")
    public suspend fun parquetConfigs(values: List<Output<OssShipperParquetConfigArgs>>) {
        this.parquetConfigs = Output.all(values)
    }

    /**
     * @param value The OSS Bucket directory is dynamically generated according to the creation time of the shipper task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
     */
    @JvmName("hphngifyhhpdjnfy")
    public suspend fun pathFormat(`value`: Output<String>) {
        this.pathFormat = value
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("twixqlcboecdepmo")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Used for access control, the OSS Bucket owner creates the role mark, such as `acs:ram::13234:role/logrole`
     */
    @JvmName("lbfgetnjrsvqikua")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("engjlsbyinumngpl")
    public suspend fun shipperName(`value`: Output<String>) {
        this.shipperName = value
    }

    /**
     * @param value How often is it delivered every interval.
     */
    @JvmName("dchoeishrpbggyoj")
    public suspend fun bufferInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferInterval = mapped
    }

    /**
     * @param value Automatically control the creation interval of delivery tasks and set the upper limit of an OSS object size (calculated in uncompressed), unit: `MB`.
     */
    @JvmName("lwsascpqxkvggtra")
    public suspend fun bufferSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferSize = mapped
    }

    /**
     * @param value OSS data storage compression method, support: none, snappy. Among them, none means that the original data is not compressed, and snappy means that the data is compressed using the snappy algorithm, which can reduce the storage space usage of the `OSS Bucket`.
     */
    @JvmName("ichgqftnlrnetaxv")
    public suspend fun compressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressType = mapped
    }

    /**
     * @param value
     */
    @JvmName("jagcapkqtepjxqor")
    public suspend fun csvConfigColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigColumns = mapped
    }

    /**
     * @param values
     */
    @JvmName("qjucyvkmbhriphoc")
    public suspend fun csvConfigColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.csvConfigColumns = mapped
    }

    /**
     * @param value
     */
    @JvmName("nypoaiwimgygduco")
    public suspend fun csvConfigDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigDelimiter = mapped
    }

    /**
     * @param value
     */
    @JvmName("tlccyvkwumdngftw")
    public suspend fun csvConfigHeader(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigHeader = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktkafjfcplkpasoi")
    public suspend fun csvConfigLinefeed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigLinefeed = mapped
    }

    /**
     * @param value
     */
    @JvmName("wqmiwuvtitewnqgd")
    public suspend fun csvConfigNullidentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigNullidentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghubpspgfsgxqjmn")
    public suspend fun csvConfigQuote(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvConfigQuote = mapped
    }

    /**
     * @param value Storage format, only supports three types: `json`, `parquet`, `csv`.
     * **According to the different format, please select the following parameters**
     * - format = `json`
     * `json_enable_tag` - (Optional) Whether to deliver the label.
     * - format = `csv`
     * `csv_config_delimiter` - (Optional) Separator configuration in csv configuration format.
     * `csv_config_columns` - (Optional) Field configuration in csv configuration format.
     * `csv_config_nullidentifier` - (Optional) Invalid field content.
     * `csv_config_quote` - (Optional) Escape character under csv configuration.
     * `csv_config_header` - (Optional) Indicates whether to write the field name to the CSV file, the default value is `false`.
     * `csv_config_linefeed` - (Optional) lineFeed in csv configuration.
     * - format = `parquet`
     * `parquet_config` - (Optional) Configure to use parquet storage format.
     * `name` - (Required) The name of the key.
     * `type` - (Required) Type of configuration name.
     */
    @JvmName("ujfwvfrakwbdunqb")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value
     */
    @JvmName("tamyhfgqscrecnxh")
    public suspend fun jsonEnableTag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonEnableTag = mapped
    }

    /**
     * @param value The name of the log logstore.
     */
    @JvmName("kuailmrtscbnwyjf")
    public suspend fun logstoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstoreName = mapped
    }

    /**
     * @param value The name of the oss bucket.
     */
    @JvmName("argundgbtdmhguas")
    public suspend fun ossBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucket = mapped
    }

    /**
     * @param value The data synchronized from Log Service to OSS will be stored in this directory of Bucket.
     */
    @JvmName("pfmbecolakipagnr")
    public suspend fun ossPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("oyxhqorvpsmubefj")
    public suspend fun parquetConfigs(`value`: List<OssShipperParquetConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parquetConfigs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kdetdauukcpxkren")
    public suspend fun parquetConfigs(argument: List<suspend OssShipperParquetConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OssShipperParquetConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parquetConfigs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kfqfwfinqkawttjd")
    public suspend fun parquetConfigs(vararg argument: suspend OssShipperParquetConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OssShipperParquetConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parquetConfigs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eavojiajqqmukqfh")
    public suspend fun parquetConfigs(argument: suspend OssShipperParquetConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OssShipperParquetConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parquetConfigs = mapped
    }

    /**
     * @param values
     */
    @JvmName("rduxnvlhjkhvwmpm")
    public suspend fun parquetConfigs(vararg values: OssShipperParquetConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parquetConfigs = mapped
    }

    /**
     * @param value The OSS Bucket directory is dynamically generated according to the creation time of the shipper task, it cannot start with a forward slash `/`, the default value is `%Y/%m/%d/%H/%M`.
     */
    @JvmName("dpuvkfnlulytnphm")
    public suspend fun pathFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathFormat = mapped
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account.
     */
    @JvmName("ltaxiopmtidasjaf")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Used for access control, the OSS Bucket owner creates the role mark, such as `acs:ram::13234:role/logrole`
     */
    @JvmName("xilxqgyxorqmmagg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Delivery configuration name, it can only contain lowercase letters, numbers, dashes `-` and underscores `_`. It must start and end with lowercase letters or numbers, and the name must be 2 to 128 characters long.
     */
    @JvmName("nchwgpvgtnsgwrqq")
    public suspend fun shipperName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shipperName = mapped
    }

    internal fun build(): OssShipperArgs = OssShipperArgs(
        bufferInterval = bufferInterval,
        bufferSize = bufferSize,
        compressType = compressType,
        csvConfigColumns = csvConfigColumns,
        csvConfigDelimiter = csvConfigDelimiter,
        csvConfigHeader = csvConfigHeader,
        csvConfigLinefeed = csvConfigLinefeed,
        csvConfigNullidentifier = csvConfigNullidentifier,
        csvConfigQuote = csvConfigQuote,
        format = format,
        jsonEnableTag = jsonEnableTag,
        logstoreName = logstoreName,
        ossBucket = ossBucket,
        ossPrefix = ossPrefix,
        parquetConfigs = parquetConfigs,
        pathFormat = pathFormat,
        projectName = projectName,
        roleArn = roleArn,
        shipperName = shipperName,
    )
}
