@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SLS Project resource.
 * For information about SLS Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/sls/developer-reference/api-createproject).
 * > **NOTE:** Available since v1.9.5.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       tags:
 *         Created: TF
 *         For: example
 * ```
 * <!--End PulumiCodeChooser -->
 * Project With Policy Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const examplePolicy = new alicloud.log.Project("example_policy", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 *     policy: `{
 *   "Statement": [
 *     {
 *       "Action": [
 *         "log:PostLogStoreLogs"
 *       ],
 *       "Condition": {
 *         "StringNotLike": {
 *           "acs:SourceVpc": [
 *             "vpc-*"
 *           ]
 *         }
 *       },
 *       "Effect": "Deny",
 *       "Resource": "acs:log:*:*:project/tf-log/*"
 *     }
 *   ],
 *   "Version": "1"
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example_policy = alicloud.log.Project("example_policy",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example",
 *     policy="""{
 *   "Statement": [
 *     {
 *       "Action": [
 *         "log:PostLogStoreLogs"
 *       ],
 *       "Condition": {
 *         "StringNotLike": {
 *           "acs:SourceVpc": [
 *             "vpc-*"
 *           ]
 *         }
 *       },
 *       "Effect": "Deny",
 *       "Resource": "acs:log:*:*:project/tf-log/*"
 *     }
 *   ],
 *   "Version": "1"
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var examplePolicy = new AliCloud.Log.Project("example_policy", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *         Policy = @"{
 *   ""Statement"": [
 *     {
 *       ""Action"": [
 *         ""log:PostLogStoreLogs""
 *       ],
 *       ""Condition"": {
 *         ""StringNotLike"": {
 *           ""acs:SourceVpc"": [
 *             ""vpc-*""
 *           ]
 *         }
 *       },
 *       ""Effect"": ""Deny"",
 *       ""Resource"": ""acs:log:*:*:project/tf-log/*""
 *     }
 *   ],
 *   ""Version"": ""1""
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewProject(ctx, "example_policy", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			Policy: pulumi.String(`{
 *   "Statement": [
 *     {
 *       "Action": [
 *         "log:PostLogStoreLogs"
 *       ],
 *       "Condition": {
 *         "StringNotLike": {
 *           "acs:SourceVpc": [
 *             "vpc-*"
 *           ]
 *         }
 *       },
 *       "Effect": "Deny",
 *       "Resource": "acs:log:*:*:project/tf-log/*"
 *     }
 *   ],
 *   "Version": "1"
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var examplePolicy = new Project("examplePolicy", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .policy("""
 * {
 *   "Statement": [
 *     {
 *       "Action": [
 *         "log:PostLogStoreLogs"
 *       ],
 *       "Condition": {
 *         "StringNotLike": {
 *           "acs:SourceVpc": [
 *             "vpc-*"
 *           ]
 *         }
 *       },
 *       "Effect": "Deny",
 *       "Resource": "acs:log:*:*:project/tf-log/*"
 *     }
 *   ],
 *   "Version": "1"
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   examplePolicy:
 *     type: alicloud:log:Project
 *     name: example_policy
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *       policy: |
 *         {
 *           "Statement": [
 *             {
 *               "Action": [
 *                 "log:PostLogStoreLogs"
 *               ],
 *               "Condition": {
 *                 "StringNotLike": {
 *                   "acs:SourceVpc": [
 *                     "vpc-*"
 *                   ]
 *                 }
 *               },
 *               "Effect": "Deny",
 *               "Resource": "acs:log:*:*:project/tf-log/*"
 *             }
 *           ],
 *           "Version": "1"
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls module
 * to create SLS project, store and store index one-click, like ECS instances.
 * ## Import
 * SLS Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/project:Project example <id>
 * ```
 * @property description Description.
 * @property name . Field 'name' has been deprecated from provider version 1.223.0. New field 'project_name' instead.
 * @property policy Log project policy, used to set a policy for a project.
 * @property projectName The name of the log project. It is the only in one Alicloud account. The project name is globally unique in Alibaba Cloud and cannot be modified after it is created. The naming rules are as follows:
 * - The project name must be globally unique.
 * - The name can contain only lowercase letters, digits, and hyphens (-).
 * - It must start and end with a lowercase letter or number.
 * - The value contains 3 to 63 characters.
 * @property resourceGroupId The ID of the resource group.
 * @property tags Tag.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 * */*/*/*/*/*/
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.223.0. New field 'project_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.ProjectArgs> {
    override fun toJava(): com.pulumi.alicloud.log.ProjectArgs =
        com.pulumi.alicloud.log.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description.
     */
    @JvmName("qfvniyvlmgjfrymx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.223.0. New field 'project_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.223.0. New field 'project_name' instead.
  """,
    )
    @JvmName("ovvqwcnfybluxjpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Log project policy, used to set a policy for a project.
     */
    @JvmName("qjotqrqhgasouqbn")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account. The project name is globally unique in Alibaba Cloud and cannot be modified after it is created. The naming rules are as follows:
     * - The project name must be globally unique.
     * - The name can contain only lowercase letters, digits, and hyphens (-).
     * - It must start and end with a lowercase letter or number.
     * - The value contains 3 to 63 characters.
     */
    @JvmName("gtyydghpthysoowd")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("gagfnxyfspeyvqwe")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("vwvwpsntphrljkjp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description.
     */
    @JvmName("nbxjyahyvuhutnkf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.223.0. New field 'project_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.223.0. New field 'project_name' instead.
  """,
    )
    @JvmName("vmejuyqlrgrmmhbx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Log project policy, used to set a policy for a project.
     */
    @JvmName("ekltpimnfnkfjoly")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The name of the log project. It is the only in one Alicloud account. The project name is globally unique in Alibaba Cloud and cannot be modified after it is created. The naming rules are as follows:
     * - The project name must be globally unique.
     * - The name can contain only lowercase letters, digits, and hyphens (-).
     * - It must start and end with a lowercase letter or number.
     * - The value contains 3 to 63 characters.
     */
    @JvmName("qpmfnedoxqbbkgva")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ptvdlgwrbswwkien")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("pfupenxathlkvuot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("elmnpnlnxsanhyho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        name = name,
        policy = policy,
        projectName = projectName,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
