@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Resource].
 */
@PulumiTagMarker
public class ResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceArgs = ResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceArgsBuilder.() -> Unit) {
        val builder = ResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Resource {
        val builtJavaResource = com.pulumi.alicloud.log.Resource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resource(builtJavaResource)
    }
}

/**
 * Log resource is a meta store service provided by log service, resource can be used to define meta store's table structure.
 * For information about SLS Resource and how to use it, see [Resource management](https://www.alibabacloud.com/help/en/doc-detail/207732.html)
 * > **NOTE:** Available since v1.162.0. log resource region should be set a main region: cn-heyuan.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.log.Resource("example", {
 *     type: "userdefine",
 *     name: "user.tf.resource",
 *     description: "user tf resource desc",
 *     extInfo: "{}",
 *     schema: `    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.log.Resource("example",
 *     type="userdefine",
 *     name="user.tf.resource",
 *     description="user tf resource desc",
 *     ext_info="{}",
 *     schema="""    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Log.Resource("example", new()
 *     {
 *         Type = "userdefine",
 *         Name = "user.tf.resource",
 *         Description = "user tf resource desc",
 *         ExtInfo = "{}",
 *         Schema = @"    {
 *       ""schema"": [
 *         {
 *           ""column"": ""col1"",
 *           ""desc"": ""col1   desc"",
 *           ""ext_info"": {
 *           },
 *           ""required"": true,
 *           ""type"": ""string""
 *         },
 *         {
 *           ""column"": ""col2"",
 *           ""desc"": ""col2   desc"",
 *           ""ext_info"": ""optional"",
 *           ""required"": true,
 *           ""type"": ""string""
 *         }
 *       ]
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := log.NewResource(ctx, "example", &log.ResourceArgs{
 * 			Type:        pulumi.String("userdefine"),
 * 			Name:        pulumi.String("user.tf.resource"),
 * 			Description: pulumi.String("user tf resource desc"),
 * 			ExtInfo:     pulumi.String("{}"),
 * 			Schema: pulumi.String(`    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.Resource;
 * import com.pulumi.alicloud.log.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resource("example", ResourceArgs.builder()
 *             .type("userdefine")
 *             .name("user.tf.resource")
 *             .description("user tf resource desc")
 *             .extInfo("{}")
 *             .schema("""
 *     {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:log:Resource
 *     properties:
 *       type: userdefine
 *       name: user.tf.resource
 *       description: user tf resource desc
 *       extInfo: '{}'
 *       schema: |2
 *             {
 *               "schema": [
 *                 {
 *                   "column": "col1",
 *                   "desc": "col1   desc",
 *                   "ext_info": {
 *                   },
 *                   "required": true,
 *                   "type": "string"
 *                 },
 *                 {
 *                   "column": "col2",
 *                   "desc": "col2   desc",
 *                   "ext_info": "optional",
 *                   "required": true,
 *                   "type": "string"
 *                 }
 *               ]
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/resource:Resource example <id>
 * ```
 */
public class Resource internal constructor(
    override val javaResource: com.pulumi.alicloud.log.Resource,
) : KotlinCustomResource(javaResource, ResourceMapper) {
    /**
     * The meta store's description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ext info of meta store.
     */
    public val extInfo: Output<String>?
        get() = javaResource.extInfo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The meta store's name, can be used as table name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The meta store's schema info, which is json string format, used to define table's fields.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })

    /**
     * The meta store's type, userdefine e.g.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceMapper : ResourceMapper<Resource> {
    override fun supportsMappingOfType(javaResource: com.pulumi.resources.Resource): Boolean =
        com.pulumi.alicloud.log.Resource::class == javaResource::class

    override fun map(javaResource: com.pulumi.resources.Resource): Resource = Resource(
        javaResource as
            com.pulumi.alicloud.log.Resource,
    )
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resource].
 */
public suspend fun resource(name: String, block: suspend ResourceResourceBuilder.() -> Unit): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resource(name: String): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
