@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log resource is a meta store service provided by log service, resource can be used to define meta store's table structure.
 * For information about SLS Resource and how to use it, see [Resource management](https://www.alibabacloud.com/help/en/doc-detail/207732.html)
 * > **NOTE:** Available since v1.162.0. log resource region should be set a main region: cn-heyuan.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.log.Resource("example", {
 *     type: "userdefine",
 *     name: "user.tf.resource",
 *     description: "user tf resource desc",
 *     extInfo: "{}",
 *     schema: `    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.log.Resource("example",
 *     type="userdefine",
 *     name="user.tf.resource",
 *     description="user tf resource desc",
 *     ext_info="{}",
 *     schema="""    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Log.Resource("example", new()
 *     {
 *         Type = "userdefine",
 *         Name = "user.tf.resource",
 *         Description = "user tf resource desc",
 *         ExtInfo = "{}",
 *         Schema = @"    {
 *       ""schema"": [
 *         {
 *           ""column"": ""col1"",
 *           ""desc"": ""col1   desc"",
 *           ""ext_info"": {
 *           },
 *           ""required"": true,
 *           ""type"": ""string""
 *         },
 *         {
 *           ""column"": ""col2"",
 *           ""desc"": ""col2   desc"",
 *           ""ext_info"": ""optional"",
 *           ""required"": true,
 *           ""type"": ""string""
 *         }
 *       ]
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := log.NewResource(ctx, "example", &log.ResourceArgs{
 * 			Type:        pulumi.String("userdefine"),
 * 			Name:        pulumi.String("user.tf.resource"),
 * 			Description: pulumi.String("user tf resource desc"),
 * 			ExtInfo:     pulumi.String("{}"),
 * 			Schema: pulumi.String(`    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.Resource;
 * import com.pulumi.alicloud.log.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resource("example", ResourceArgs.builder()
 *             .type("userdefine")
 *             .name("user.tf.resource")
 *             .description("user tf resource desc")
 *             .extInfo("{}")
 *             .schema("""
 *     {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:log:Resource
 *     properties:
 *       type: userdefine
 *       name: user.tf.resource
 *       description: user tf resource desc
 *       extInfo: '{}'
 *       schema: |2
 *             {
 *               "schema": [
 *                 {
 *                   "column": "col1",
 *                   "desc": "col1   desc",
 *                   "ext_info": {
 *                   },
 *                   "required": true,
 *                   "type": "string"
 *                 },
 *                 {
 *                   "column": "col2",
 *                   "desc": "col2   desc",
 *                   "ext_info": "optional",
 *                   "required": true,
 *                   "type": "string"
 *                 }
 *               ]
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log resource can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/resource:Resource example <id>
 * ```
 * @property description The meta store's description.
 * @property extInfo The ext info of meta store.
 * @property name The meta store's name, can be used as table name.
 * @property schema The meta store's schema info, which is json string format, used to define table's fields.
 * @property type The meta store's type, userdefine e.g.
 */
public data class ResourceArgs(
    public val description: Output<String>? = null,
    public val extInfo: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schema: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.ResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.log.ResourceArgs =
        com.pulumi.alicloud.log.ResourceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .extInfo(extInfo?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var extInfo: Output<String>? = null

    private var name: Output<String>? = null

    private var schema: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The meta store's description.
     */
    @JvmName("jvbaalmpkxuvxbav")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ext info of meta store.
     */
    @JvmName("unfijyqoigvujpug")
    public suspend fun extInfo(`value`: Output<String>) {
        this.extInfo = value
    }

    /**
     * @param value The meta store's name, can be used as table name.
     */
    @JvmName("xktpihljvmhwvcha")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The meta store's schema info, which is json string format, used to define table's fields.
     */
    @JvmName("wymudgwwvntxtmww")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value The meta store's type, userdefine e.g.
     */
    @JvmName("eedqnigoobjsriow")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The meta store's description.
     */
    @JvmName("gvbypfoctdfclriy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ext info of meta store.
     */
    @JvmName("jhsaiyrkgbxgsctp")
    public suspend fun extInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extInfo = mapped
    }

    /**
     * @param value The meta store's name, can be used as table name.
     */
    @JvmName("tmwkcwspelcyginq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The meta store's schema info, which is json string format, used to define table's fields.
     */
    @JvmName("legmgmhbwwcukfke")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value The meta store's type, userdefine e.g.
     */
    @JvmName("tayccdwxsismwpsi")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        description = description,
        extInfo = extInfo,
        name = name,
        schema = schema,
        type = type,
    )
}
