@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourceRecord].
 */
@PulumiTagMarker
public class ResourceRecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceRecordArgs = ResourceRecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceRecordArgsBuilder.() -> Unit) {
        val builder = ResourceRecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceRecord {
        val builtJavaResource = com.pulumi.alicloud.log.ResourceRecord(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceRecord(builtJavaResource)
    }
}

/**
 * Log resource is a meta store service provided by log service, resource can be used to define meta store's table structure, record can be used for table's row data.
 * For information about SLS Resource and how to use it, see [Resource management](https://www.alibabacloud.com/help/en/doc-detail/207732.html)
 * > **NOTE:** Available since v1.162.0. log resource region should be set a main region: cn-heyuan.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.log.Resource("example", {
 *     type: "userdefine",
 *     name: "user.tf.resource",
 *     description: "user tf resource desc",
 *     extInfo: "{}",
 *     schema: `    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `,
 * });
 * const exampleResourceRecord = new alicloud.log.ResourceRecord("example", {
 *     resourceName: example.id,
 *     recordId: "user_tf_resource_1",
 *     tag: "resource tag",
 *     value: `    {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.log.Resource("example",
 *     type="userdefine",
 *     name="user.tf.resource",
 *     description="user tf resource desc",
 *     ext_info="{}",
 *     schema="""    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * """)
 * example_resource_record = alicloud.log.ResourceRecord("example",
 *     resource_name_=example.id,
 *     record_id="user_tf_resource_1",
 *     tag="resource tag",
 *     value="""    {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Log.Resource("example", new()
 *     {
 *         Type = "userdefine",
 *         Name = "user.tf.resource",
 *         Description = "user tf resource desc",
 *         ExtInfo = "{}",
 *         Schema = @"    {
 *       ""schema"": [
 *         {
 *           ""column"": ""col1"",
 *           ""desc"": ""col1   desc"",
 *           ""ext_info"": {
 *           },
 *           ""required"": true,
 *           ""type"": ""string""
 *         },
 *         {
 *           ""column"": ""col2"",
 *           ""desc"": ""col2   desc"",
 *           ""ext_info"": ""optional"",
 *           ""required"": true,
 *           ""type"": ""string""
 *         }
 *       ]
 *     }
 * ",
 *     });
 *     var exampleResourceRecord = new AliCloud.Log.ResourceRecord("example", new()
 *     {
 *         ResourceName = example.Id,
 *         RecordId = "user_tf_resource_1",
 *         Tag = "resource tag",
 *         Value = @"    {
 *       ""col1"": ""this is col1 value"",
 *       ""col2"": ""col2   value""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := log.NewResource(ctx, "example", &log.ResourceArgs{
 * 			Type:        pulumi.String("userdefine"),
 * 			Name:        pulumi.String("user.tf.resource"),
 * 			Description: pulumi.String("user tf resource desc"),
 * 			ExtInfo:     pulumi.String("{}"),
 * 			Schema: pulumi.String(`    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewResourceRecord(ctx, "example", &log.ResourceRecordArgs{
 * 			ResourceName: example.ID(),
 * 			RecordId:     pulumi.String("user_tf_resource_1"),
 * 			Tag:          pulumi.String("resource tag"),
 * 			Value:        pulumi.String("    {\n      \"col1\": \"this is col1 value\",\n      \"col2\": \"col2   value\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.Resource;
 * import com.pulumi.alicloud.log.ResourceArgs;
 * import com.pulumi.alicloud.log.ResourceRecord;
 * import com.pulumi.alicloud.log.ResourceRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resource("example", ResourceArgs.builder()
 *             .type("userdefine")
 *             .name("user.tf.resource")
 *             .description("user tf resource desc")
 *             .extInfo("{}")
 *             .schema("""
 *     {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 *             """)
 *             .build());
 *         var exampleResourceRecord = new ResourceRecord("exampleResourceRecord", ResourceRecordArgs.builder()
 *             .resourceName(example.id())
 *             .recordId("user_tf_resource_1")
 *             .tag("resource tag")
 *             .value("""
 *     {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:log:Resource
 *     properties:
 *       type: userdefine
 *       name: user.tf.resource
 *       description: user tf resource desc
 *       extInfo: '{}'
 *       schema: |2
 *             {
 *               "schema": [
 *                 {
 *                   "column": "col1",
 *                   "desc": "col1   desc",
 *                   "ext_info": {
 *                   },
 *                   "required": true,
 *                   "type": "string"
 *                 },
 *                 {
 *                   "column": "col2",
 *                   "desc": "col2   desc",
 *                   "ext_info": "optional",
 *                   "required": true,
 *                   "type": "string"
 *                 }
 *               ]
 *             }
 *   exampleResourceRecord:
 *     type: alicloud:log:ResourceRecord
 *     name: example
 *     properties:
 *       resourceName: ${example.id}
 *       recordId: user_tf_resource_1
 *       tag: resource tag
 *       value: |2
 *             {
 *               "col1": "this is col1 value",
 *               "col2": "col2   value"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log resource record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/resourceRecord:ResourceRecord example <resource_name>:<record_id>
 * ```
 */
public class ResourceRecord internal constructor(
    override val javaResource: com.pulumi.alicloud.log.ResourceRecord,
) : KotlinCustomResource(javaResource, ResourceRecordMapper) {
    /**
     * The record's id, should be unique.
     */
    public val recordId: Output<String>
        get() = javaResource.recordId().applyValue({ args0 -> args0 })

    /**
     * The name defined in log_resource, log service have some internal resource, like sls.common.user, sls.common.user_group.
     */
    public val resourceName: Output<String>
        get() = javaResource.resourceName().applyValue({ args0 -> args0 })

    /**
     * The record's tag, can be used for search.
     */
    public val tag: Output<String>
        get() = javaResource.tag().applyValue({ args0 -> args0 })

    /**
     * The json value of record.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ResourceRecordMapper : ResourceMapper<ResourceRecord> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.log.ResourceRecord::class == javaResource::class

    override fun map(javaResource: Resource): ResourceRecord = ResourceRecord(
        javaResource as
            com.pulumi.alicloud.log.ResourceRecord,
    )
}

/**
 * @see [ResourceRecord].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceRecord].
 */
public suspend fun resourceRecord(
    name: String,
    block: suspend ResourceRecordResourceBuilder.() -> Unit,
): ResourceRecord {
    val builder = ResourceRecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceRecord].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceRecord(name: String): ResourceRecord {
    val builder = ResourceRecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
