@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.ResourceRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log resource is a meta store service provided by log service, resource can be used to define meta store's table structure, record can be used for table's row data.
 * For information about SLS Resource and how to use it, see [Resource management](https://www.alibabacloud.com/help/en/doc-detail/207732.html)
 * > **NOTE:** Available since v1.162.0. log resource region should be set a main region: cn-heyuan.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.log.Resource("example", {
 *     type: "userdefine",
 *     name: "user.tf.resource",
 *     description: "user tf resource desc",
 *     extInfo: "{}",
 *     schema: `    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `,
 * });
 * const exampleResourceRecord = new alicloud.log.ResourceRecord("example", {
 *     resourceName: example.id,
 *     recordId: "user_tf_resource_1",
 *     tag: "resource tag",
 *     value: `    {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.log.Resource("example",
 *     type="userdefine",
 *     name="user.tf.resource",
 *     description="user tf resource desc",
 *     ext_info="{}",
 *     schema="""    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * """)
 * example_resource_record = alicloud.log.ResourceRecord("example",
 *     resource_name_=example.id,
 *     record_id="user_tf_resource_1",
 *     tag="resource tag",
 *     value="""    {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Log.Resource("example", new()
 *     {
 *         Type = "userdefine",
 *         Name = "user.tf.resource",
 *         Description = "user tf resource desc",
 *         ExtInfo = "{}",
 *         Schema = @"    {
 *       ""schema"": [
 *         {
 *           ""column"": ""col1"",
 *           ""desc"": ""col1   desc"",
 *           ""ext_info"": {
 *           },
 *           ""required"": true,
 *           ""type"": ""string""
 *         },
 *         {
 *           ""column"": ""col2"",
 *           ""desc"": ""col2   desc"",
 *           ""ext_info"": ""optional"",
 *           ""required"": true,
 *           ""type"": ""string""
 *         }
 *       ]
 *     }
 * ",
 *     });
 *     var exampleResourceRecord = new AliCloud.Log.ResourceRecord("example", new()
 *     {
 *         ResourceName = example.Id,
 *         RecordId = "user_tf_resource_1",
 *         Tag = "resource tag",
 *         Value = @"    {
 *       ""col1"": ""this is col1 value"",
 *       ""col2"": ""col2   value""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := log.NewResource(ctx, "example", &log.ResourceArgs{
 * 			Type:        pulumi.String("userdefine"),
 * 			Name:        pulumi.String("user.tf.resource"),
 * 			Description: pulumi.String("user tf resource desc"),
 * 			ExtInfo:     pulumi.String("{}"),
 * 			Schema: pulumi.String(`    {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewResourceRecord(ctx, "example", &log.ResourceRecordArgs{
 * 			ResourceName: example.ID(),
 * 			RecordId:     pulumi.String("user_tf_resource_1"),
 * 			Tag:          pulumi.String("resource tag"),
 * 			Value:        pulumi.String("    {\n      \"col1\": \"this is col1 value\",\n      \"col2\": \"col2   value\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.log.Resource;
 * import com.pulumi.alicloud.log.ResourceArgs;
 * import com.pulumi.alicloud.log.ResourceRecord;
 * import com.pulumi.alicloud.log.ResourceRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resource("example", ResourceArgs.builder()
 *             .type("userdefine")
 *             .name("user.tf.resource")
 *             .description("user tf resource desc")
 *             .extInfo("{}")
 *             .schema("""
 *     {
 *       "schema": [
 *         {
 *           "column": "col1",
 *           "desc": "col1   desc",
 *           "ext_info": {
 *           },
 *           "required": true,
 *           "type": "string"
 *         },
 *         {
 *           "column": "col2",
 *           "desc": "col2   desc",
 *           "ext_info": "optional",
 *           "required": true,
 *           "type": "string"
 *         }
 *       ]
 *     }
 *             """)
 *             .build());
 *         var exampleResourceRecord = new ResourceRecord("exampleResourceRecord", ResourceRecordArgs.builder()
 *             .resourceName(example.id())
 *             .recordId("user_tf_resource_1")
 *             .tag("resource tag")
 *             .value("""
 *     {
 *       "col1": "this is col1 value",
 *       "col2": "col2   value"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:log:Resource
 *     properties:
 *       type: userdefine
 *       name: user.tf.resource
 *       description: user tf resource desc
 *       extInfo: '{}'
 *       schema: |2
 *             {
 *               "schema": [
 *                 {
 *                   "column": "col1",
 *                   "desc": "col1   desc",
 *                   "ext_info": {
 *                   },
 *                   "required": true,
 *                   "type": "string"
 *                 },
 *                 {
 *                   "column": "col2",
 *                   "desc": "col2   desc",
 *                   "ext_info": "optional",
 *                   "required": true,
 *                   "type": "string"
 *                 }
 *               ]
 *             }
 *   exampleResourceRecord:
 *     type: alicloud:log:ResourceRecord
 *     name: example
 *     properties:
 *       resourceName: ${example.id}
 *       recordId: user_tf_resource_1
 *       tag: resource tag
 *       value: |2
 *             {
 *               "col1": "this is col1 value",
 *               "col2": "col2   value"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Log resource record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/resourceRecord:ResourceRecord example <resource_name>:<record_id>
 * ```
 * @property recordId The record's id, should be unique.
 * @property resourceName The name defined in log_resource, log service have some internal resource, like sls.common.user, sls.common.user_group.
 * @property tag The record's tag, can be used for search.
 * @property value The json value of record.
 */
public data class ResourceRecordArgs(
    public val recordId: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tag: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.ResourceRecordArgs> {
    override fun toJava(): com.pulumi.alicloud.log.ResourceRecordArgs =
        com.pulumi.alicloud.log.ResourceRecordArgs.builder()
            .recordId(recordId?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRecordArgs].
 */
@PulumiTagMarker
public class ResourceRecordArgsBuilder internal constructor() {
    private var recordId: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tag: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The record's id, should be unique.
     */
    @JvmName("drqpqykyxasqsyur")
    public suspend fun recordId(`value`: Output<String>) {
        this.recordId = value
    }

    /**
     * @param value The name defined in log_resource, log service have some internal resource, like sls.common.user, sls.common.user_group.
     */
    @JvmName("sghovtypgubxerwh")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The record's tag, can be used for search.
     */
    @JvmName("udckmcyompfgyikx")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The json value of record.
     */
    @JvmName("mkifbnmpdhmovgbr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The record's id, should be unique.
     */
    @JvmName("xhyldhrqnxvgwaft")
    public suspend fun recordId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordId = mapped
    }

    /**
     * @param value The name defined in log_resource, log service have some internal resource, like sls.common.user, sls.common.user_group.
     */
    @JvmName("krwhnlfkmarqwaso")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The record's tag, can be used for search.
     */
    @JvmName("rukmvyhoyujlwnfi")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value The json value of record.
     */
    @JvmName("hduhxbetvcancpdo")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ResourceRecordArgs = ResourceRecordArgs(
        recordId = recordId,
        resourceName = resourceName,
        tag = tag,
        `value` = `value`,
    )
}
