@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin

import com.pulumi.alicloud.log.StoreIndexArgs.builder
import com.pulumi.alicloud.log.kotlin.inputs.StoreIndexFieldSearchArgs
import com.pulumi.alicloud.log.kotlin.inputs.StoreIndexFieldSearchArgsBuilder
import com.pulumi.alicloud.log.kotlin.inputs.StoreIndexFullTextArgs
import com.pulumi.alicloud.log.kotlin.inputs.StoreIndexFullTextArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log Service provides the LogSearch/Analytics function to query and analyze large amounts of logs in real time.
 * You can use this function by enabling the index and field statistics. [Refer to details](https://www.alibabacloud.com/help/doc-detail/43772.htm)
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.log.Project("example", {
 *     name: `terraform-example-${_default.result}`,
 *     description: "terraform-example",
 * });
 * const exampleStore = new alicloud.log.Store("example", {
 *     project: example.name,
 *     name: "example-store",
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const exampleStoreIndex = new alicloud.log.StoreIndex("example", {
 *     project: example.name,
 *     logstore: exampleStore.name,
 *     fullText: {
 *         caseSensitive: true,
 *         token: ` #^*\x0d
 * \x09`,
 *     },
 *     fieldSearches: [{
 *         name: "terraform-example",
 *         enableAnalytics: true,
 *         type: "text",
 *         token: ` #^*\x0d
 * \x09`,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.log.Project("example",
 *     name=f"terraform-example-{default['result']}",
 *     description="terraform-example")
 * example_store = alicloud.log.Store("example",
 *     project=example.name,
 *     name="example-store",
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * example_store_index = alicloud.log.StoreIndex("example",
 *     project=example.name,
 *     logstore=example_store.name,
 *     full_text={
 *         "case_sensitive": True,
 *         "token": """ #$^*\x0d
 * \x09""",
 *     },
 *     field_searches=[{
 *         "name": "terraform-example",
 *         "enable_analytics": True,
 *         "type": "text",
 *         "token": """ #$^*\x0d
 * \x09""",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Log.Project("example", new()
 *     {
 *         Name = $"terraform-example-{@default.Result}",
 *         Description = "terraform-example",
 *     });
 *     var exampleStore = new AliCloud.Log.Store("example", new()
 *     {
 *         Project = example.Name,
 *         Name = "example-store",
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var exampleStoreIndex = new AliCloud.Log.StoreIndex("example", new()
 *     {
 *         Project = example.Name,
 *         Logstore = exampleStore.Name,
 *         FullText = new AliCloud.Log.Inputs.StoreIndexFullTextArgs
 *         {
 *             CaseSensitive = true,
 *             Token = @" #$^*
 * 	",
 *         },
 *         FieldSearches = new[]
 *         {
 *             new AliCloud.Log.Inputs.StoreIndexFieldSearchArgs
 *             {
 *                 Name = "terraform-example",
 *                 EnableAnalytics = true,
 *                 Type = "text",
 *                 Token = @" #$^*
 * 	",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			Name:        pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleStore, err := log.NewStore(ctx, "example", &log.StoreArgs{
 * 			Project:            example.Name,
 * 			Name:               pulumi.String("example-store"),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = log.NewStoreIndex(ctx, "example", &log.StoreIndexArgs{
 * 			Project:  example.Name,
 * 			Logstore: exampleStore.Name,
 * 			FullText: &log.StoreIndexFullTextArgs{
 * 				CaseSensitive: pulumi.Bool(true),
 * 				Token:         pulumi.String(" #$^*
\n	"),
 * 			},
 * 			FieldSearches: log.StoreIndexFieldSearchArray{
 * 				&log.StoreIndexFieldSearchArgs{
 * 					Name:            pulumi.String("terraform-example"),
 * 					EnableAnalytics: pulumi.Bool(true),
 * 					Type:            pulumi.String("text"),
 * 					Token:           pulumi.String(" #$^*
\n	"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.log.StoreIndex;
 * import com.pulumi.alicloud.log.StoreIndexArgs;
 * import com.pulumi.alicloud.log.inputs.StoreIndexFullTextArgs;
 * import com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name(String.format("terraform-example-%s", default_.result()))
 *             .description("terraform-example")
 *             .build());
 *         var exampleStore = new Store("exampleStore", StoreArgs.builder()
 *             .project(example.name())
 *             .name("example-store")
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var exampleStoreIndex = new StoreIndex("exampleStoreIndex", StoreIndexArgs.builder()
 *             .project(example.name())
 *             .logstore(exampleStore.name())
 *             .fullText(StoreIndexFullTextArgs.builder()
 *                 .caseSensitive(true)
 *                 .token("""
 *  #$^*
 * 	                """)
 *                 .build())
 *             .fieldSearches(StoreIndexFieldSearchArgs.builder()
 *                 .name("terraform-example")
 *                 .enableAnalytics(true)
 *                 .type("text")
 *                 .token("""
 *  #$^*
 * 	                """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:log:Project
 *     properties:
 *       name: terraform-example-${default.result}
 *       description: terraform-example
 *   exampleStore:
 *     type: alicloud:log:Store
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       name: example-store
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   exampleStoreIndex:
 *     type: alicloud:log:StoreIndex
 *     name: example
 *     properties:
 *       project: ${example.name}
 *       logstore: ${exampleStore.name}
 *       fullText:
 *         caseSensitive: true
 *         token: " #$^*\r\n\t"
 *       fieldSearches:
 *         - name: terraform-example
 *           enableAnalytics: true
 *           type: text
 *           token: " #$^*\r\n\t"
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use the existing sls module
 * to create SLS project, store and store index one-click, like ECS instances.
 * ## Import
 * Log store index can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:log/storeIndex:StoreIndex example tf-log:tf-log-store
 * ```
 * @property fieldSearches List configurations of field search index. Valid item as follows:
 * @property fullText The configuration of full text index. Valid item as follows:
 * @property logstore The log store name to the query index belongs.
 * @property project The project name to the log store belongs.
 */
public data class StoreIndexArgs(
    public val fieldSearches: Output<List<StoreIndexFieldSearchArgs>>? = null,
    public val fullText: Output<StoreIndexFullTextArgs>? = null,
    public val logstore: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.StoreIndexArgs> {
    override fun toJava(): com.pulumi.alicloud.log.StoreIndexArgs =
        com.pulumi.alicloud.log.StoreIndexArgs.builder()
            .fieldSearches(
                fieldSearches?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fullText(fullText?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoreIndexArgs].
 */
@PulumiTagMarker
public class StoreIndexArgsBuilder internal constructor() {
    private var fieldSearches: Output<List<StoreIndexFieldSearchArgs>>? = null

    private var fullText: Output<StoreIndexFullTextArgs>? = null

    private var logstore: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value List configurations of field search index. Valid item as follows:
     */
    @JvmName("rdhapfgnbeadmuff")
    public suspend fun fieldSearches(`value`: Output<List<StoreIndexFieldSearchArgs>>) {
        this.fieldSearches = value
    }

    @JvmName("ssqyrnqwjfwmrsxh")
    public suspend fun fieldSearches(vararg values: Output<StoreIndexFieldSearchArgs>) {
        this.fieldSearches = Output.all(values.asList())
    }

    /**
     * @param values List configurations of field search index. Valid item as follows:
     */
    @JvmName("jumxxxyawvfpkcie")
    public suspend fun fieldSearches(values: List<Output<StoreIndexFieldSearchArgs>>) {
        this.fieldSearches = Output.all(values)
    }

    /**
     * @param value The configuration of full text index. Valid item as follows:
     */
    @JvmName("btffejrejgfnmplr")
    public suspend fun fullText(`value`: Output<StoreIndexFullTextArgs>) {
        this.fullText = value
    }

    /**
     * @param value The log store name to the query index belongs.
     */
    @JvmName("cjdvlnwvhlmnmaxs")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("vnaryjpvpdtpekpi")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value List configurations of field search index. Valid item as follows:
     */
    @JvmName("xokebxprpxrseagi")
    public suspend fun fieldSearches(`value`: List<StoreIndexFieldSearchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldSearches = mapped
    }

    /**
     * @param argument List configurations of field search index. Valid item as follows:
     */
    @JvmName("rkmpefddcacdxjdm")
    public suspend fun fieldSearches(argument: List<suspend StoreIndexFieldSearchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StoreIndexFieldSearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSearches = mapped
    }

    /**
     * @param argument List configurations of field search index. Valid item as follows:
     */
    @JvmName("xipibfnfqyoallox")
    public suspend fun fieldSearches(vararg argument: suspend StoreIndexFieldSearchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StoreIndexFieldSearchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSearches = mapped
    }

    /**
     * @param argument List configurations of field search index. Valid item as follows:
     */
    @JvmName("xjbqrvfacclaeuvf")
    public suspend fun fieldSearches(argument: suspend StoreIndexFieldSearchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StoreIndexFieldSearchArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fieldSearches = mapped
    }

    /**
     * @param values List configurations of field search index. Valid item as follows:
     */
    @JvmName("qkthjipdmsafrcww")
    public suspend fun fieldSearches(vararg values: StoreIndexFieldSearchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSearches = mapped
    }

    /**
     * @param value The configuration of full text index. Valid item as follows:
     */
    @JvmName("cqmrwehdsmrdpfig")
    public suspend fun fullText(`value`: StoreIndexFullTextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullText = mapped
    }

    /**
     * @param argument The configuration of full text index. Valid item as follows:
     */
    @JvmName("nbasddrfcnegltgv")
    public suspend fun fullText(argument: suspend StoreIndexFullTextArgsBuilder.() -> Unit) {
        val toBeMapped = StoreIndexFullTextArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fullText = mapped
    }

    /**
     * @param value The log store name to the query index belongs.
     */
    @JvmName("hfffdtfmvgkbuvsy")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The project name to the log store belongs.
     */
    @JvmName("inahpuxglwptjluq")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): StoreIndexArgs = StoreIndexArgs(
        fieldSearches = fieldSearches,
        fullText = fullText,
        logstore = logstore,
        project = project,
    )
}
