@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertAnnotationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Annotations's key for new alert.
 * @property value Annotations's value for new alert.
 */
public data class AlertAnnotationArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertAnnotationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertAnnotationArgs =
        com.pulumi.alicloud.log.inputs.AlertAnnotationArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertAnnotationArgs].
 */
@PulumiTagMarker
public class AlertAnnotationArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Annotations's key for new alert.
     */
    @JvmName("tbqfdgmikngmadkn")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Annotations's value for new alert.
     */
    @JvmName("oxokgjoqjafyjgec")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Annotations's key for new alert.
     */
    @JvmName("akyvydfctcytxtab")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Annotations's value for new alert.
     */
    @JvmName("yhxgksynnvsgoubj")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlertAnnotationArgs = AlertAnnotationArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
