@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fields
 * @property type Group configuration type, including no_group, labels_auto, custom.
 */
public data class AlertGroupConfigurationArgs(
    public val fields: Output<List<String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs =
        com.pulumi.alicloud.log.inputs.AlertGroupConfigurationArgs.builder()
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertGroupConfigurationArgs].
 */
@PulumiTagMarker
public class AlertGroupConfigurationArgsBuilder internal constructor() {
    private var fields: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("oevspqcynvroljob")
    public suspend fun fields(`value`: Output<List<String>>) {
        this.fields = value
    }

    @JvmName("wklhshylhkwdsqpb")
    public suspend fun fields(vararg values: Output<String>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fusejwjxgujueepi")
    public suspend fun fields(values: List<Output<String>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value Group configuration type, including no_group, labels_auto, custom.
     */
    @JvmName("mpblhaxadcqpqwww")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("wjnytcbmyssxlqjj")
    public suspend fun fields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param values
     */
    @JvmName("vvbejorbubiwhteu")
    public suspend fun fields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value Group configuration type, including no_group, labels_auto, custom.
     */
    @JvmName("hlpyxvxdfxfsysko")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertGroupConfigurationArgs = AlertGroupConfigurationArgs(
        fields = fields,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
