@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property condition Join condition.
 * @property type Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
 */
public data class AlertJoinConfigurationArgs(
    public val condition: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs =
        com.pulumi.alicloud.log.inputs.AlertJoinConfigurationArgs.builder()
            .condition(condition.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertJoinConfigurationArgs].
 */
@PulumiTagMarker
public class AlertJoinConfigurationArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Join condition.
     */
    @JvmName("ajayfitsqxgbuaaq")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
     */
    @JvmName("waesygqsmquxulcc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Join condition.
     */
    @JvmName("rsibfdbmjbgqxbrr")
    public suspend fun condition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
     */
    @JvmName("fwlngiljfoumoxpb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertJoinConfigurationArgs = AlertJoinConfigurationArgs(
        condition = condition ?: throw PulumiNullFieldException("condition"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
