@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Labels's key for new alert.
 * @property value Labels's value for new alert.
 */
public data class AlertLabelArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertLabelArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertLabelArgs =
        com.pulumi.alicloud.log.inputs.AlertLabelArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertLabelArgs].
 */
@PulumiTagMarker
public class AlertLabelArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Labels's key for new alert.
     */
    @JvmName("cxplutojlqxcyleh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Labels's value for new alert.
     */
    @JvmName("seaxyvysrmkakktx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Labels's key for new alert.
     */
    @JvmName("krvdeoohjflilbug")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Labels's value for new alert.
     */
    @JvmName("hjweqxrxfxkbccrd")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlertLabelArgs = AlertLabelArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
