@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertNotificationListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property content Notice content of alarm.
 * @property emailLists Email address list.
 * @property mobileLists SMS sending mobile number.
 * @property serviceUri Request address.
 * @property type Notification type. support Email, SMS, DingTalk, MessageCenter.
 */
public data class AlertNotificationListArgs(
    public val content: Output<String>,
    public val emailLists: Output<List<String>>? = null,
    public val mobileLists: Output<List<String>>? = null,
    public val serviceUri: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertNotificationListArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertNotificationListArgs =
        com.pulumi.alicloud.log.inputs.AlertNotificationListArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .emailLists(emailLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mobileLists(mobileLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertNotificationListArgs].
 */
@PulumiTagMarker
public class AlertNotificationListArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var emailLists: Output<List<String>>? = null

    private var mobileLists: Output<List<String>>? = null

    private var serviceUri: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Notice content of alarm.
     */
    @JvmName("rfqfbqlbmlqcafnk")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Email address list.
     */
    @JvmName("ykrchleeurhjdnun")
    public suspend fun emailLists(`value`: Output<List<String>>) {
        this.emailLists = value
    }

    @JvmName("xwxlvjobuwerewwt")
    public suspend fun emailLists(vararg values: Output<String>) {
        this.emailLists = Output.all(values.asList())
    }

    /**
     * @param values Email address list.
     */
    @JvmName("ieienwdobpkjhqcg")
    public suspend fun emailLists(values: List<Output<String>>) {
        this.emailLists = Output.all(values)
    }

    /**
     * @param value SMS sending mobile number.
     */
    @JvmName("stbdaulcsshwpyxc")
    public suspend fun mobileLists(`value`: Output<List<String>>) {
        this.mobileLists = value
    }

    @JvmName("oqovqeujnprvhonl")
    public suspend fun mobileLists(vararg values: Output<String>) {
        this.mobileLists = Output.all(values.asList())
    }

    /**
     * @param values SMS sending mobile number.
     */
    @JvmName("ggpfxddaxbhiivoq")
    public suspend fun mobileLists(values: List<Output<String>>) {
        this.mobileLists = Output.all(values)
    }

    /**
     * @param value Request address.
     */
    @JvmName("dnnnatgavbxlvrpk")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value Notification type. support Email, SMS, DingTalk, MessageCenter.
     */
    @JvmName("tngrshimkhqvdtyo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Notice content of alarm.
     */
    @JvmName("ggjypihnylvahdhh")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Email address list.
     */
    @JvmName("eiufoabagsiedomq")
    public suspend fun emailLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailLists = mapped
    }

    /**
     * @param values Email address list.
     */
    @JvmName("qrbqtgtfsmviggks")
    public suspend fun emailLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailLists = mapped
    }

    /**
     * @param value SMS sending mobile number.
     */
    @JvmName("ddbcsynplaswwaxl")
    public suspend fun mobileLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileLists = mapped
    }

    /**
     * @param values SMS sending mobile number.
     */
    @JvmName("vhedpfgrdnlxpnlo")
    public suspend fun mobileLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mobileLists = mapped
    }

    /**
     * @param value Request address.
     */
    @JvmName("yvhccxouiffyquqq")
    public suspend fun serviceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    /**
     * @param value Notification type. support Email, SMS, DingTalk, MessageCenter.
     */
    @JvmName("vvdvgiirryhdwmrb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertNotificationListArgs = AlertNotificationListArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        emailLists = emailLists,
        mobileLists = mobileLists,
        serviceUri = serviceUri,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
