@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionPolicyId Action Policy Id.
 * @property alertPolicyId Alert Policy Id.
 * @property repeatInterval Repeat interval used by alert policy, 1h, 1m.e.g.
 */
public data class AlertPolicyConfigurationArgs(
    public val actionPolicyId: Output<String>? = null,
    public val alertPolicyId: Output<String>,
    public val repeatInterval: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs =
        com.pulumi.alicloud.log.inputs.AlertPolicyConfigurationArgs.builder()
            .actionPolicyId(actionPolicyId?.applyValue({ args0 -> args0 }))
            .alertPolicyId(alertPolicyId.applyValue({ args0 -> args0 }))
            .repeatInterval(repeatInterval.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class AlertPolicyConfigurationArgsBuilder internal constructor() {
    private var actionPolicyId: Output<String>? = null

    private var alertPolicyId: Output<String>? = null

    private var repeatInterval: Output<String>? = null

    /**
     * @param value Action Policy Id.
     */
    @JvmName("ergbghfryajoetdw")
    public suspend fun actionPolicyId(`value`: Output<String>) {
        this.actionPolicyId = value
    }

    /**
     * @param value Alert Policy Id.
     */
    @JvmName("alxvxnpbocsymmgr")
    public suspend fun alertPolicyId(`value`: Output<String>) {
        this.alertPolicyId = value
    }

    /**
     * @param value Repeat interval used by alert policy, 1h, 1m.e.g.
     */
    @JvmName("joxtrhqgbhehofhu")
    public suspend fun repeatInterval(`value`: Output<String>) {
        this.repeatInterval = value
    }

    /**
     * @param value Action Policy Id.
     */
    @JvmName("nxevppmwrgeruhso")
    public suspend fun actionPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPolicyId = mapped
    }

    /**
     * @param value Alert Policy Id.
     */
    @JvmName("cmlmvjjsfnfektiw")
    public suspend fun alertPolicyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertPolicyId = mapped
    }

    /**
     * @param value Repeat interval used by alert policy, 1h, 1m.e.g.
     */
    @JvmName("lcoainhnfurrmxko")
    public suspend fun repeatInterval(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatInterval = mapped
    }

    internal fun build(): AlertPolicyConfigurationArgs = AlertPolicyConfigurationArgs(
        actionPolicyId = actionPolicyId,
        alertPolicyId = alertPolicyId ?: throw PulumiNullFieldException("alertPolicyId"),
        repeatInterval = repeatInterval ?: throw PulumiNullFieldException("repeatInterval"),
    )
}
