@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertQueryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property chartTitle Chart title, optional from 1.161.0+.
 * @property dashboardId Query dashboard id.
 * @property end End time. example: 20s.
 * @property logstore Query logstore, use store for new alert, Deprecated from 1.161.0+.
 * @property powerSqlMode default disable, whether to use power sql. support auto, enable, disable.
 * @property project Query project.
 * @property query Query corresponding to chart. example: * AND aliyun.
 * @property region Query project region.
 * @property roleArn Query project store's ARN.
 * @property start Begin time. example: -60s.
 * @property store Query store for new alert.
 * @property storeType Query store type for new alert, including log,metric,meta.
 * @property timeSpanType default Custom. No need to configure this parameter.
 */
public data class AlertQueryListArgs(
    public val chartTitle: Output<String>? = null,
    public val dashboardId: Output<String>? = null,
    public val end: Output<String>,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use store
  """,
    )
    public val logstore: Output<String>? = null,
    public val powerSqlMode: Output<String>? = null,
    public val project: Output<String>? = null,
    public val query: Output<String>,
    public val region: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val start: Output<String>,
    public val store: Output<String>? = null,
    public val storeType: Output<String>? = null,
    public val timeSpanType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertQueryListArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertQueryListArgs =
        com.pulumi.alicloud.log.inputs.AlertQueryListArgs.builder()
            .chartTitle(chartTitle?.applyValue({ args0 -> args0 }))
            .dashboardId(dashboardId?.applyValue({ args0 -> args0 }))
            .end(end.applyValue({ args0 -> args0 }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .powerSqlMode(powerSqlMode?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .query(query.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .start(start.applyValue({ args0 -> args0 }))
            .store(store?.applyValue({ args0 -> args0 }))
            .storeType(storeType?.applyValue({ args0 -> args0 }))
            .timeSpanType(timeSpanType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertQueryListArgs].
 */
@PulumiTagMarker
public class AlertQueryListArgsBuilder internal constructor() {
    private var chartTitle: Output<String>? = null

    private var dashboardId: Output<String>? = null

    private var end: Output<String>? = null

    private var logstore: Output<String>? = null

    private var powerSqlMode: Output<String>? = null

    private var project: Output<String>? = null

    private var query: Output<String>? = null

    private var region: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var start: Output<String>? = null

    private var store: Output<String>? = null

    private var storeType: Output<String>? = null

    private var timeSpanType: Output<String>? = null

    /**
     * @param value Chart title, optional from 1.161.0+.
     */
    @JvmName("lievfwhoilalwqvx")
    public suspend fun chartTitle(`value`: Output<String>) {
        this.chartTitle = value
    }

    /**
     * @param value Query dashboard id.
     */
    @JvmName("cfresmpyhelyflch")
    public suspend fun dashboardId(`value`: Output<String>) {
        this.dashboardId = value
    }

    /**
     * @param value End time. example: 20s.
     */
    @JvmName("ecgtuyeifmwepskv")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value Query logstore, use store for new alert, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use store
  """,
    )
    @JvmName("ssccnthsnuahoyhh")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value default disable, whether to use power sql. support auto, enable, disable.
     */
    @JvmName("gfykggxkmfuliyya")
    public suspend fun powerSqlMode(`value`: Output<String>) {
        this.powerSqlMode = value
    }

    /**
     * @param value Query project.
     */
    @JvmName("aywwixhuyyneuhqw")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Query corresponding to chart. example: * AND aliyun.
     */
    @JvmName("vjuwpxthyqjdwkga")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Query project region.
     */
    @JvmName("hilibebvsxblfxbj")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Query project store's ARN.
     */
    @JvmName("rvnlopugewjgqetb")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Begin time. example: -60s.
     */
    @JvmName("sqildrgouibugshy")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value Query store for new alert.
     */
    @JvmName("lapilxwvjebclqlk")
    public suspend fun store(`value`: Output<String>) {
        this.store = value
    }

    /**
     * @param value Query store type for new alert, including log,metric,meta.
     */
    @JvmName("vagcsmqosevqgmlw")
    public suspend fun storeType(`value`: Output<String>) {
        this.storeType = value
    }

    /**
     * @param value default Custom. No need to configure this parameter.
     */
    @JvmName("hikxmtcevudijimj")
    public suspend fun timeSpanType(`value`: Output<String>) {
        this.timeSpanType = value
    }

    /**
     * @param value Chart title, optional from 1.161.0+.
     */
    @JvmName("vieawbhxwlldeijx")
    public suspend fun chartTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chartTitle = mapped
    }

    /**
     * @param value Query dashboard id.
     */
    @JvmName("libashjobuljejid")
    public suspend fun dashboardId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardId = mapped
    }

    /**
     * @param value End time. example: 20s.
     */
    @JvmName("neoyommudtlsblqb")
    public suspend fun end(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Query logstore, use store for new alert, Deprecated from 1.161.0+.
     */
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use store
  """,
    )
    @JvmName("wtxxsemktnlmaijy")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value default disable, whether to use power sql. support auto, enable, disable.
     */
    @JvmName("tjafiwetiagkdbgm")
    public suspend fun powerSqlMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerSqlMode = mapped
    }

    /**
     * @param value Query project.
     */
    @JvmName("hwtoymfbfudjsxjx")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Query corresponding to chart. example: * AND aliyun.
     */
    @JvmName("uoudjidydugwtdcj")
    public suspend fun query(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Query project region.
     */
    @JvmName("lqaldsnckfcqmdjw")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Query project store's ARN.
     */
    @JvmName("ciwtyuwjgikvayss")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Begin time. example: -60s.
     */
    @JvmName("txspfycyvsglcaip")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value Query store for new alert.
     */
    @JvmName("picxraovqjrrkiki")
    public suspend fun store(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.store = mapped
    }

    /**
     * @param value Query store type for new alert, including log,metric,meta.
     */
    @JvmName("jwtvmhieptjtwtmv")
    public suspend fun storeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value default Custom. No need to configure this parameter.
     */
    @JvmName("hvdklvtmjfhipxjw")
    public suspend fun timeSpanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSpanType = mapped
    }

    internal fun build(): AlertQueryListArgs = AlertQueryListArgs(
        chartTitle = chartTitle,
        dashboardId = dashboardId,
        end = end ?: throw PulumiNullFieldException("end"),
        logstore = logstore,
        powerSqlMode = powerSqlMode,
        project = project,
        query = query ?: throw PulumiNullFieldException("query"),
        region = region,
        roleArn = roleArn,
        start = start ?: throw PulumiNullFieldException("start"),
        store = store,
        storeType = storeType,
        timeSpanType = timeSpanType,
    )
}
