@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cronExpression Cron expression when type is Cron.
 * @property dayOfWeek Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
 * @property delay
 * @property hour Hour of day when type is Weekly/Daily.
 * @property interval Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
 * @property runImmediately
 * @property timeZone Time zone for schedule.
 * @property type including FixedRate,Hourly,Daily,Weekly,Cron.
 */
public data class AlertScheduleArgs(
    public val cronExpression: Output<String>? = null,
    public val dayOfWeek: Output<Int>? = null,
    public val delay: Output<Int>? = null,
    public val hour: Output<Int>? = null,
    public val interval: Output<String>? = null,
    public val runImmediately: Output<Boolean>? = null,
    public val timeZone: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertScheduleArgs =
        com.pulumi.alicloud.log.inputs.AlertScheduleArgs.builder()
            .cronExpression(cronExpression?.applyValue({ args0 -> args0 }))
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0 }))
            .delay(delay?.applyValue({ args0 -> args0 }))
            .hour(hour?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .runImmediately(runImmediately?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertScheduleArgs].
 */
@PulumiTagMarker
public class AlertScheduleArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    private var dayOfWeek: Output<Int>? = null

    private var delay: Output<Int>? = null

    private var hour: Output<Int>? = null

    private var interval: Output<String>? = null

    private var runImmediately: Output<Boolean>? = null

    private var timeZone: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cron expression when type is Cron.
     */
    @JvmName("kengpndyrvvgifop")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
     */
    @JvmName("rvjvhmhjhxvhywxr")
    public suspend fun dayOfWeek(`value`: Output<Int>) {
        this.dayOfWeek = value
    }

    /**
     * @param value
     */
    @JvmName("fqfuvmlvrlxheyev")
    public suspend fun delay(`value`: Output<Int>) {
        this.delay = value
    }

    /**
     * @param value Hour of day when type is Weekly/Daily.
     */
    @JvmName("wrislwlaocdxahwc")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
     */
    @JvmName("ifhphmbsdmmnpnql")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value
     */
    @JvmName("wvlxxwxgdstitkol")
    public suspend fun runImmediately(`value`: Output<Boolean>) {
        this.runImmediately = value
    }

    /**
     * @param value Time zone for schedule.
     */
    @JvmName("pyqoxjrpbhagcwxq")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value including FixedRate,Hourly,Daily,Weekly,Cron.
     */
    @JvmName("sjbschqbrcnbpukn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cron expression when type is Cron.
     */
    @JvmName("yvcaevmsegefrpol")
    public suspend fun cronExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    /**
     * @param value Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
     */
    @JvmName("unimiqxhlgtapkll")
    public suspend fun dayOfWeek(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value
     */
    @JvmName("milsrqkdsllwourf")
    public suspend fun delay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delay = mapped
    }

    /**
     * @param value Hour of day when type is Weekly/Daily.
     */
    @JvmName("ykfwvhdbjgcfcwso")
    public suspend fun hour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    /**
     * @param value Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
     */
    @JvmName("dkxroobjafwlesfc")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value
     */
    @JvmName("adddjxynxhooxsxg")
    public suspend fun runImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runImmediately = mapped
    }

    /**
     * @param value Time zone for schedule.
     */
    @JvmName("wksesstrvihekafi")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value including FixedRate,Hourly,Daily,Weekly,Cron.
     */
    @JvmName("rujipodcjnttelqm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertScheduleArgs = AlertScheduleArgs(
        cronExpression = cronExpression,
        dayOfWeek = dayOfWeek,
        delay = delay,
        hour = hour,
        interval = interval,
        runImmediately = runImmediately,
        timeZone = timeZone,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
