@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property evalCondition Severity when this condition is met.
 * @property severity Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
 */
public data class AlertSeverityConfigurationArgs(
    public val evalCondition: Output<Map<String, String>>,
    public val severity: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs =
        com.pulumi.alicloud.log.inputs.AlertSeverityConfigurationArgs.builder()
            .evalCondition(
                evalCondition.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .severity(severity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertSeverityConfigurationArgs].
 */
@PulumiTagMarker
public class AlertSeverityConfigurationArgsBuilder internal constructor() {
    private var evalCondition: Output<Map<String, String>>? = null

    private var severity: Output<Int>? = null

    /**
     * @param value Severity when this condition is met.
     */
    @JvmName("hgmmhcndbcuonbxq")
    public suspend fun evalCondition(`value`: Output<Map<String, String>>) {
        this.evalCondition = value
    }

    /**
     * @param value Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
     */
    @JvmName("tanipopkmrfhhxgm")
    public suspend fun severity(`value`: Output<Int>) {
        this.severity = value
    }

    /**
     * @param value Severity when this condition is met.
     */
    @JvmName("auipiimgofsnsnsu")
    public suspend fun evalCondition(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evalCondition = mapped
    }

    /**
     * @param values Severity when this condition is met.
     */
    @JvmName("xwoginvmnumidtdj")
    public fun evalCondition(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evalCondition = mapped
    }

    /**
     * @param value Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
     */
    @JvmName("pnbnkrhxuespwfef")
    public suspend fun severity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    internal fun build(): AlertSeverityConfigurationArgs = AlertSeverityConfigurationArgs(
        evalCondition = evalCondition ?: throw PulumiNullFieldException("evalCondition"),
        severity = severity ?: throw PulumiNullFieldException("severity"),
    )
}
